/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.block;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import com.gly091020.NetMusicList;
import com.gly091020.packet.PlayEnderMusicPlayerPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EnderMusicPlayerEntity
extends BlockEntity {
    private final TileEntityMusicPlayer originalPlayer;
    private static final String PlayerListKey = "players";
    private final List<UUID> players = new ArrayList<UUID>();

    public EnderMusicPlayerEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)NetMusicList.ENDER_MUSIC_PLAYER_TYPE.get(), blockPos, blockState);
        this.originalPlayer = new TileEntityMusicPlayer(blockPos, blockState);
    }

    public ItemStackHandler getPlayerInv() {
        return this.originalPlayer.getPlayerInv();
    }

    public boolean isPlay() {
        return this.originalPlayer.isPlay();
    }

    public void setPlay(boolean play) {
        this.originalPlayer.setPlay(play);
        this.m_6596_();
    }

    public void setPlayToClient(ItemMusicCD.SongInfo info) {
        this.originalPlayer.setCurrentTime(info.songTime * 20 + 64);
        this.setPlay(true);
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            PlayEnderMusicPlayerPacket msg = new PlayEnderMusicPlayerPacket(this.f_58858_, info.songUrl, info.songTime, info.songName);
            this.sendToNearby(this.f_58857_, this.f_58858_, msg);
        }
    }

    public void sendToNearby(Level world, BlockPos pos, Object toSend) {
        if (world instanceof ServerLevel) {
            ServerLevel ws = (ServerLevel)world;
            ws.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 9216.0).forEach(p -> {
                if (!this.players.isEmpty() && !this.players.contains(p.m_20148_())) {
                    return;
                }
                NetMusicList.CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), toSend);
            });
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        ListTag playersTag = new ListTag();
        this.players.forEach(uuid -> playersTag.add((Object)StringTag.m_129297_((String)uuid.toString())));
        compound.m_128365_(PlayerListKey, (Tag)playersTag);
        this.originalPlayer.m_183515_(compound);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.players.clear();
        if (nbt.m_128425_(PlayerListKey, 9)) {
            for (Tag tag : nbt.m_128437_(PlayerListKey, 8)) {
                if (!(tag instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)tag;
                try {
                    this.players.add(UUID.fromString(stringTag.m_7916_()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        this.originalPlayer.m_142466_(nbt);
    }

    public void addPlayer(UUID uuid) {
        this.players.add(uuid);
        this.markDirty();
    }

    public boolean hasPlayer(UUID uuid) {
        return this.players.contains(uuid);
    }

    public void removePlayer(UUID uuid) {
        if (this.hasPlayer(uuid)) {
            this.players.remove(uuid);
            this.markDirty();
        }
    }

    public void markDirty() {
        this.originalPlayer.markDirty();
        this.m_6596_();
    }

    @NotNull
    public CompoundTag m_5995_() {
        ListTag playersTag = new ListTag();
        this.players.forEach(uuid -> playersTag.add((Object)StringTag.m_129297_((String)uuid.toString())));
        CompoundTag tag = this.originalPlayer.m_5995_();
        tag.m_128365_(PlayerListKey, (Tag)playersTag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.players.clear();
        this.originalPlayer.handleUpdateTag(tag);
        if (tag.m_128425_(PlayerListKey, 9)) {
            for (Tag tag1 : tag.m_128437_(PlayerListKey, 8)) {
                if (!(tag1 instanceof StringTag)) continue;
                StringTag stringTag = (StringTag)tag1;
                try {
                    this.players.add(UUID.fromString(stringTag.m_7916_()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        super.handleUpdateTag(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

