/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.item;

import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.gly091020.NetMusicList;
import com.gly091020.hud.MusicListLayer;
import com.gly091020.item.MusicPlayerContainer;
import com.gly091020.item.NetMusicListItem;
import com.gly091020.packet.PlayerPlayMusicPacket;
import com.gly091020.packet.UpdatePlayerMusicPacket;
import com.gly091020.util.NetMusicListUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetMusicPlayerItem
extends Item {
    public NetMusicPlayerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack stack1, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action == ClickAction.SECONDARY && !NetMusicPlayerItem.getContainer(stack).m_7983_() && access.m_142196_().m_41619_()) {
            access.m_142104_(NetMusicPlayerItem.getContainer(stack).m_7407_(0, 1));
            return true;
        }
        if (action == ClickAction.PRIMARY && ItemMusicCD.getSongInfo((ItemStack)stack1) != null & NetMusicPlayerItem.getContainer(stack).m_7983_()) {
            NetMusicPlayerItem.getContainer(stack).m_6836_(0, stack1);
            access.m_142104_(ItemStack.f_41583_);
            NetMusicPlayerItem.playSound(stack, player, slot.getSlotIndex());
            return true;
        }
        return super.m_142305_(stack, stack1, slot, action, player, access);
    }

    public static void playSound(ItemStack stack, Player player, int slot) {
        ItemStack i = NetMusicPlayerItem.getContainer(stack).m_8020_(0);
        if (!i.m_150930_((Item)InitItems.MUSIC_CD.get()) && !i.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            return;
        }
        ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo((ItemStack)i);
        if (!NetMusicListUtil.hasLoginNeed() && info.vip && player.m_9236_().f_46443_) {
            player.m_213846_((Component)Component.m_237115_((String)"message.netmusic.music_player.need_vip").m_130940_(ChatFormatting.RED));
            return;
        }
        stack.m_41784_().m_128405_("tick", info.songTime * 20);
        stack.m_41784_().m_128405_("waitSong", 0);
        if (stack.m_41784_().m_128441_("shadowTick")) {
            stack.m_41784_().m_128405_("shadowTick", info.songTime * 20);
        }
        if (!player.m_9236_().f_46443_) {
            return;
        }
        NetMusicList.CHANNEL.sendToServer((Object)new PlayerPlayMusicPacket(player.m_19879_(), info.songUrl, info.songTime, info.songName, slot, info));
    }

    public static void sendPacket(ItemStack stack, Player player, int slot) {
        ItemStack i = NetMusicPlayerItem.getContainer(stack).m_8020_(0);
        if (!i.m_150930_((Item)InitItems.MUSIC_CD.get()) && !i.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            return;
        }
        ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo((ItemStack)i);
        if (!NetMusicListUtil.hasLoginNeed() && info.vip) {
            return;
        }
        if (!player.m_9236_().f_46443_) {
            NetMusicList.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PlayerPlayMusicPacket(player.m_19879_(), info.songUrl, info.songTime, info.songName, slot, info));
        } else {
            NetMusicList.CHANNEL.sendToServer((Object)new PlayerPlayMusicPacket(player.m_19879_(), info.songUrl, info.songTime, info.songName, slot, info));
        }
    }

    public static MusicPlayerContainer getContainer(ItemStack stack) {
        return new MusicPlayerContainer(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        MusicPlayerContainer c = NetMusicPlayerItem.getContainer(stack);
        Object t = c.m_7983_() ? Component.m_237115_((String)"item.net_music_player.empty").m_130940_(ChatFormatting.RED) : c.m_8020_(0).m_41786_();
        components.add((Component)Component.m_237110_((String)"item.net_music_player.tip", (Object[])new Object[]{t}));
        ItemStack i = NetMusicPlayerItem.getContainer(stack).m_8020_(0);
        i.m_41720_().m_7373_(i, level, components, flag);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return Component.m_237115_((String)"item.net_music_list.music_player");
    }

    public boolean m_142207_(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        ItemStack i = NetMusicPlayerItem.getContainer(stack).m_8020_(0);
        if (ItemMusicCD.getSongInfo((ItemStack)i) != null) {
            NetMusicPlayerItem.playSound(stack, player, slot.getSlotIndex());
        }
        return false;
    }

    public static void nextMusic(ItemStack stack, Player player, int slot) {
        ItemStack i = NetMusicPlayerItem.getContainer(stack).m_8020_(0);
        if (i.m_150930_((Item)NetMusicList.MUSIC_LIST_ITEM.get())) {
            NetMusicListItem.nextMusic(i);
        }
        NetMusicPlayerItem.playSound(stack, player, slot);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean b) {
        super.m_6883_(stack, level, entity, slot, b);
        int t = stack.m_41784_().m_128451_("tick");
        int shadowTick = stack.m_41784_().m_128451_("shadowTick");
        int waitSong = stack.m_41784_().m_128451_("waitSong");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (waitSong == 2 && t < 1) {
                NetMusicPlayerItem.nextMusic(stack, player, slot);
                return;
            }
        }
        if (t == -1 && shadowTick > -1 && shadowTick < 4) {
            stack.m_41784_().m_128405_("waitSong", waitSong + 1);
        }
        if (t > 0) {
            stack.m_41784_().m_128405_("shadowTick", t);
            stack.m_41784_().m_128405_("tick", t - 1);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        if (!level.f_46443_) {
            return super.m_7203_(level, player, usedHand);
        }
        if (MusicListLayer.isRender) {
            NetMusicListUtil.playSound(SoundEvents.f_11871_);
            MusicPlayerContainer container = NetMusicPlayerItem.getContainer(player.m_21120_(usedHand));
            ItemStack item = container.m_8020_(0);
            Integer index = NetMusicListItem.getSongIndex(item);
            if (MusicListLayer.index != index) {
                NetMusicListItem.setSongIndex(item, MusicListLayer.index);
                container.m_6836_(0, item);
                int slot = player.m_150109_().m_36030_(player.m_21120_(usedHand));
                NetMusicPlayerItem.playSound(player.m_21120_(usedHand), player, slot);
                NetMusicList.CHANNEL.sendToServer((Object)new UpdatePlayerMusicPacket(MusicListLayer.index, slot));
            }
            MusicListLayer.isRender = false;
            return InteractionResultHolder.m_19090_((Object)player.m_21205_());
        }
        MusicListLayer.isRender = true;
        return InteractionResultHolder.m_19090_((Object)player.m_21205_());
    }
}

