/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.mixin;

import com.github.tartaricacid.netmusic.client.gui.CDBurnerMenuScreen;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.gly091020.util.NetMusicListUtil;
import com.gly091020.util.URLType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CDBurnerMenuScreen.class}, remap=false)
public class BurnerSongListMixin {
    @Shadow
    private EditBox textField;
    @Shadow
    private Component tips;
    @Shadow
    private Checkbox readOnlyButton;
    @Unique
    private static final Pattern LIST_ID_REG = Pattern.compile("^list/(\\d+)$");
    @Unique
    private String netmusiclistforge$idTip;

    @Inject(method={"handleCraftButton"}, at={@At(value="INVOKE", target="Ljava/util/regex/Matcher;matches()Z")}, cancellable=true)
    public void onCraft(CallbackInfo ci) {
        Matcher matcher = LIST_ID_REG.matcher(this.textField.m_94155_());
        if (matcher.find()) {
            long listID = Long.parseLong(matcher.group(1));
            try {
                List<ItemMusicCD.SongInfo> songs = NetMusicListUtil.getMusicList(listID);
                if (!songs.isEmpty()) {
                    for (ItemMusicCD.SongInfo info : songs) {
                        info.readOnly = this.readOnlyButton.m_93840_();
                        NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(info));
                    }
                }
            }
            catch (Exception e) {
                this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
            }
            ci.cancel();
        }
    }

    @Inject(method={"handleCraftButton"}, at={@At(value="HEAD")})
    public void setId(CallbackInfo ci) {
        if (this.netmusiclistforge$idTip != null && this.textField.m_94155_().isEmpty()) {
            this.textField.m_94144_(this.netmusiclistforge$idTip);
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)I"), remap=true)
    public int renderTip(GuiGraphics instance, Font font, Component component, int left, int top, int color, boolean b) {
        return instance.m_280614_(font, (Component)(this.netmusiclistforge$idTip == null ? component : Component.m_237113_((String)this.netmusiclistforge$idTip).m_130940_(ChatFormatting.ITALIC)), left, top, color, b);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")}, remap=true)
    public void addTip(CallbackInfo ci) {
        String clipBoard = Minecraft.m_91087_().f_91068_.m_90876_();
        String m = URLType.SONG.getMatch(clipBoard);
        if (m != null) {
            this.netmusiclistforge$idTip = m;
        }
        if ((m = URLType.DJ.getMatch(clipBoard)) != null) {
            this.netmusiclistforge$idTip = "dj/" + m;
        }
        if ((m = URLType.SONG_LIST.getMatch(clipBoard)) != null) {
            this.netmusiclistforge$idTip = "list/" + m;
        }
    }
}

