/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.mixin;

import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.client.audio.NetMusicSound;
import com.github.tartaricacid.netmusic.network.message.MusicToClientMessage;
import com.gly091020.util.CacheManager;
import com.gly091020.util.NetMusicListUtil;
import net.minecraft.core.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicToClientMessage.class}, remap=false)
public class LyricCacheMixin {
    @Inject(method={"onHandle"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getLyric(MusicToClientMessage message, CallbackInfo ci) {
        UrlGetter getter = (UrlGetter)message;
        try {
            long id = NetMusicListUtil.getIdFromUrl(getter.getUrl());
            NetMusicListUtil.Lyric lyric = CacheManager.getLycCache(id);
            if (lyric == null) {
                return;
            }
            MusicPlayManager.play((String)getter.getUrl(), (String)getter.getSongName(), url -> new NetMusicSound(getter.getPos(), url, getter.getTimeSecond(), lyric.toLyricRecord()));
            ci.cancel();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Mixin(value={MusicToClientMessage.class}, remap=false)
    private static interface UrlGetter {
        @Accessor
        public String getUrl();

        @Accessor
        public BlockPos getPos();

        @Accessor
        public int getTimeSecond();

        @Accessor
        public String getSongName();
    }
}

