/*
 * Decompiled with CFR 0.152.
 */
package com.gly091020.util;

import com.gly091020.NetMusicList;
import com.gly091020.item.NetMusicPlayerItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="net_music_list")
public class EventHandler {
    @SubscribeEvent
    public static void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EventHandler.handlePlayerEvent((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onSpawn(PlayerEvent.PlayerRespawnEvent event) {
        EventHandler.handlePlayerEvent((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EventHandler.handlePlayerEvent((PlayerEvent)event);
    }

    private static void handlePlayerEvent(PlayerEvent event) {
        if (EventHandler.hasPlayer(event.getEntity())) {
            EventHandler.playerPlayMusic(event.getEntity());
        }
    }

    private static boolean hasPlayer(Player player) {
        return player.m_150109_().m_18947_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get()) > 0;
    }

    private static void playerPlayMusic(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!stack.m_150930_((Item)NetMusicList.MUSIC_PLAYER_ITEM.get())) continue;
            NetMusicPlayerItem.playSound(stack, player, player.m_150109_().m_36030_(stack));
            NetMusicPlayerItem.sendPacket(stack, player, player.m_150109_().m_36030_(stack));
        }
    }
}

