/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.economy.Economy;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.ecobalancer.commands.EcoTabCompleter;
import org.cubexmc.ecobalancer.commands.UtilCommand;
import org.cubexmc.ecobalancer.listeners.AdminLoginListener;
import org.cubexmc.ecobalancer.metrics.Metrics;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.PlaytimeUtils;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;
import org.cubexmc.ecobalancer.utils.VaultUtils;

public final class EcoBalancer
extends JavaPlugin {
    private static Economy econ = null;
    private boolean deductBasedOnTime;
    private int inactiveDaysToDeduct;
    private TreeMap<Integer, Double> taxBrackets = new TreeMap();
    private int inactiveDaysToClear;
    private boolean onlyOfflinePlayers;
    private FileHandler fileHandler;
    private Logger fileLogger = Logger.getLogger("EcoBalancerFileLogger");
    private int recordRetentionDays;
    private String scheduleType;
    private List<Integer> scheduleDaysOfWeek;
    private List<Integer> scheduleDatesOfMonth;
    private String checkTime;
    private FileConfiguration langConfig;
    private boolean taxAccount;
    private String taxAccountName;
    private String messagePrefix;

    private void initFileLogger(boolean rotateExisting) {
        File logDir = new File(this.getDataFolder() + File.separator + "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if (rotateExisting) {
            File existingLogFile;
            File lockFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log.lck");
            if (lockFile.exists()) {
                lockFile.delete();
            }
            if ((existingLogFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
                this.compressExistingLogFile(existingLogFile);
            }
        }
        try {
            this.fileHandler = new FileHandler(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log", true);
            this.fileHandler.setFormatter(new SimpleFormatter());
            this.fileLogger.addHandler(this.fileHandler);
            this.fileLogger.setUseParentHandlers(false);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not create the log file handler for EcoBalancer.");
            e.printStackTrace();
        }
    }

    private void updateFileLoggerFromConfig() {
        boolean enable = this.getConfig().getBoolean("file-logging", true);
        if (enable) {
            if (this.fileHandler == null) {
                this.initFileLogger(false);
            }
        } else if (this.fileHandler != null) {
            try {
                this.fileLogger.removeHandler(this.fileHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.fileHandler.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fileHandler = null;
        }
    }

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            VaultUtils.setupEconomy(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveDefaultConfig();
        this.loadConfiguration();
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        if (!databaseFile.exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("\u65e0\u6cd5\u521b\u5efa\u6570\u636e\u5e93\u6587\u4ef6: " + e.getMessage());
            }
        }
        DatabaseUtils.initializeTables((Plugin)this, this.getLogger());
        long initialDelay = this.calculateDelayForDaily(Calendar.getInstance(), 0, 0);
        long cleanupPeriod = 1728000L;
        SchedulerUtils.runTaskTimer((Plugin)this, this::cleanupRecords, initialDelay, cleanupPeriod);
        if (this.getConfig().getBoolean("file-logging", true)) {
            this.initFileLogger(true);
        }
        int pluginId = 20269;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
        if (this.taxAccount && !econ.hasAccount(this.taxAccountName)) {
            econ.createPlayerAccount(this.taxAccountName);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new AdminLoginListener(this), (Plugin)this);
        UtilCommand util = new UtilCommand(this);
        if (this.getCommand("ecobal") != null) {
            this.getCommand("ecobal").setExecutor((CommandExecutor)util);
            this.getCommand("ecobal").setTabCompleter((TabCompleter)new EcoTabCompleter(this, util));
        } else {
            this.getLogger().severe("Command 'ecobal' not found in plugin.yml. Tab completer not registered.");
        }
        this.displayAsciiArt();
        this.getLogger().info("EcoBalancer enabled!");
        if (SchedulerUtils.isFolia()) {
            this.getLogger().info("Folia support is enabled!");
        } else {
            this.getLogger().info("Running on standard Bukkit/Spigot server");
        }
        try {
            String statsWorld = this.getConfig().getString("stats-world", "");
            PlaytimeUtils.loadAllAsync(this, statsWorld);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void displayAsciiArt() {
        String[] asciiArt = new String[]{"\u2593\u2588\u2588\u2588\u2588\u2588  \u2584\u2588\u2588\u2588\u2588\u2584   \u2592\u2588\u2588\u2588\u2588\u2588   \u2584\u2584\u2584\u2584    \u2584\u2584\u2584       \u2588\u2588\u2593    ", "\u2593\u2588   \u2580 \u2592\u2588\u2588\u2580 \u2580\u2588  \u2592\u2588\u2588\u2592  \u2588\u2588\u2592\u2593\u2588\u2588\u2588\u2588\u2588\u2584 \u2592\u2588\u2588\u2588\u2588\u2584    \u2593\u2588\u2588\u2592    ", "\u2592\u2588\u2588\u2588   \u2592\u2593\u2588    \u2584 \u2592\u2588\u2588\u2591  \u2588\u2588\u2592\u2592\u2588\u2588\u2592 \u2584\u2588\u2588\u2592\u2588\u2588  \u2580\u2588\u2584  \u2592\u2588\u2588\u2591    ", "\u2592\u2593\u2588  \u2584 \u2592\u2593\u2593\u2584 \u2584\u2588\u2588\u2592\u2592\u2588\u2588   \u2588\u2588\u2591\u2592\u2588\u2588\u2591\u2588\u2580  \u2591\u2588\u2588\u2584\u2584\u2584\u2584\u2588\u2588 \u2592\u2588\u2588\u2591    ", "\u2591\u2592\u2588\u2588\u2588\u2588\u2592\u2592 \u2593\u2588\u2588\u2588\u2580 \u2591\u2591 \u2588\u2588\u2588\u2588\u2593\u2592\u2591\u2591\u2593\u2588  \u2580\u2588\u2593 \u2593\u2588   \u2593\u2588\u2588\u2592\u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2592", "\u2591\u2591 \u2592\u2591 \u2591\u2591 \u2591\u2592 \u2592  \u2591\u2591 \u2592\u2591\u2592\u2591\u2592\u2591 \u2591\u2592\u2593\u2588\u2588\u2588\u2580\u2592 \u2592\u2592   \u2593\u2592\u2588\u2591\u2591 \u2592\u2591\u2593  \u2591", " \u2591 \u2591  \u2591  \u2591  \u2592     \u2591 \u2592 Version: " + this.getDescription().getVersion(), "   \u2591   \u2591        \u2591 \u2591 \u2591 Author: " + (String)this.getDescription().getAuthors().get(0), "   \u2591  \u2591\u2591 \u2591          \u2591 Website: " + this.getDescription().getWebsite(), "                      Powered by CubeX"};
        String ANSI_RESET = "\u001b[0m";
        String ANSI_YELLOW = "\u001b[33m";
        String ANSI_RED = "\u001b[31m";
        String ANSI_WHITE = "\u001b[37m";
        this.getLogger().info("");
        for (int i = 0; i < asciiArt.length; ++i) {
            String line = asciiArt[i];
            if (i < 6) {
                line = "\u001b[33m" + line + "\u001b[0m";
            } else if (i < 9) {
                line = "\u001b[33m" + line.substring(0, 21) + "\u001b[0m" + line.substring(21) + "\u001b[0m";
            } else if (i == 9) {
                line = line.replace("Cube", "\u001b[31mCube\u001b[37m").replace("X", "\u001b[37mX\u001b[0m");
            }
            this.getLogger().info(line);
        }
        this.getLogger().info("");
    }

    public boolean useTaxAccount() {
        return this.taxAccount;
    }

    public String getTaxAccountName() {
        return this.taxAccountName;
    }

    public String getTaxAccountBalance() {
        return String.format("%.2f", econ.getBalance(this.taxAccountName));
    }

    public void loadConfiguration() {
        SchedulerUtils.cancelAllTasks((Plugin)this);
        this.loadLangFile();
        this.messagePrefix = this.langConfig.getString("prefix", "&7[&6EcoBalancer&7]&r");
        this.updateFileLoggerFromConfig();
        this.recordRetentionDays = this.getConfig().getInt("record-retention-days", 30);
        this.scheduleType = this.getConfig().getString("check-schedule.type", "daily");
        this.scheduleDaysOfWeek = this.getConfig().getIntegerList("check-schedule.days-of-week");
        this.scheduleDatesOfMonth = this.getConfig().getIntegerList("check-schedule.dates-of-month");
        this.checkTime = this.getConfig().getString("check-time", "01:00");
        this.scheduleCheck(this.calculateNextDelay());
        this.scheduleDailySnapshot();
        this.deductBasedOnTime = this.getConfig().getBoolean("deduct-based-on-time", false);
        this.inactiveDaysToDeduct = this.getConfig().getInt("inactive-days-to-deduct", 50);
        this.inactiveDaysToClear = this.getConfig().getInt("inactive-days-to-clear", 500);
        this.onlyOfflinePlayers = this.getConfig().getBoolean("only-offline-players", true);
        List rawTaxBrackets = this.getConfig().getMapList("tax-brackets");
        this.taxAccount = this.getConfig().getBoolean("tax-account", false);
        this.taxAccountName = this.taxAccount ? this.getConfig().getString("tax-account-name", "tax") : null;
        this.taxBrackets.clear();
        boolean usePercentileThresholds = this.getConfig().getBoolean("percentile-thresholds", false);
        if (!usePercentileThresholds) {
            for (Map bracket : rawTaxBrackets) {
                Object thObj = bracket.get("threshold");
                if (thObj == null) {
                    this.getLogger().warning("Ignoring tax bracket with null threshold in lower-bound mode. Please set an explicit lower bound.");
                    continue;
                }
                int threshold = ((Number)thObj).intValue();
                Double rate = ((Number)bracket.get("rate")).doubleValue();
                this.taxBrackets.put(threshold, rate);
            }
        } else {
            List<Double> balances;
            String statsWorld = this.getConfig().getString("stats-world", "");
            String filterStrCfg = this.getConfig().getString("tax-filters", "");
            if (filterStrCfg != null && !filterStrCfg.trim().isEmpty()) {
                Iterator pr = AnalysisFilters.parse(filterStrCfg.trim().split("\\s+"));
                balances = AnalysisFilters.collectFilteredBalances(((AnalysisFilters.ParseResult)((Object)pr)).criteria, statsWorld);
            } else {
                balances = this.collectAllBalances();
            }
            if (balances.isEmpty()) {
                this.getLogger().warning("percentile-thresholds enabled but no balances found; falling back to absolute thresholds.");
                for (Map bracket : rawTaxBrackets) {
                    Object thObj = bracket.get("threshold");
                    if (thObj == null) {
                        this.getLogger().warning("Ignoring tax bracket with null threshold in lower-bound mode. Please set an explicit lower bound.");
                        continue;
                    }
                    int threshold = ((Number)thObj).intValue();
                    Double rate = ((Number)bracket.get("rate")).doubleValue();
                    this.taxBrackets.put(threshold, rate);
                }
            } else {
                Collections.sort(balances);
                for (Map bracket : rawTaxBrackets) {
                    double value;
                    Object thObj = bracket.get("threshold");
                    if (thObj == null) {
                        this.getLogger().warning("Ignoring tax bracket with null threshold in lower-bound percentile mode. Please set an explicit lower bound percentile.");
                        continue;
                    }
                    double p = ((Number)thObj).doubleValue();
                    if (p < 0.0) {
                        p = 0.0;
                    }
                    if (p > 100.0) {
                        p = 100.0;
                    }
                    int thresholdAbs = (value = this.getPercentileValue(balances, p)) >= 2.147483647E9 ? Integer.MAX_VALUE : (value <= -2.147483648E9 ? Integer.MIN_VALUE : (int)Math.floor(value));
                    Double rate = ((Number)bracket.get("rate")).doubleValue();
                    this.taxBrackets.put(thresholdAbs, rate);
                }
                try {
                    StringBuilder sb = new StringBuilder("Computed lower-bound thresholds from percentiles: ");
                    for (Map.Entry<Integer, Double> e : this.taxBrackets.entrySet()) {
                        sb.append("[").append(e.getKey() == Integer.MAX_VALUE ? "MAX" : e.getKey()).append(": ").append(e.getValue()).append("] ");
                    }
                    this.getLogger().info(sb.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void rebuildTaxBracketsForCriteria(AnalysisFilters.FilterCriteria criteria) {
        List<Double> balances;
        List rawTaxBrackets = this.getConfig().getMapList("tax-brackets");
        this.taxBrackets.clear();
        String statsWorld = this.getConfig().getString("stats-world", "");
        List<Double> list = balances = criteria == null ? this.collectAllBalances() : AnalysisFilters.collectFilteredBalances(criteria, statsWorld);
        if (balances == null || balances.isEmpty()) {
            for (Map bracket : rawTaxBrackets) {
                Object thObj = bracket.get("threshold");
                if (thObj == null) continue;
                int threshold = ((Number)thObj).intValue();
                Double rate = ((Number)bracket.get("rate")).doubleValue();
                this.taxBrackets.put(threshold, rate);
            }
            return;
        }
        Collections.sort(balances);
        for (Map bracket : rawTaxBrackets) {
            double value;
            Object thObj = bracket.get("threshold");
            if (thObj == null) continue;
            double p = ((Number)thObj).doubleValue();
            if (p < 0.0) {
                p = 0.0;
            }
            if (p > 100.0) {
                p = 100.0;
            }
            int thresholdAbs = (value = this.getPercentileValue(balances, p)) >= 2.147483647E9 ? Integer.MAX_VALUE : (value <= -2.147483648E9 ? Integer.MIN_VALUE : (int)Math.floor(value));
            Double rate = ((Number)bracket.get("rate")).doubleValue();
            this.taxBrackets.put(thresholdAbs, rate);
        }
    }

    private void loadLangFile() {
        String lang = this.getConfig().getString("language", "en_US");
        this.getLogger().info("Loading language file: " + lang);
        File langFile = new File(this.getDataFolder(), "lang" + File.separator + lang + ".yml");
        if (!langFile.exists()) {
            this.saveResource("lang" + File.separator + lang + ".yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders) {
        return MessageUtils.formatMessage(this.langConfig, path, placeholders, this.messagePrefix);
    }

    public TextComponent getFormattedMessage(String path, Map<String, String> placeholders, String[] clickablePlaceholders, TextComponent[] clickableComponents) {
        return MessageUtils.formatComponent(this.langConfig, path, placeholders, clickablePlaceholders, clickableComponents, this.messagePrefix);
    }

    public FileConfiguration getLangConfig() {
        return this.langConfig;
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public void onDisable() {
        File logFile;
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileLogger.removeHandler(this.fileHandler);
            this.fileHandler.close();
        }
        if ((logFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(logFile);
        }
        this.getLogger().info("EcoBalancer disabled.");
    }

    private void compressExistingLogFile(File logFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        String timestamp = dateFormat.format(new Date(logFile.lastModified()));
        File renamedLogFile = new File(logFile.getParent(), timestamp + ".log");
        if (!logFile.renameTo(renamedLogFile)) {
            this.getLogger().severe("Could not rename the log file.");
            return;
        }
        File compressedFile = new File(renamedLogFile.getParent(), renamedLogFile.getName() + ".gz");
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(renamedLogFile.toPath(), gzos);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not compress the log file: " + e.getMessage());
        }
        if (!renamedLogFile.delete()) {
            this.getLogger().severe("Could not delete the original log file after compression.");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("EcoBalancer disabled [plugin=null]");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("EcoBalancer disabled [rsp=null]");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        this.getLogger().info("" + (econ != null));
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void checkBalance(CommandSender sender, long currentTime, OfflinePlayer player, boolean log, boolean isCheckAll, int operationId) {
        long lastPlayed = player.getLastPlayed();
        long daysOffline = (currentTime - lastPlayed) / 86400000L;
        double balance = econ.hasAccount(player) ? econ.getBalance(player) : 0.0;
        Double deductionRate = 0.0;
        double oldBalance = balance;
        if (this.taxAccount && player.getName().equals(this.taxAccountName)) {
            return;
        }
        Map.Entry<Integer, Double> entry = this.taxBrackets.floorEntry((int)balance);
        if (entry != null) {
            deductionRate = entry.getValue();
        }
        if (deductionRate == null) {
            deductionRate = 0.0;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("days_offline", String.valueOf(daysOffline));
        if (this.onlyOfflinePlayers && player.isOnline()) {
            return;
        }
        if (balance < 0.0) {
            econ.depositPlayer(player, -1.0 * balance);
            placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
            this.sendMessage(sender, "messages.negative_balance", placeholders, log);
        } else if (balance > 0.0) {
            double deduction;
            if (this.deductBasedOnTime) {
                if (daysOffline > (long)this.inactiveDaysToClear) {
                    econ.withdrawPlayer(player, balance);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, balance);
                    }
                    placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
                    this.sendMessage(sender, "messages.offline_extreme", placeholders, log);
                } else if (daysOffline > (long)this.inactiveDaysToDeduct) {
                    deduction = Math.min(balance, balance * deductionRate);
                    placeholders.put("deduction", String.format("%.2f", deduction));
                    econ.withdrawPlayer(player, deduction);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, deduction);
                    }
                    this.sendMessage(sender, "messages.offline_moderate", placeholders, log);
                } else {
                    this.sendMessage(sender, "messages.offline_active", placeholders, false);
                }
            } else {
                deduction = Math.min(balance, balance * deductionRate);
                placeholders.put("deduction", String.format("%.2f", deduction));
                econ.withdrawPlayer(player, deduction);
                if (this.taxAccount) {
                    econ.depositPlayer(this.taxAccountName, deduction);
                }
                this.sendMessage(sender, "messages.deduction_made", placeholders, log);
            }
        } else {
            this.sendMessage(sender, "messages.zero_balance", placeholders, log);
        }
        double newBalance = econ.getBalance(player);
        double deduction = oldBalance - newBalance;
        if (!this.getConfig().getBoolean("record-zero-deduction", true) && Math.abs(deduction) < 1.0E-9) {
            return;
        }
        this.saveRecord(player, oldBalance, newBalance, deduction, isCheckAll, operationId);
    }

    private void sendMessage(CommandSender sender, String path, Map<String, String> placeholders, boolean isLog) {
        String message = this.getFormattedMessage(path, placeholders);
        if (sender != null) {
            for (String str : message.split("\n")) {
                sender.sendMessage(str);
            }
        }
        if (isLog && this.getConfig().getBoolean("file-logging", true) && this.fileHandler != null) {
            for (String str : message.split("\n")) {
                this.fileLogger.info(str);
            }
        }
    }

    private long calculateNextDelay() {
        Calendar now = Calendar.getInstance();
        switch (this.scheduleType) {
            case "daily": {
                return this.calculateDelayForDaily(now);
            }
            case "weekly": {
                return this.calculateDelayForWeekly(now);
            }
            case "monthly": {
                return this.calculateDelayForMonthly(now);
            }
        }
        return this.calculateDelayForDaily(now);
    }

    private long calculateDelayForDaily(Calendar now) {
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        return this.calculateDelayForDaily(now, hourOfDay, minute);
    }

    private long calculateDelayForDaily(Calendar now, int hours, int minutes) {
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.set(11, hours);
        nextCheck.set(12, minutes);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        if (nextCheck.before(now)) {
            nextCheck.add(5, 1);
        }
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForWeekly(Calendar now) {
        long delayForToday;
        int today = now.get(7);
        if (this.scheduleDaysOfWeek.contains(today) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDaysOfWeek.stream().sorted().filter(dayOfWeek -> dayOfWeek > today).map(dayOfWeek -> dayOfWeek - today).findFirst().orElse(7 + this.scheduleDaysOfWeek.get(0) - today);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(7, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForMonthly(Calendar now) {
        long delayForToday;
        int dayOfMonth = now.get(5);
        if (this.scheduleDatesOfMonth.contains(dayOfMonth) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDatesOfMonth.stream().filter(date -> date > dayOfMonth).map(date -> date - dayOfMonth).findFirst().orElse(this.scheduleDatesOfMonth.get(0) + now.getActualMaximum(5) - dayOfMonth);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(5, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private void scheduleCheck(long delay) {
        SchedulerUtils.runTaskLater((Plugin)this, () -> {
            this.checkAll(null);
            this.scheduleCheck(this.calculateNextDelay());
        }, delay);
    }

    public void checkPlayer(CommandSender sender, String playerName) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target.hasPlayedBefore()) {
            long currentTime = System.currentTimeMillis();
            this.computeMetricsSnapshotBatched(sender, 200, 1L, before -> {
                int operationId = this.getNextOperationId(false);
                this.checkBalance(sender, currentTime, target, true, false, operationId);
                this.saveImpactAfterDelay(operationId, (MetricsSnapshot)before, 60L);
            });
        } else {
            sender.sendMessage(this.getFormattedMessage("messages.player_not_found", null));
        }
    }

    public void checkAll(CommandSender sender) {
        this.checkAll(sender, null);
    }

    public void checkAll(final CommandSender sender, AnalysisFilters.FilterCriteria criteria) {
        final long currentTime = System.currentTimeMillis();
        String filterStrFromCfg = null;
        if (criteria == null && (filterStrFromCfg = this.getConfig().getString("tax-filters", "")) != null && !filterStrFromCfg.trim().isEmpty()) {
            criteria = AnalysisFilters.parse((String[])filterStrFromCfg.trim().split((String)"\\s+")).criteria;
        }
        String statsWorld = this.getConfig().getString("stats-world", "");
        final List<OfflinePlayer> players = criteria == null ? Arrays.asList(Bukkit.getOfflinePlayers()) : AnalysisFilters.collectFilteredPlayers(criteria, statsWorld);
        int batchSize = 100;
        int delay = 10;
        if (this.getConfig().getBoolean("percentile-thresholds", false)) {
            try {
                this.rebuildTaxBracketsForCriteria(criteria);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.computeMetricsSnapshotBatched(sender, 200, 1L, players, before -> {
            final int operationId = this.getNextOperationId(true);
            class BatchRunnable
            implements Runnable {
                private int index = 0;
                final /* synthetic */ MetricsSnapshot val$before;

                BatchRunnable() {
                    this.val$before = metricsSnapshot;
                }

                @Override
                public void run() {
                    int start = this.index;
                    int end = Math.min(this.index + 100, players.size());
                    for (int i = this.index; i < end; ++i) {
                        OfflinePlayer player = (OfflinePlayer)players.get(i);
                        EcoBalancer.this.checkBalance(null, currentTime, player, false, true, operationId);
                    }
                    this.index += 100;
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("start", Integer.toString(start));
                    placeholders.put("end", Integer.toString(end));
                    placeholders.put("batch", Integer.toString(end - start));
                    placeholders.put("total_players", Integer.toString(players.size()));
                    EcoBalancer.this.sendMessage(sender, "messages.players_processing", placeholders, true);
                    if (this.index < players.size()) {
                        SchedulerUtils.runTaskLater((Plugin)EcoBalancer.this, this, 10L);
                    } else {
                        EcoBalancer.this.calculateTotalDeduction(operationId);
                        SchedulerUtils.runTask((Plugin)EcoBalancer.this, () -> EcoBalancer.this.sendMessage(sender, "messages.all_players_processed", null, true));
                        EcoBalancer.this.saveImpactAfterDelay(operationId, this.val$before, 100L);
                    }
                }
            }
            SchedulerUtils.runTask((Plugin)this, new BatchRunnable());
        });
    }

    private void calculateTotalDeduction(int operationId) {
        double totalDeduction = DatabaseUtils.calculateTotalDeduction((Plugin)this, operationId, this.getLogger());
        this.getLogger().info("Operation " + operationId + " total deduction: " + totalDeduction);
    }

    private int getNextOperationId(boolean isCheckAll) {
        return DatabaseUtils.getNextOperationId((Plugin)this, isCheckAll, this.getLogger());
    }

    public void generateHistogramFromBalances(CommandSender sender, int numBars, List<Double> balances, String[] originalArgs) {
        sender.sendMessage(this.getFormattedMessage("messages.stats_hist_drawing", null));
        if (balances == null) {
            balances = new ArrayList<Double>();
        }
        double min = balances.stream().min(Double::compareTo).orElse(0.0);
        double max = balances.stream().max(Double::compareTo).orElse(0.0);
        double range = max - min;
        if (range <= 0.0) {
            range = 1.0;
        }
        double barWidth = range / (double)Math.max(1, numBars);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("min", String.format("%.2f", min));
        placeholders.put("max", String.format("%.2f", max));
        sender.sendMessage(this.getFormattedMessage("messages.stats_min_max", placeholders));
        int[] histogram = new int[Math.max(1, numBars)];
        for (double balance : balances) {
            int barIndex = (int)((balance - min) / barWidth);
            if (barIndex < 0) {
                barIndex = 0;
            }
            if (barIndex >= histogram.length) {
                barIndex = histogram.length - 1;
            }
            int n = barIndex;
            histogram[n] = histogram[n] + 1;
        }
        int maxBarLength = 100;
        int maxFrequency = Arrays.stream(histogram).max().orElse(0);
        sender.sendMessage(this.getFormattedMessage("messages.stats_hist_header", null));
        StringBuilder base = new StringBuilder("/ecobal interval");
        if (originalArgs != null) {
            for (String tok : originalArgs) {
                if (tok == null || !tok.contains(":")) continue;
                base.append(' ').append(tok);
            }
        }
        for (int i = 0; i < histogram.length; ++i) {
            double lowerBound = min + (double)i * barWidth;
            double upperBound = lowerBound + barWidth;
            int barLength = maxFrequency > 0 ? (int)((double)histogram[i] / (double)maxFrequency * (double)maxBarLength) : 0;
            String bar = "\u00a7a" + StringUtils.repeat((String)"\u258f", (int)barLength) + "\u00a7r";
            HashMap<String, String> intervalPlaceholders = new HashMap<String, String>();
            intervalPlaceholders.put("bar", bar);
            intervalPlaceholders.put("frequency", Integer.toString(histogram[i]));
            intervalPlaceholders.put("low", EconomicMetrics.formatLargeNumber(lowerBound));
            intervalPlaceholders.put("up", EconomicMetrics.formatLargeNumber(upperBound));
            TextComponent clickableBar = new TextComponent(bar);
            String cmd = base.toString() + " l:" + String.format(Locale.ROOT, "%.6f", lowerBound) + " u:" + String.format(Locale.ROOT, "%.6f", upperBound) + " balance";
            clickableBar.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd));
            clickableBar.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getFormattedMessage("messages.stats_check_interval", intervalPlaceholders)).create()));
            TextComponent message = this.getFormattedMessage("messages.stats_bar", intervalPlaceholders, new String[]{"bar"}, new TextComponent[]{clickableBar});
            sender.spigot().sendMessage((BaseComponent)message);
        }
        double mean = EconomicMetrics.calculateMean(balances);
        double median = EconomicMetrics.calculateMedian(EconomicMetrics.getSortedBalances(balances));
        double standardDeviation = EconomicMetrics.calculateStdDev(balances, mean);
        HashMap<String, String> statsPlaceholders = new HashMap<String, String>();
        statsPlaceholders.put("mean", String.format("%.2f", mean));
        statsPlaceholders.put("median", String.format("%.2f", median));
        statsPlaceholders.put("sd", String.format("%.2f", standardDeviation));
        sender.sendMessage(this.getFormattedMessage("messages.stats_mean_median", statsPlaceholders));
        sender.sendMessage(this.getFormattedMessage("messages.stats_sd", statsPlaceholders));
    }

    public double calculatePercentile(double balance, double low, double high) {
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        ArrayList<Double> balances = new ArrayList<Double>();
        for (OfflinePlayer player : players) {
            double playerBalance;
            if (!econ.hasAccount(player) || !((playerBalance = econ.getBalance(player)) >= low) || !(playerBalance <= high)) continue;
            balances.add(playerBalance);
        }
        int totalPlayers = balances.size();
        int playersBelow = (int)balances.stream().filter(b -> b < balance).count();
        return (double)playersBelow / (double)totalPlayers * 100.0;
    }

    private void saveRecord(OfflinePlayer player, double oldBalance, double newBalance, double deduction, boolean isCheckAll, int operationId) {
        SchedulerUtils.runTaskAsync((Plugin)this, () -> DatabaseUtils.saveRecord((Plugin)this, player, oldBalance, newBalance, deduction, isCheckAll, operationId, this.getLogger()));
    }

    private void cleanupRecords() {
        DatabaseUtils.cleanupRecords((Plugin)this, this.recordRetentionDays, this.getLogger());
    }

    private void scheduleDailySnapshot() {
        try {
            int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
            int minute = Integer.parseInt(this.checkTime.split(":")[1]);
            long initialDelay = this.calculateDelayForDaily(Calendar.getInstance(), hourOfDay, minute);
            long dayPeriod = 1728000L;
            SchedulerUtils.runTaskTimer((Plugin)this, this::createEconomicSnapshot, initialDelay, dayPeriod);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createEconomicSnapshot() {
        try {
            List<Double> balances = this.collectAllBalances();
            if (balances == null) {
                balances = new ArrayList<Double>();
            }
            double totalMoney = balances.stream().mapToDouble(Double::doubleValue).sum();
            int playerCount = balances.size();
            ArrayList<Double> sorted = new ArrayList<Double>(balances);
            Collections.sort(sorted);
            double mean = playerCount > 0 ? totalMoney / (double)playerCount : 0.0;
            double median = EconomicMetrics.calculateMedian(sorted);
            double stdDev = EconomicMetrics.calculateStdDev(balances, mean);
            double gini = 0.0;
            try {
                gini = EconomicMetrics.calculateGini(balances);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            double top1Pct = 0.0;
            try {
                top1Pct = EconomicMetrics.calculateConcentration(balances, 1.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            double top5Pct = 0.0;
            try {
                top5Pct = EconomicMetrics.calculateConcentration(balances, 5.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            double top10Pct = 0.0;
            try {
                top10Pct = EconomicMetrics.calculateConcentration(balances, 10.0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int active7 = 0;
            int active30 = 0;
            try {
                List<Double> b7 = EconomicMetrics.collectBalances(7);
                List<Double> b30 = EconomicMetrics.collectBalances(30);
                active7 = b7 == null ? 0 : b7.size();
                active30 = b30 == null ? 0 : b30.size();
            }
            catch (Throwable b7) {
                // empty catch block
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            String date = fmt.format(new Date());
            DatabaseUtils.EconomicSnapshot snap = new DatabaseUtils.EconomicSnapshot();
            snap.date = date;
            snap.timestamp = System.currentTimeMillis();
            snap.totalMoney = totalMoney;
            snap.playerCount = playerCount;
            snap.activePlayers7d = active7;
            snap.activePlayers30d = active30;
            snap.gini = gini;
            snap.median = median;
            snap.mean = mean;
            snap.stdDev = stdDev;
            snap.top1Pct = top1Pct;
            snap.top5Pct = top5Pct;
            snap.top10Pct = top10Pct;
            DatabaseUtils.saveSnapshot((Plugin)this, snap, this.getLogger());
        }
        catch (Throwable t) {
            this.getLogger().warning("Failed to create economic snapshot: " + t.getMessage());
        }
    }

    private void computeMetricsSnapshotBatched(CommandSender sender, int batchSize, long delayTicks, Consumer<MetricsSnapshot> done) {
        this.computeMetricsSnapshotBatched(sender, batchSize, delayTicks, Arrays.asList(Bukkit.getOfflinePlayers()), done);
    }

    private void computeMetricsSnapshotBatched(CommandSender sender, final int batchSize, final long delayTicks, List<OfflinePlayer> targets, final Consumer<MetricsSnapshot> done) {
        final List<Object> players = targets == null ? Collections.emptyList() : targets;
        final ArrayList balances = new ArrayList(players.size());
        try {
            if (sender != null) {
                sender.sendMessage(this.getFormattedMessage("messages.processing", null));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class PreScan
        implements Runnable {
            int index = 0;

            PreScan() {
            }

            @Override
            public void run() {
                int start = this.index;
                int end = Math.min(this.index + Math.max(1, batchSize), players.size());
                for (int i = start; i < end; ++i) {
                    OfflinePlayer p = (OfflinePlayer)players.get(i);
                    try {
                        double bal;
                        if (econ == null || !econ.hasAccount(p) || !((bal = econ.getBalance(p)) >= 0.0)) continue;
                        balances.add(bal);
                        continue;
                    }
                    catch (Throwable bal) {
                        // empty catch block
                    }
                }
                this.index = end;
                if (this.index < players.size()) {
                    SchedulerUtils.runTaskLater((Plugin)EcoBalancer.this, this, Math.max(1L, delayTicks));
                } else {
                    MetricsSnapshot ms = new MetricsSnapshot();
                    ms.totalMoney = balances.stream().mapToDouble(Double::doubleValue).sum();
                    int n = balances.size();
                    ms.mean = n > 0 ? ms.totalMoney / (double)n : 0.0;
                    ArrayList<Double> sorted = new ArrayList<Double>(balances);
                    Collections.sort(sorted);
                    ms.median = EconomicMetrics.calculateMedian(sorted);
                    ms.stdDev = EconomicMetrics.calculateStdDev(balances, ms.mean);
                    try {
                        ms.gini = EconomicMetrics.calculateGini(balances);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        ms.top1Pct = EconomicMetrics.calculateConcentration(balances, 1.0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    done.accept(ms);
                }
            }
        }
        SchedulerUtils.runTask((Plugin)this, new PreScan());
    }

    private MetricsSnapshot computeMetricsSnapshot() {
        MetricsSnapshot ms = new MetricsSnapshot();
        List<Double> balances = this.collectAllBalances();
        if (balances == null) {
            balances = new ArrayList<Double>();
        }
        ms.totalMoney = balances.stream().mapToDouble(Double::doubleValue).sum();
        int n = balances.size();
        ms.mean = n > 0 ? ms.totalMoney / (double)n : 0.0;
        ArrayList<Double> sorted = new ArrayList<Double>(balances);
        Collections.sort(sorted);
        ms.median = EconomicMetrics.calculateMedian(sorted);
        ms.stdDev = EconomicMetrics.calculateStdDev(balances, ms.mean);
        try {
            ms.gini = EconomicMetrics.calculateGini(balances);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            ms.top1Pct = EconomicMetrics.calculateConcentration(balances, 1.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ms;
    }

    private void saveImpactAfterDelay(int operationId, MetricsSnapshot before, long delayTicks) {
        SchedulerUtils.runTaskLater((Plugin)this, () -> {
            MetricsSnapshot after = this.computeMetricsSnapshot();
            SchedulerUtils.runTaskAsync((Plugin)this, () -> {
                DatabaseUtils.OperationImpact impact = new DatabaseUtils.OperationImpact();
                impact.operationId = operationId;
                impact.beforeGini = before.gini;
                impact.afterGini = after.gini;
                impact.beforeMedian = before.median;
                impact.afterMedian = after.median;
                impact.beforeMean = before.mean;
                impact.afterMean = after.mean;
                impact.beforeStdDev = before.stdDev;
                impact.afterStdDev = after.stdDev;
                impact.beforeTop1Pct = before.top1Pct;
                impact.afterTop1Pct = after.top1Pct;
                impact.beforeTotalMoney = before.totalMoney;
                impact.afterTotalMoney = after.totalMoney;
                impact.totalTaxCollected = DatabaseUtils.calculateTotalDeduction((Plugin)this, operationId, this.getLogger());
                impact.playersAffected = DatabaseUtils.getAffectedPlayersCount((Plugin)this, operationId, this.getLogger());
                impact.timestamp = System.currentTimeMillis();
                DatabaseUtils.saveOperationImpact((Plugin)this, operationId, impact, this.getLogger());
            });
        }, Math.max(0L, delayTicks));
    }

    private List<Double> collectAllBalances() {
        ArrayList<Double> balances = new ArrayList<Double>();
        try {
            OfflinePlayer[] players;
            for (OfflinePlayer player : players = Bukkit.getOfflinePlayers()) {
                try {
                    if (econ == null || !econ.hasAccount(player)) continue;
                    double bal = econ.getBalance(player);
                    balances.add(bal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return balances;
    }

    private double getPercentileValue(List<Double> sortedValues, double percentile) {
        if (sortedValues == null || sortedValues.isEmpty()) {
            return 0.0;
        }
        if (percentile <= 0.0) {
            return sortedValues.get(0);
        }
        if (percentile >= 100.0) {
            return sortedValues.get(sortedValues.size() - 1);
        }
        int n = sortedValues.size();
        int rank = (int)Math.ceil(percentile / 100.0 * (double)n);
        rank = Math.max(1, Math.min(rank, n));
        return sortedValues.get(rank - 1);
    }

    private static class MetricsSnapshot {
        double gini;
        double median;
        double mean;
        double stdDev;
        double top1Pct;
        double totalMoney;

        private MetricsSnapshot() {
        }
    }
}

