/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;

public class CheckRecordCommand
implements TabExecutor {
    private final EcoBalancer plugin;

    public CheckRecordCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block78: {
            int operationId;
            sender.sendMessage(this.plugin.getFormattedMessage("messages.processing", null));
            if (args.length < 1 || args.length > 3) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.record_usage", null));
                return true;
            }
            try {
                operationId = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.record_invalid_id", null));
                return true;
            }
            int page = 1;
            String sortBy = "deduction";
            if (args.length >= 2) {
                if (args[1].equalsIgnoreCase("alphabet") || args[1].equalsIgnoreCase("deduction")) {
                    sortBy = args[1].toLowerCase();
                    if (args.length == 3) {
                        try {
                            page = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
                            return true;
                        }
                    }
                } else {
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
                        return true;
                    }
                }
            }
            try (Connection connection = DatabaseUtils.getConnection((Plugin)this.plugin);
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM operations WHERE id = ?");){
                preparedStatement.setInt(1, operationId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        boolean isCheckAll = resultSet.getBoolean("is_checkall");
                        if (isCheckAll) {
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("operation_id", String.valueOf(operationId));
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.record_all_header", placeholders));
                            int pageSize = 10;
                            int offset = (page - 1) * pageSize;
                            try (PreparedStatement selectStatement = connection.prepareStatement("SELECT * FROM records WHERE operation_id = ? ORDER BY " + (sortBy.equals("alphabet") ? "player_name" : "deduction DESC") + " LIMIT ? OFFSET ?");){
                                selectStatement.setInt(1, operationId);
                                selectStatement.setInt(2, pageSize);
                                selectStatement.setInt(3, offset);
                                try (ResultSet allRecords = selectStatement.executeQuery();){
                                    while (allRecords.next()) {
                                        String playerName = allRecords.getString("player_name");
                                        double oldBalance = allRecords.getDouble("old_balance");
                                        double newBalance = allRecords.getDouble("new_balance");
                                        double deduction = allRecords.getDouble("deduction");
                                        HashMap<String, String> detailPlaceholders = new HashMap<String, String>();
                                        detailPlaceholders.put("player", playerName);
                                        detailPlaceholders.put("old_balance", String.format("%.2f", oldBalance));
                                        detailPlaceholders.put("new_balance", String.format("%.2f", newBalance));
                                        detailPlaceholders.put("deduction", String.format("%.2f", deduction));
                                        String message = this.plugin.getFormattedMessage("messages.record_all_detail", detailPlaceholders);
                                        sender.sendMessage(message);
                                    }
                                }
                            }
                            try (PreparedStatement countStatement = connection.prepareStatement("SELECT COUNT(*) AS total FROM records WHERE operation_id = ?");){
                                countStatement.setInt(1, operationId);
                                try (ResultSet countResult = countStatement.executeQuery();){
                                    if (countResult.next()) {
                                        int total = countResult.getInt("total");
                                        int totalPages = (int)Math.ceil((double)total / (double)pageSize);
                                        HashMap<String, String> pagePlaceholders = new HashMap<String, String>();
                                        pagePlaceholders.put("page", String.valueOf(page));
                                        pagePlaceholders.put("total", String.valueOf(totalPages));
                                        String baseCmdPrefix = "alphabet".equalsIgnoreCase(sortBy) || "deduction".equalsIgnoreCase(sortBy) ? "/ecobal checkrecord " + operationId + " " + sortBy + " " : "/ecobal checkrecord " + operationId + " ";
                                        TextComponent prevPageComp = new TextComponent();
                                        TextComponent nextPageComp = new TextComponent();
                                        if (page > 1) {
                                            prevPageComp.setText(this.plugin.getFormattedMessage("messages.prev_page", null));
                                            prevPageComp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCmdPrefix + (page - 1)));
                                        } else {
                                            prevPageComp.setText(this.plugin.getFormattedMessage("messages.no_prev_page", null));
                                        }
                                        if (page < totalPages) {
                                            nextPageComp.setText(this.plugin.getFormattedMessage("messages.next_page", null));
                                            nextPageComp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCmdPrefix + (page + 1)));
                                        } else {
                                            nextPageComp.setText(this.plugin.getFormattedMessage("messages.no_next_page", null));
                                        }
                                        TextComponent message = this.plugin.getFormattedMessage("messages.record_page", pagePlaceholders, new String[]{"prev", "next"}, new TextComponent[]{prevPageComp, nextPageComp});
                                        sender.spigot().sendMessage((BaseComponent)message);
                                        sender.sendMessage(this.plugin.getFormattedMessage("messages.record_footer", null));
                                    }
                                    break block78;
                                }
                            }
                        }
                        try (PreparedStatement selectStatement = connection.prepareStatement("SELECT * FROM records WHERE operation_id = ? AND deduction != 0.0");){
                            selectStatement.setInt(1, operationId);
                            try (ResultSet allRecords = selectStatement.executeQuery();){
                                if (allRecords.next()) {
                                    String playerName = allRecords.getString("player_name");
                                    double oldBalance = allRecords.getDouble("old_balance");
                                    double newBalance = allRecords.getDouble("new_balance");
                                    double deduction = allRecords.getDouble("deduction");
                                    HashMap<String, String> placeholders = new HashMap<String, String>();
                                    placeholders.put("operation_id", String.valueOf(operationId));
                                    placeholders.put("player", playerName);
                                    placeholders.put("old_balance", String.format("%.2f", oldBalance));
                                    placeholders.put("new_balance", String.format("%.2f", newBalance));
                                    placeholders.put("deduction", String.format("%.2f", deduction));
                                    sender.sendMessage(this.plugin.getFormattedMessage("messages.record_player_header", placeholders));
                                    String message = this.plugin.getFormattedMessage("messages.record_player_detail", placeholders);
                                    sender.sendMessage(message);
                                } else {
                                    sender.sendMessage(this.plugin.getFormattedMessage("messages.record_not_found", null));
                                }
                                break block78;
                            }
                        }
                    }
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.record_invalid_id", null));
                }
            }
            catch (SQLException e) {
                HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                sender.sendMessage(this.plugin.getFormattedMessage("messages.record_error", errorPlaceholders));
            }
        }
        return true;
    }

    public final List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        String arg2;
        ArrayList<String> suggestions = new ArrayList<String>();
        if (strings.length == 0) {
            return suggestions;
        }
        if (strings.length == 2) {
            suggestions.add("deduction");
            suggestions.add("alphabet");
            return (List)StringUtil.copyPartialMatches((String)strings[1], suggestions, new ArrayList());
        }
        if (strings.length == 3 && ("deduction".equals(arg2 = strings[1].toLowerCase(Locale.ROOT)) || "alphabet".equals(arg2))) {
            suggestions.add("1");
            suggestions.add("2");
            suggestions.add("3");
            return (List)StringUtil.copyPartialMatches((String)strings[2], suggestions, new ArrayList());
        }
        return suggestions;
    }
}

