/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.PageUtils;

public class CheckRecordsCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public CheckRecordsCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int pageNumber = 1;
        int pageSize = 10;
        if (args.length > 0) {
            try {
                pageNumber = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.invalid_page", null, this.plugin.getMessagePrefix()));
                return true;
            }
        }
        sender.sendMessage(this.plugin.getFormattedMessage("messages.processing", null));
        try (Connection connection = DatabaseUtils.getConnection((Plugin)this.plugin);){
            HashMap<String, String> placeholders;
            List<OperationRecord> operations222 = this.fetchOperations(connection, 10, pageNumber);
            if (operations222.isEmpty()) {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.no_records", null, this.plugin.getMessagePrefix()));
                boolean bl = true;
                return bl;
            }
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.records_header", null, this.plugin.getMessagePrefix()));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (OperationRecord operation : operations222) {
                placeholders = new HashMap<String, String>();
                placeholders.put("time", dateFormat.format(new Date(operation.timestamp)));
                placeholders.put("type", operation.isCheckAll ? "A" : "P");
                placeholders.put("deduction_amount", String.format("%.2f", operation.totalDeduction));
                placeholders.put("operation_id", String.valueOf(operation.id));
                placeholders.put("restored", operation.isRestored ? "x" : " ");
                TextComponent operationIdComponent = MessageUtils.createClickableComponent(String.valueOf(operation.id), ClickEvent.Action.RUN_COMMAND, "/ecobal checkrecord " + operation.id, MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.records_click", null, this.plugin.getMessagePrefix()));
                TextComponent messageFormat = MessageUtils.formatComponent(this.plugin.getLangConfig(), "messages.records_operation", placeholders, new String[]{"operation_id"}, new TextComponent[]{operationIdComponent}, this.plugin.getMessagePrefix());
                sender.spigot().sendMessage((BaseComponent)messageFormat);
            }
            int totalRecords = this.getTotalOperationsCount(connection);
            int totalPages = PageUtils.calculateTotalPages(totalRecords, 10);
            placeholders = new HashMap();
            placeholders.put("page", String.valueOf(pageNumber));
            placeholders.put("total", String.valueOf(totalPages));
            TextComponent prevPage = new TextComponent();
            TextComponent nextPage = new TextComponent();
            if (pageNumber > 1) {
                prevPage.setText(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.prev_page", null, this.plugin.getMessagePrefix()));
                prevPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ecobal checkrecords " + (pageNumber - 1)));
            } else {
                prevPage.setText(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.no_prev_page", null, this.plugin.getMessagePrefix()));
            }
            if (pageNumber < totalPages) {
                nextPage.setText(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.next_page", null, this.plugin.getMessagePrefix()));
                nextPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ecobal checkrecords " + (pageNumber + 1)));
            } else {
                nextPage.setText(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.no_next_page", null, this.plugin.getMessagePrefix()));
            }
            placeholders.put("prev", prevPage.toPlainText());
            placeholders.put("next", nextPage.toPlainText());
            TextComponent message = MessageUtils.formatComponent(this.plugin.getLangConfig(), "messages.records_page", placeholders, new String[]{"prev", "next"}, new TextComponent[]{prevPage, nextPage}, this.plugin.getMessagePrefix());
            sender.spigot().sendMessage((BaseComponent)message);
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.records_footer", null, this.plugin.getMessagePrefix()));
            return true;
        }
        catch (SQLException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("error", e.getMessage());
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.records_error", placeholders, this.plugin.getMessagePrefix()));
        }
        return true;
    }

    private List<OperationRecord> fetchOperations(Connection connection, int pageSize, int pageNumber) throws SQLException {
        ArrayList<OperationRecord> operations = new ArrayList<OperationRecord>();
        int offset = (pageNumber - 1) * pageSize;
        String sql = "SELECT o.id, o.timestamp, o.is_restored, r.is_checkall, SUM(r.deduction) AS total_deduction FROM operations o JOIN records r ON o.id = r.operation_id GROUP BY o.id ORDER BY o.timestamp DESC LIMIT ? OFFSET ?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setInt(1, pageSize);
            preparedStatement.setInt(2, offset);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    OperationRecord record = new OperationRecord();
                    record.id = resultSet.getInt("id");
                    record.timestamp = resultSet.getLong("timestamp");
                    record.isCheckAll = resultSet.getBoolean("is_checkall");
                    record.totalDeduction = resultSet.getDouble("total_deduction");
                    record.isRestored = resultSet.getBoolean("is_restored");
                    operations.add(record);
                }
            }
        }
        return operations;
    }

    private int getTotalOperationsCount(Connection connection) throws SQLException {
        String sql = "SELECT COUNT(*) AS total FROM (SELECT o.id FROM operations o JOIN records r ON o.id = r.operation_id GROUP BY o.id)";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(sql);){
            if (resultSet.next()) {
                int n = resultSet.getInt("total");
                return n;
            }
        }
        return 0;
    }

    private static class OperationRecord {
        int id;
        long timestamp;
        boolean isCheckAll;
        boolean isRestored;
        double totalDeduction;

        private OperationRecord() {
        }
    }
}

