/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class ConcentrationCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public ConcentrationCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        AnalysisFilters.ParseResult pr = AnalysisFilters.parse(args);
        AnalysisFilters.FilterCriteria criteria = pr.criteria;
        List<String> rest = pr.remainingArgs;
        ArrayList<Double> percentages = new ArrayList<Double>();
        if (rest.isEmpty()) {
            percentages.addAll(Arrays.asList(1.0, 5.0, 10.0, 20.0));
        } else {
            for (String arg : rest) {
                try {
                    double pct = Double.parseDouble(arg);
                    if (pct <= 0.0 || pct > 100.0) {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("value", arg);
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.invalid_percentage", placeholders));
                        return false;
                    }
                    percentages.add(pct);
                }
                catch (NumberFormatException e) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("input", arg);
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.invalid_number", placeholders));
                    return false;
                }
            }
        }
        TreeSet uniquePercentages = new TreeSet(percentages);
        ArrayList finalPercentages = new ArrayList(uniquePercentages);
        sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.calculating", null));
        SchedulerUtils.runTaskAsync((Plugin)this.plugin, () -> {
            try {
                List<Double> balances = AnalysisFilters.collectFilteredBalances(criteria, this.plugin.getConfig().getString("stats-world", ""));
                if (balances.isEmpty()) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.no_data", null)));
                    return;
                }
                double totalMoney = EconomicMetrics.calculateTotalMoney(balances);
                int totalPlayers = balances.size();
                ArrayList<ConcentrationResult> results = new ArrayList<ConcentrationResult>();
                Iterator iterator = finalPercentages.iterator();
                while (iterator.hasNext()) {
                    double pct = (Double)iterator.next();
                    double concentration = EconomicMetrics.calculateConcentration(balances, pct);
                    int topCount = Math.max(1, (int)Math.ceil((double)totalPlayers * pct / 100.0));
                    results.add(new ConcentrationResult(pct, concentration, topCount));
                }
                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                    double top1;
                    HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
                    headerPlaceholders.put("total_players", String.valueOf(totalPlayers));
                    headerPlaceholders.put("total_money", EconomicMetrics.formatLargeNumber(totalMoney));
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.header", headerPlaceholders));
                    for (ConcentrationResult result : results) {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("percentage", String.format("%.1f%%", result.percentage));
                        placeholders.put("concentration", String.format("%.2f%%", result.concentration * 100.0));
                        placeholders.put("player_count", String.valueOf(result.playerCount));
                        placeholders.put("level", EconomicMetrics.getConcentrationLevel(result.concentration));
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.result_line", placeholders));
                    }
                    double d = top1 = results.isEmpty() ? 0.0 : ((ConcentrationResult)results.get((int)0)).concentration;
                    if (top1 >= 0.6) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.warning_extreme", null));
                    } else if (top1 >= 0.4) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.warning_high", null));
                    }
                });
            }
            catch (Exception e) {
                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.concentration.error", null));
                    this.plugin.getLogger().severe("Error calculating concentration: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        });
        return true;
    }

    private static class ConcentrationResult {
        final double percentage;
        final double concentration;
        final int playerCount;

        ConcentrationResult(double percentage, double concentration, int playerCount) {
            this.percentage = percentage;
            this.concentration = concentration;
            this.playerCount = playerCount;
        }
    }
}

