/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.MessageUtils;

public class DescripStatsCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public DescripStatsCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        int numBars;
        AnalysisFilters.ParseResult pr = AnalysisFilters.parse(args);
        List<String> rest = pr.remainingArgs;
        if (rest.isEmpty()) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.stats_usage", null, this.plugin.getMessagePrefix()));
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.stats_limits", null, this.plugin.getMessagePrefix()));
            return false;
        }
        try {
            numBars = Integer.parseInt(rest.get(0));
            if (numBars < 1) {
                sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.stats_invalid_number_of_bars", null, this.plugin.getMessagePrefix()));
                return false;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.stats_usage", null, this.plugin.getMessagePrefix()));
            return false;
        }
        String statsWorld = this.plugin.getConfig().getString("stats-world", "");
        List<Double> balances = AnalysisFilters.collectFilteredBalances(pr.criteria, statsWorld);
        if (balances == null || balances.isEmpty()) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.gini.no_data", null, this.plugin.getMessagePrefix()));
            return true;
        }
        this.plugin.generateHistogramFromBalances(sender, numBars, balances, args);
        return true;
    }
}

