/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.commands.UtilCommand;

public class EcoTabCompleter
implements TabCompleter {
    private final UtilCommand util;

    public EcoTabCompleter(EcoBalancer plugin, UtilCommand util) {
        this.util = util;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String[] subCommands = new String[]{"help", "reload", "checkall", "checkplayer", "stats", "perc", "checkrecords", "checkrecord", "restore", "interval", "gini", "concentration", "report", "health", "impact", "trends"};
            StringUtil.copyPartialMatches((String)args[0], Arrays.asList(subCommands), completions);
            return completions;
        }
        if (args.length > 1) {
            String subCommand = args[0].toLowerCase();
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            switch (subCommand) {
                case "interval": {
                    if (this.util.getIntervalCommand() == null) break;
                    return this.util.getIntervalCommand().onTabComplete(sender, command, alias, subArgs);
                }
                case "checkplayer": {
                    if (subArgs.length != 1) break;
                    ArrayList playerNames = new ArrayList();
                    Bukkit.getOnlinePlayers().forEach(player -> playerNames.add(player.getName()));
                    StringUtil.copyPartialMatches((String)subArgs[0], playerNames, completions);
                    return completions;
                }
                case "stats": {
                    if (subArgs.length != 1) break;
                    List<String> barOptions = Arrays.asList("5", "10", "15", "20", "25", "30");
                    StringUtil.copyPartialMatches((String)subArgs[0], barOptions, completions);
                    return completions;
                }
                case "checkrecord": {
                    if (subArgs.length == 1) {
                        return completions;
                    }
                    if (subArgs.length == 2) {
                        List<String> sortOptions = Arrays.asList("deduction", "alphabet");
                        StringUtil.copyPartialMatches((String)subArgs[1], sortOptions, completions);
                        return completions;
                    }
                    if (subArgs.length != 3) break;
                    List<String> pages = Arrays.asList("1", "2", "3", "4", "5");
                    StringUtil.copyPartialMatches((String)subArgs[2], pages, completions);
                    return completions;
                }
                case "gini": {
                    if (subArgs.length != 1) break;
                    List<String> dayOptions = Arrays.asList("7", "30", "60", "90");
                    StringUtil.copyPartialMatches((String)subArgs[0], dayOptions, completions);
                    return completions;
                }
                case "concentration": {
                    if (subArgs.length < 1) break;
                    List<String> pctOptions = Arrays.asList("1", "5", "10", "20", "25", "50");
                    StringUtil.copyPartialMatches((String)subArgs[subArgs.length - 1], pctOptions, completions);
                    return completions;
                }
                case "report": {
                    break;
                }
            }
        }
        return completions;
    }
}

