/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class GiniCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public GiniCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        AnalysisFilters.ParseResult pr = AnalysisFilters.parse(args);
        AnalysisFilters.FilterCriteria criteria = pr.criteria;
        sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.calculating", null));
        AnalysisFilters.FilterCriteria finalCriteria = criteria;
        SchedulerUtils.runTaskAsync((Plugin)this.plugin, () -> {
            try {
                List<Double> balances = AnalysisFilters.collectFilteredBalances(finalCriteria, this.plugin.getConfig().getString("stats-world", ""));
                if (balances.isEmpty()) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.no_data", null)));
                    return;
                }
                double gini = EconomicMetrics.calculateGini(balances);
                double totalMoney = EconomicMetrics.calculateTotalMoney(balances);
                String giniLevel = EconomicMetrics.getGiniLevel(gini);
                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("gini", String.format("%.4f", gini));
                    placeholders.put("gini_percentage", String.format("%.2f%%", gini * 100.0));
                    placeholders.put("level", giniLevel);
                    placeholders.put("player_count", String.valueOf(balances.size()));
                    placeholders.put("total_money", EconomicMetrics.formatLargeNumber(totalMoney));
                    placeholders.put("days", finalCriteria.activeWithinDays == null ? "\u221e" : String.valueOf(finalCriteria.activeWithinDays));
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.header", null));
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.result", placeholders));
                    if (gini >= 0.6) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.warning_high", null));
                    } else if (gini >= 0.5) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.warning_moderate", null));
                    } else if (gini < 0.3) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.info_low", null));
                    }
                });
            }
            catch (Exception e) {
                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.gini.error", null));
                    this.plugin.getLogger().severe("Error calculating Gini coefficient: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        });
        return true;
    }
}

