/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class HealthCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public HealthCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.health.calculating", null), this.plugin.getLogger(), false);
        SchedulerUtils.asyncRun((Plugin)this.plugin, () -> {
            try {
                AnalysisFilters.FilterCriteria criteria = AnalysisFilters.parse((String[])args).criteria;
                List<Double> balances = AnalysisFilters.collectFilteredBalances(criteria, this.plugin.getConfig().getString("stats-world", ""));
                if (balances.isEmpty()) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.health.no_data", null), this.plugin.getLogger(), false));
                    return;
                }
                double gini = EconomicMetrics.calculateGini(balances);
                double top1Pct = EconomicMetrics.calculateConcentration(balances, 1.0) * 100.0;
                double top10Pct = EconomicMetrics.calculateConcentration(balances, 10.0) * 100.0;
                List<Double> sortedBalances = EconomicMetrics.getSortedBalances(balances);
                double median = EconomicMetrics.calculateMedian(sortedBalances);
                double mean = EconomicMetrics.calculateMean(balances);
                double stdDev = EconomicMetrics.calculateStdDev(sortedBalances, mean);
                HealthScore healthScore = this.calculateHealthScore(gini, top1Pct, top10Pct, stdDev, mean);
                DatabaseUtils.EconomicSnapshot latestSnapshot = DatabaseUtils.getLatestSnapshot((Plugin)this.plugin, this.plugin.getLogger());
                String trend = "";
                if (latestSnapshot != null) {
                    trend = this.analyzeTrend(gini, latestSnapshot.gini);
                }
                HealthScore finalScore = healthScore;
                String finalTrend = trend;
                int playerCount = balances.size();
                SchedulerUtils.runTask((Plugin)this.plugin, () -> this.sendHealthReport(sender, finalScore, gini, top1Pct, top10Pct, median, mean, stdDev, playerCount, finalTrend));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u8ba1\u7b97\u7ecf\u6d4e\u5065\u5eb7\u5ea6\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
                SchedulerUtils.runTask((Plugin)this.plugin, () -> MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.health.error", null), this.plugin.getLogger(), false));
            }
        }, 0L);
        return true;
    }

    private HealthScore calculateHealthScore(double gini, double top1Pct, double top10Pct, double stdDev, double mean) {
        double cv;
        HealthScore score = new HealthScore();
        double giniScore = gini <= 0.35 ? 100.0 : (gini <= 0.45 ? 100.0 - (gini - 0.35) * 500.0 : (gini <= 0.6 ? 50.0 - (gini - 0.45) * 200.0 : Math.max(0.0, 20.0 - (gini - 0.6) * 50.0)));
        score.giniScore = giniScore;
        double concentrationScore = top1Pct <= 20.0 && top10Pct <= 50.0 ? 100.0 : (top1Pct <= 30.0 && top10Pct <= 60.0 ? 80.0 : (top1Pct <= 40.0 && top10Pct <= 70.0 ? 60.0 : (top1Pct <= 50.0 && top10Pct <= 80.0 ? 40.0 : 20.0)));
        score.concentrationScore = concentrationScore;
        double d = cv = mean > 0.0 ? stdDev / mean : Double.MAX_VALUE;
        double distributionScore = cv <= 1.0 ? 100.0 : (cv <= 2.0 ? 100.0 - (cv - 1.0) * 50.0 : (cv <= 3.0 ? 50.0 - (cv - 2.0) * 30.0 : Math.max(0.0, 20.0 - (cv - 3.0) * 10.0)));
        score.distributionScore = distributionScore;
        score.totalScore = giniScore * 0.4 + concentrationScore * 0.3 + distributionScore * 0.3;
        score.level = score.totalScore >= 80.0 ? HealthLevel.EXCELLENT : (score.totalScore >= 60.0 ? HealthLevel.GOOD : (score.totalScore >= 40.0 ? HealthLevel.MODERATE : (score.totalScore >= 20.0 ? HealthLevel.POOR : HealthLevel.CRITICAL)));
        return score;
    }

    private String analyzeTrend(double currentGini, double previousGini) {
        double change = currentGini - previousGini;
        if (Math.abs(change) < 0.01) {
            return "\u2192";
        }
        if (change < 0.0) {
            return "\u2193";
        }
        return "\u2191";
    }

    private void msg(CommandSender sender, String message) {
        MessageUtils.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)message), this.plugin.getLogger(), false);
    }

    private void sendHealthReport(CommandSender sender, HealthScore score, double gini, double top1Pct, double top10Pct, double median, double mean, double stdDev, int playerCount, String trend) {
        double cv;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        this.msg(sender, "&6&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        HashMap<String, String> ph = new HashMap<String, String>();
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.title", null));
        ph.clear();
        ph.put("timestamp", timestamp);
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.generated_at", ph));
        this.msg(sender, "&6&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
        String levelColor = this.getLevelColor(score.level);
        String levelName = this.getLevelName(score.level);
        this.msg(sender, "");
        ph.clear();
        ph.put("score", String.format("%.1f", score.totalScore));
        ph.put("level", levelName);
        this.msg(sender, levelColor + this.plugin.getFormattedMessage("messages.health.score_line", ph));
        this.msg(sender, this.generateProgressBar(score.totalScore, 100.0, 30, levelColor));
        if (!trend.isEmpty()) {
            String trendKey = trend.equals("\u2191") ? "messages.health.trend_up" : (trend.equals("\u2193") ? "messages.health.trend_down" : "messages.health.trend_stable");
            this.msg(sender, this.plugin.getFormattedMessage(trendKey, null));
        }
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.details_header", null));
        String giniColor = gini <= 0.4 ? "&a" : (gini <= 0.5 ? "&e" : "&c");
        ph.clear();
        ph.put("gini_colored", giniColor + String.format("%.3f", gini));
        ph.put("gini_score_40", String.format("%.1f", score.giniScore * 0.4));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.gini_line", ph));
        this.msg(sender, "  " + this.generateProgressBar(gini, 1.0, 20, giniColor));
        ph.clear();
        ph.put("gini_desc", this.getGiniDescription(gini));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.gini_desc_line", ph));
        String concColor = top1Pct <= 25.0 ? "&a" : (top1Pct <= 40.0 ? "&e" : "&c");
        ph.clear();
        ph.put("concentration_score_30", String.format("%.1f", score.concentrationScore * 0.3));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.concentration_header", ph));
        ph.clear();
        ph.put("top1_colored", concColor + String.format("%.1f", top1Pct));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.top1_line", ph));
        this.msg(sender, "      " + this.generateProgressBar(top1Pct, 100.0, 18, concColor));
        ph.clear();
        ph.put("top10_colored", concColor + String.format("%.1f", top10Pct));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.top10_line", ph));
        this.msg(sender, "      " + this.generateProgressBar(top10Pct, 100.0, 18, concColor));
        double d = cv = mean > 0.0 ? stdDev / mean : 0.0;
        String cvColor = cv <= 1.5 ? "&a" : (cv <= 2.5 ? "&e" : "&c");
        ph.clear();
        ph.put("distribution_score_30", String.format("%.1f", score.distributionScore * 0.3));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.distribution_header", ph));
        ph.clear();
        ph.put("cv_colored", cvColor + String.format("%.2f", cv));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.cv_line", ph));
        ph.clear();
        ph.put("mean", EconomicMetrics.formatLargeNumber(mean));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.mean_line", ph));
        ph.clear();
        ph.put("median", EconomicMetrics.formatLargeNumber(median));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.median_line", ph));
        ph.clear();
        ph.put("stddev", EconomicMetrics.formatLargeNumber(stdDev));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.stddev_line", ph));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.reco_header", null));
        List<String> recommendations = this.getRecommendationKeys(score, gini, top1Pct, cv);
        for (String key : recommendations) {
            this.msg(sender, this.plugin.getFormattedMessage("messages.health.reco." + key, null));
        }
        this.msg(sender, "");
        ph.clear();
        ph.put("player_count", String.valueOf(playerCount));
        this.msg(sender, this.plugin.getFormattedMessage("messages.health.sample_line", ph));
        this.msg(sender, "&6&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private String generateProgressBar(double value, double max, int length, String color) {
        int filled = (int)Math.round(value / max * (double)length);
        filled = Math.max(0, Math.min(length, filled));
        StringBuilder bar = new StringBuilder("  &7[");
        for (int i = 0; i < length; ++i) {
            if (i < filled) {
                bar.append(color).append("\u2588");
                continue;
            }
            bar.append("&8\u2591");
        }
        bar.append("&7]");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)bar.toString());
    }

    private String getLevelColor(HealthLevel level) {
        switch (level.ordinal()) {
            case 0: {
                return "&a";
            }
            case 1: {
                return "&2";
            }
            case 2: {
                return "&e";
            }
            case 3: {
                return "&6";
            }
            case 4: {
                return "&c";
            }
        }
        return "&7";
    }

    private String getLevelName(HealthLevel level) {
        String key;
        switch (level.ordinal()) {
            case 0: {
                key = "messages.health.level.excellent";
                break;
            }
            case 1: {
                key = "messages.health.level.good";
                break;
            }
            case 2: {
                key = "messages.health.level.moderate";
                break;
            }
            case 3: {
                key = "messages.health.level.poor";
                break;
            }
            case 4: {
                key = "messages.health.level.critical";
                break;
            }
            default: {
                key = "messages.health.level.unknown";
            }
        }
        return ChatColor.stripColor((String)this.plugin.getFormattedMessage(key, null));
    }

    private String getGiniDescription(double gini) {
        String key = gini <= 0.3 ? "messages.health.gini_desc.very_equal" : (gini <= 0.4 ? "messages.health.gini_desc.relatively_equal" : (gini <= 0.5 ? "messages.health.gini_desc.moderate_gap" : (gini <= 0.6 ? "messages.health.gini_desc.large_gap" : "messages.health.gini_desc.very_unequal")));
        return this.plugin.getFormattedMessage(key, null);
    }

    private List<String> getRecommendationKeys(HealthScore score, double gini, double top1Pct, double cv) {
        ArrayList<String> keys = new ArrayList<String>();
        if (score.level == HealthLevel.EXCELLENT) {
            keys.add("state_excellent_keep");
            keys.add("minor_tune_tax");
            return keys;
        }
        if (gini > 0.5) {
            keys.add("gini_very_high_progressive");
            keys.add("tax_rich_more");
        } else if (gini > 0.4) {
            keys.add("raise_high_income_tax_moderate");
        }
        if (top1Pct > 40.0) {
            keys.add("wealth_overly_concentrated");
            keys.add("special_tax_cap");
        } else if (top1Pct > 25.0) {
            keys.add("concentration_high_moderate_regulation");
        }
        if (cv > 2.5) {
            keys.add("cv_very_high_strong_intervention");
            keys.add("welfare_support");
        } else if (cv > 1.5) {
            keys.add("support_middle_class");
        }
        if (keys.isEmpty()) {
            keys.add("healthy_maintain");
        }
        return keys;
    }

    private static class HealthScore {
        double giniScore;
        double concentrationScore;
        double distributionScore;
        double totalScore;
        HealthLevel level;

        private HealthScore() {
        }
    }

    private static enum HealthLevel {
        EXCELLENT,
        GOOD,
        MODERATE,
        POOR,
        CRITICAL;

    }
}

