/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class ImpactCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public ImpactCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        sender.sendMessage(this.plugin.getFormattedMessage("messages.impact.loading", null));
        SchedulerUtils.asyncRun((Plugin)this.plugin, () -> {
            try {
                DatabaseUtils.OperationImpact impact;
                block7: {
                    if (args.length > 0) {
                        try {
                            int operationId = Integer.parseInt(args[0]);
                            impact = DatabaseUtils.getOperationImpact((Plugin)this.plugin, operationId, this.plugin.getLogger());
                            if (impact == null) {
                                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                                    HashMap<String, String> ph = new HashMap<String, String>();
                                    ph.put("operation_id", Integer.toString(operationId));
                                    MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.impact.not_found", ph), this.plugin.getLogger(), false);
                                    MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.impact.hint_latest", null), this.plugin.getLogger(), false);
                                });
                                return;
                            }
                            break block7;
                        }
                        catch (NumberFormatException e) {
                            SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                                HashMap<String, String> ph = new HashMap<String, String>();
                                ph.put("id", args[0]);
                                MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.impact.invalid_id", ph), this.plugin.getLogger(), false);
                            });
                            return;
                        }
                    }
                    List<DatabaseUtils.OperationImpact> recentImpacts = DatabaseUtils.getRecentImpacts((Plugin)this.plugin, 1, this.plugin.getLogger());
                    if (recentImpacts.isEmpty()) {
                        SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                            MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.report.no_operations", null), this.plugin.getLogger(), false);
                            MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.impact.hint_latest", null), this.plugin.getLogger(), false);
                        });
                        return;
                    }
                    impact = recentImpacts.get(0);
                }
                DatabaseUtils.OperationImpact finalImpact = impact;
                SchedulerUtils.runTask((Plugin)this.plugin, () -> this.sendImpactReport(sender, finalImpact));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u83b7\u53d6\u7a0e\u6536\u5f71\u54cd\u6570\u636e\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
                SchedulerUtils.runTask((Plugin)this.plugin, () -> MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.impact.error", null), this.plugin.getLogger(), false));
            }
        }, 0L);
        return true;
    }

    private void msg(CommandSender sender, String message) {
        MessageUtils.sendMessage(sender, ChatColor.translateAlternateColorCodes((char)'&', (String)message), this.plugin.getLogger(), false);
    }

    private void sendImpactReport(CommandSender sender, DatabaseUtils.OperationImpact impact) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(impact.timestamp));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.banner", null));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("operation_id", Integer.toString(impact.operationId));
        header.put("timestamp", timestamp);
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.title", null));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.operation_line", header));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.banner", null));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_overview", null));
        HashMap<String, String> overview = new HashMap<String, String>();
        overview.put("total_tax", EconomicMetrics.formatLargeNumber(impact.totalTaxCollected));
        overview.put("players", Integer.toString(impact.playersAffected));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.collected", overview));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.affected", overview));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_inequality", null));
        double giniChange = impact.afterGini - impact.beforeGini;
        double giniChangePercent = impact.beforeGini > 0.0 ? giniChange / impact.beforeGini * 100.0 : 0.0;
        String giniTrend = this.getChangeIndicator(giniChange, true);
        String giniColor = giniChange < 0.0 ? "&a" : (giniChange > 0.0 ? "&c" : "&e");
        HashMap<String, String> gini = new HashMap<String, String>();
        gini.put("before", String.format("%.3f", impact.beforeGini));
        gini.put("after", String.format("%.3f", impact.afterGini));
        gini.put("delta_color", giniColor);
        gini.put("delta", String.format("%.3f", giniChange));
        gini.put("delta_pct", String.format("%.1f", giniChangePercent));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.gini_line", gini));
        this.msg(sender, "  " + this.generateComparisonBar(impact.beforeGini, impact.afterGini, 1.0, 20));
        this.msg(sender, String.format("    &8\u2514\u2500 %s %s", giniTrend, this.getGiniChangeDescription(giniChange)));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_concentration", null));
        double top1Change = impact.afterTop1Pct - impact.beforeTop1Pct;
        double top1ChangePercent = impact.beforeTop1Pct > 0.0 ? top1Change / impact.beforeTop1Pct * 100.0 : 0.0;
        String top1Trend = this.getChangeIndicator(top1Change, true);
        String top1Color = top1Change < 0.0 ? "&a" : (top1Change > 0.0 ? "&c" : "&e");
        HashMap<String, String> top1 = new HashMap<String, String>();
        top1.put("before", String.format("%.1f", impact.beforeTop1Pct * 100.0));
        top1.put("after", String.format("%.1f", impact.afterTop1Pct * 100.0));
        top1.put("delta_color", top1Color);
        top1.put("delta", String.format("%.1f", top1Change * 100.0));
        top1.put("delta_pct", String.format("%.1f", top1ChangePercent));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.top1_line", top1));
        this.msg(sender, "  " + this.generateComparisonBar(impact.beforeTop1Pct, impact.afterTop1Pct, 1.0, 20));
        this.msg(sender, String.format("    &8\u2514\u2500 %s %s", top1Trend, this.getConcentrationChangeDescription(top1Change)));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_distribution", null));
        double medianChange = impact.afterMedian - impact.beforeMedian;
        double medianChangePercent = impact.beforeMedian > 0.0 ? medianChange / impact.beforeMedian * 100.0 : 0.0;
        String medianTrend = this.getChangeIndicator(medianChange, false);
        String medianColor = medianChange > 0.0 ? "&a" : (medianChange < 0.0 ? "&c" : "&e");
        HashMap<String, String> med = new HashMap<String, String>();
        med.put("before", EconomicMetrics.formatLargeNumber(impact.beforeMedian));
        med.put("after", EconomicMetrics.formatLargeNumber(impact.afterMedian));
        med.put("delta_color", medianColor);
        med.put("delta", EconomicMetrics.formatLargeNumber(medianChange));
        med.put("delta_pct", String.format("%.1f", medianChangePercent));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.median_line", med));
        this.msg(sender, String.format("    &8\u2514\u2500 %s", medianTrend));
        double meanChange = impact.afterMean - impact.beforeMean;
        double meanChangePercent = impact.beforeMean > 0.0 ? meanChange / impact.beforeMean * 100.0 : 0.0;
        String meanTrend = this.getChangeIndicator(meanChange, false);
        String meanColor = meanChange > 0.0 ? "&a" : (meanChange < 0.0 ? "&c" : "&e");
        HashMap<String, String> mean = new HashMap<String, String>();
        mean.put("before", EconomicMetrics.formatLargeNumber(impact.beforeMean));
        mean.put("after", EconomicMetrics.formatLargeNumber(impact.afterMean));
        mean.put("delta_color", meanColor);
        mean.put("delta", EconomicMetrics.formatLargeNumber(meanChange));
        mean.put("delta_pct", String.format("%.1f", meanChangePercent));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.mean_line", mean));
        this.msg(sender, String.format("    &8\u2514\u2500 %s", meanTrend));
        double stdDevChange = impact.afterStdDev - impact.beforeStdDev;
        double stdDevChangePercent = impact.beforeStdDev > 0.0 ? stdDevChange / impact.beforeStdDev * 100.0 : 0.0;
        String stdDevTrend = this.getChangeIndicator(stdDevChange, true);
        String stdDevColor = stdDevChange < 0.0 ? "&a" : (stdDevChange > 0.0 ? "&c" : "&e");
        HashMap<String, String> sd = new HashMap<String, String>();
        sd.put("before", EconomicMetrics.formatLargeNumber(impact.beforeStdDev));
        sd.put("after", EconomicMetrics.formatLargeNumber(impact.afterStdDev));
        sd.put("delta_color", stdDevColor);
        sd.put("delta", EconomicMetrics.formatLargeNumber(stdDevChange));
        sd.put("delta_pct", String.format("%.1f", stdDevChangePercent));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.stddev_line", sd));
        this.msg(sender, String.format("    &8\u2514\u2500 %s", stdDevTrend));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_scale", null));
        double totalMoneyChange = impact.afterTotalMoney - impact.beforeTotalMoney;
        double totalMoneyChangePercent = impact.beforeTotalMoney > 0.0 ? totalMoneyChange / impact.beforeTotalMoney * 100.0 : 0.0;
        HashMap<String, String> scale = new HashMap<String, String>();
        scale.put("before", EconomicMetrics.formatLargeNumber(impact.beforeTotalMoney));
        scale.put("after", EconomicMetrics.formatLargeNumber(impact.afterTotalMoney));
        scale.put("change", EconomicMetrics.formatLargeNumber(totalMoneyChange));
        scale.put("percent", String.format("%.2f", totalMoneyChangePercent));
        scale.put("removed_percent", String.format("%.2f", Math.abs(totalMoneyChangePercent)));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.total_line", scale));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.change_line", scale));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.removed_line", scale));
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.section_assessment", null));
        String overallAssessment = this.getOverallAssessment(giniChange, top1Change, medianChange);
        this.msg(sender, "  " + overallAssessment);
        this.msg(sender, "");
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.banner", null));
    }

    private String generateComparisonBar(double before, double after, double max, int length) {
        int beforePos = (int)Math.round(before / max * (double)length);
        int afterPos = (int)Math.round(after / max * (double)length);
        beforePos = Math.max(0, Math.min(length, beforePos));
        afterPos = Math.max(0, Math.min(length, afterPos));
        StringBuilder bar = new StringBuilder("  &7[");
        for (int i = 0; i < length; ++i) {
            if (i == beforePos && i == afterPos) {
                bar.append("&e\u25c6");
                continue;
            }
            if (i == beforePos) {
                bar.append("&c\u25cf");
                continue;
            }
            if (i == afterPos) {
                bar.append("&a\u25cf");
                continue;
            }
            if (beforePos < afterPos && i > beforePos && i < afterPos || beforePos > afterPos && i > afterPos && i < beforePos) {
                bar.append("&7\u2500");
                continue;
            }
            bar.append("&8\u2591");
        }
        bar.append("&7] &c\u25cf &7\u2192 &a\u25cf");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)bar.toString());
    }

    private String getChangeIndicator(double change, boolean lowerIsBetter) {
        if (Math.abs(change) < 0.001) {
            return this.plugin.getFormattedMessage("messages.impact.trend.stable", null);
        }
        boolean isImprovement = lowerIsBetter ? change < 0.0 : change > 0.0;
        String arrow = change < 0.0 ? "\u2193" : "\u2191";
        String color = isImprovement ? "&a" : "&c";
        String key = isImprovement ? "messages.impact.trend.improve" : "messages.impact.trend.worsen";
        return String.format("%s%s %s", color, arrow, this.plugin.getFormattedMessage(key, null));
    }

    private String getGiniChangeDescription(double change) {
        double absChange = Math.abs(change);
        if (absChange >= 0.1) {
            return this.plugin.getFormattedMessage("messages.impact.gini_delta.major", null);
        }
        if (absChange >= 0.05) {
            return this.plugin.getFormattedMessage("messages.impact.gini_delta.noticeable", null);
        }
        if (absChange >= 0.01) {
            return this.plugin.getFormattedMessage("messages.impact.gini_delta.slight", null);
        }
        return this.plugin.getFormattedMessage("messages.impact.gini_delta.tiny", null);
    }

    private String getConcentrationChangeDescription(double change) {
        double absChange = Math.abs(change) * 100.0;
        if (absChange >= 5.0) {
            return this.plugin.getFormattedMessage("messages.impact.concentration_delta.major", null);
        }
        if (absChange >= 2.0) {
            return this.plugin.getFormattedMessage("messages.impact.concentration_delta.noticeable", null);
        }
        if (absChange >= 0.5) {
            return this.plugin.getFormattedMessage("messages.impact.concentration_delta.slight", null);
        }
        return this.plugin.getFormattedMessage("messages.impact.concentration_delta.tiny", null);
    }

    private String getOverallAssessment(double giniChange, double top1Change, double medianChange) {
        int improveCount = 0;
        int worsenCount = 0;
        if (giniChange < -0.01) {
            ++improveCount;
        } else if (giniChange > 0.01) {
            ++worsenCount;
        }
        if (top1Change < -0.005) {
            ++improveCount;
        } else if (top1Change > 0.005) {
            ++worsenCount;
        }
        if (medianChange > 0.0) {
            ++improveCount;
        } else if (medianChange < 0.0) {
            ++worsenCount;
        }
        if (improveCount >= 2 && worsenCount == 0) {
            return this.plugin.getFormattedMessage("messages.impact.assessment.strong_improve", null);
        }
        if (improveCount > worsenCount) {
            return this.plugin.getFormattedMessage("messages.impact.assessment.improve", null);
        }
        if (improveCount == worsenCount) {
            return this.plugin.getFormattedMessage("messages.impact.assessment.neutral", null);
        }
        if (worsenCount > improveCount) {
            return this.plugin.getFormattedMessage("messages.impact.assessment.worsen", null);
        }
        return this.plugin.getFormattedMessage("messages.impact.assessment.very_bad", null);
    }
}

