/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.PageUtils;
import org.cubexmc.ecobalancer.utils.VaultUtils;

public class IntervalCommand
implements TabExecutor {
    private final EcoBalancer plugin;

    public IntervalCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        AnalysisFilters.ParseResult pr = AnalysisFilters.parse(args);
        String sortBy = "alphabet";
        int page = 1;
        if (!pr.remainingArgs.isEmpty()) {
            String a0 = pr.remainingArgs.get(0);
            if ("alphabet".equalsIgnoreCase(a0) || "balance".equalsIgnoreCase(a0)) {
                sortBy = a0.toLowerCase();
                if (pr.remainingArgs.size() > 1) {
                    try {
                        page = Integer.parseInt(pr.remainingArgs.get(1));
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.invalid_page", null, this.plugin.getMessagePrefix()));
                        return true;
                    }
                }
            } else {
                try {
                    page = Integer.parseInt(a0);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        List<OfflinePlayer> matchedPlayers = AnalysisFilters.collectFilteredPlayers(pr.criteria, this.plugin.getConfig().getString("stats-world", ""));
        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.interval_sorting", null, this.plugin.getMessagePrefix()));
        if (sortBy.equals("balance")) {
            matchedPlayers.sort((p1, p2) -> Double.compare(VaultUtils.getBalance(p2), VaultUtils.getBalance(p1)));
        } else {
            matchedPlayers.sort(Comparator.comparing(OfflinePlayer::getName));
        }
        int pageSize = 10;
        int totalPages = PageUtils.calculateTotalPages(matchedPlayers.size(), 10);
        if (!PageUtils.isValidPage(page, totalPages)) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.invalid_page", null, this.plugin.getMessagePrefix()));
            return true;
        }
        HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
        double low = pr.criteria.minBalance == null ? Double.NEGATIVE_INFINITY : pr.criteria.minBalance;
        double up = pr.criteria.maxBalance == null ? Double.POSITIVE_INFINITY : pr.criteria.maxBalance;
        headerPlaceholders.put("low", low == Double.NEGATIVE_INFINITY ? "\u221e" : String.format("%.2f", low));
        headerPlaceholders.put("up", up == Double.POSITIVE_INFINITY ? "\u221e" : String.format("%.2f", up));
        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.interval_header", headerPlaceholders, this.plugin.getMessagePrefix()));
        StringBuilder cmdFmt = new StringBuilder("/interval");
        for (String tok : args) {
            if (!tok.contains(":")) continue;
            cmdFmt.append(' ').append(tok);
        }
        cmdFmt.append(' ').append(sortBy).append(' ').append("%d");
        String commandFormat = cmdFmt.toString();
        PageUtils.renderPagination(sender, matchedPlayers, 10, page, (s, player, i) -> {
            double balance = VaultUtils.getBalance(player);
            long lastPlayed = player.getLastPlayed();
            long currentTime = System.currentTimeMillis();
            long daysOffline = (currentTime - lastPlayed) / 86400000L;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("balance", String.format("%.2f", balance));
            placeholders.put("days_offline", String.valueOf(daysOffline));
            s.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.interval_player", placeholders, this.plugin.getMessagePrefix()));
        }, "messages.interval_header", "messages.interval_footer", "messages.interval_page", commandFormat, this.plugin.getLangConfig(), "messages.invalid_page", this.plugin.getMessagePrefix(), headerPlaceholders);
        return true;
    }

    public final List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        int size = 2;
        ArrayList<String> ret = new ArrayList<String>(2);
        if (1 == strings.length) {
            ret.add("alphabet");
            ret.add("balance");
        }
        String lowerCase = strings[0].toLowerCase(Locale.ROOT);
        return (List)StringUtil.copyPartialMatches((String)lowerCase, ret, new ArrayList(2));
    }
}

