/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.AnalysisFilters;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.StatisticsUtils;

public class PercentileCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public PercentileCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double balance;
        if (args.length < 1) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.perc_usage", null, this.plugin.getMessagePrefix()));
            return false;
        }
        try {
            balance = Double.parseDouble(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.perc_invalid_args", null, this.plugin.getMessagePrefix()));
            return false;
        }
        AnalysisFilters.ParseResult pr = AnalysisFilters.parse(Arrays.copyOfRange(args, 1, args.length));
        String statsWorld = this.plugin.getConfig().getString("stats-world", "");
        List<Double> balances = AnalysisFilters.collectFilteredBalances(pr.criteria, statsWorld);
        double percentile = StatisticsUtils.calculatePercentile(balance, balances);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("percentile", String.format("%.2f", percentile));
        double low = pr.criteria.minBalance == null ? Double.NEGATIVE_INFINITY : pr.criteria.minBalance;
        double up = pr.criteria.maxBalance == null ? Double.POSITIVE_INFINITY : pr.criteria.maxBalance;
        placeholders.put("low", low == Double.NEGATIVE_INFINITY ? "\u221e" : String.format("%.2f", low));
        placeholders.put("up", up == Double.POSITIVE_INFINITY ? "\u221e" : String.format("%.2f", up));
        sender.sendMessage(MessageUtils.formatMessage(this.plugin.getLangConfig(), "messages.perc_success", placeholders, this.plugin.getMessagePrefix()));
        return true;
    }
}

