/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class RestoreCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public RestoreCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int operationId;
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_usage", null));
            return true;
        }
        try {
            operationId = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_invalid_id", null));
            return true;
        }
        SchedulerUtils.runTaskAsync((Plugin)this.plugin, () -> {
            try (Connection connection = DatabaseUtils.getConnection((Plugin)this.plugin);){
                long targetTs = 0L;
                try (PreparedStatement ps = connection.prepareStatement("SELECT timestamp, is_restored FROM operations WHERE id = ?");){
                    ps.setInt(1, operationId);
                    try (ResultSet rs = ps.executeQuery();){
                        if (!rs.next()) {
                            SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_operation_not_found", null)));
                            return;
                        }
                        boolean already = rs.getBoolean("is_restored");
                        if (already) {
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("operation_id", String.valueOf(operationId));
                            SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_already_restored", placeholders)));
                            return;
                        }
                        targetTs = rs.getLong("timestamp");
                    }
                }
                try (PreparedStatement psOps = connection.prepareStatement("SELECT id FROM operations WHERE timestamp >= ? AND is_restored = 0 ORDER BY timestamp DESC, id DESC");){
                    psOps.setLong(1, targetTs);
                    try (ResultSet rsOps = psOps.executeQuery();){
                        int restoredOps = 0;
                        while (rsOps.next()) {
                            int opId = rsOps.getInt("id");
                            ArrayList<AbstractMap.SimpleEntry<UUID, Double>> entries = new ArrayList<AbstractMap.SimpleEntry<UUID, Double>>();
                            try (PreparedStatement psRec = connection.prepareStatement("SELECT player, deduction FROM records WHERE operation_id = ? AND deduction != 0.0");){
                                psRec.setInt(1, opId);
                                try (ResultSet rsRec = psRec.executeQuery();){
                                    while (rsRec.next()) {
                                        String playerUUID = rsRec.getString("player");
                                        double deduction = rsRec.getDouble("deduction");
                                        entries.add(new AbstractMap.SimpleEntry<UUID, Double>(UUID.fromString(playerUUID), deduction));
                                    }
                                }
                            }
                            int batch = 200;
                            for (int i = 0; i < entries.size(); i += 200) {
                                int start = i;
                                int end = Math.min(i + 200, entries.size());
                                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                                    for (int j = start; j < end; ++j) {
                                        UUID uid = (UUID)((AbstractMap.SimpleEntry)entries.get(j)).getKey();
                                        double deduction = (Double)((AbstractMap.SimpleEntry)entries.get(j)).getValue();
                                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uid);
                                        if (deduction > 0.0) {
                                            EcoBalancer.getEconomy().depositPlayer(offlinePlayer, deduction);
                                            continue;
                                        }
                                        if (!(deduction < 0.0)) continue;
                                        EcoBalancer.getEconomy().withdrawPlayer(offlinePlayer, -deduction);
                                    }
                                });
                            }
                            try (PreparedStatement psUpd = connection.prepareStatement("UPDATE operations SET is_restored = 1 WHERE id = ?");){
                                psUpd.setInt(1, opId);
                                psUpd.executeUpdate();
                            }
                            ++restoredOps;
                        }
                        int finalRestoredOps = restoredOps;
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("operation_id", String.valueOf(operationId));
                        placeholders.put("count", String.valueOf(finalRestoredOps));
                        SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.restored_range", placeholders)));
                        return;
                    }
                }
            }
            catch (SQLException e) {
                SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_error", new HashMap<String, String>())));
            }
        });
        return true;
    }
}

