/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class TaxReportCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public TaxReportCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Integer operationId = null;
        if (args.length > 0) {
            try {
                operationId = Integer.parseInt(args[0]);
                if (operationId <= 0) {
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    placeholders.put("id", args[0]);
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.report.invalid_id", placeholders));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("input", args[0]);
                sender.sendMessage(this.plugin.getFormattedMessage("messages.report.invalid_number", placeholders));
                return false;
            }
        }
        sender.sendMessage(this.plugin.getFormattedMessage("messages.report.loading", null));
        Integer finalOperationId = operationId;
        SchedulerUtils.runTaskAsync((Plugin)this.plugin, () -> {
            try (Connection conn = DatabaseUtils.getConnection((Plugin)this.plugin);){
                int targetOperationId;
                int n = targetOperationId = finalOperationId != null ? finalOperationId.intValue() : this.getLatestCheckAllOperationId(conn);
                if (targetOperationId <= 0) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> sender.sendMessage(this.plugin.getFormattedMessage("messages.report.no_operations", null)));
                    return;
                }
                TaxReportData reportData = this.queryReportData(conn, targetOperationId);
                if (reportData == null) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("operation_id", String.valueOf(targetOperationId));
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.report.not_found", placeholders));
                    });
                    return;
                }
                SchedulerUtils.runTask((Plugin)this.plugin, () -> this.displayReport(sender, reportData));
            }
            catch (Exception e) {
                SchedulerUtils.runTask((Plugin)this.plugin, () -> {
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.report.error", null));
                    this.plugin.getLogger().severe("Error generating tax report: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        });
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getLatestCheckAllOperationId(Connection conn) {
        String sql = "SELECT id FROM operations WHERE is_checkall = 1 ORDER BY timestamp DESC LIMIT 1";
        try (PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            if (!rs.next()) return -1;
            int n = rs.getInt("id");
            return n;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get latest checkAll operation: " + e.getMessage());
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TaxReportData queryReportData(Connection conn, int operationId) {
        try {
            String opSql = "SELECT timestamp, is_checkall FROM operations WHERE id = ?";
            long timestamp = 0L;
            boolean isCheckAll = false;
            try (PreparedStatement ps = conn.prepareStatement(opSql);){
                ps.setInt(1, operationId);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) {
                        TaxReportData taxReportData = null;
                        return taxReportData;
                    }
                    timestamp = rs.getLong("timestamp");
                    isCheckAll = rs.getBoolean("is_checkall");
                }
            }
            String statsSql = "SELECT COUNT(*) as player_count, SUM(deduction) as total_tax, AVG(old_balance) as avg_old_balance, AVG(new_balance) as avg_new_balance FROM records WHERE operation_id = ? AND deduction > 0";
            int playerCount = 0;
            double totalTax = 0.0;
            double avgOldBalance = 0.0;
            double avgNewBalance = 0.0;
            try (PreparedStatement ps = conn.prepareStatement(statsSql);){
                ps.setInt(1, operationId);
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        playerCount = rs.getInt("player_count");
                        totalTax = rs.getDouble("total_tax");
                        avgOldBalance = rs.getDouble("avg_old_balance");
                        avgNewBalance = rs.getDouble("avg_new_balance");
                    }
                }
            }
            String bracketSql = "SELECT ROUND(deduction / old_balance * 100, 2) as tax_rate, COUNT(*) as count, SUM(deduction) as bracket_total FROM records WHERE operation_id = ? AND deduction > 0 AND old_balance > 0 GROUP BY tax_rate ORDER BY tax_rate";
            ArrayList<TaxBracketInfo> brackets = new ArrayList<TaxBracketInfo>();
            try (PreparedStatement ps = conn.prepareStatement(bracketSql);){
                ps.setInt(1, operationId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        double rate = rs.getDouble("tax_rate");
                        int count = rs.getInt("count");
                        double total = rs.getDouble("bracket_total");
                        brackets.add(new TaxBracketInfo(rate, count, total));
                    }
                    return new TaxReportData(operationId, timestamp, isCheckAll, playerCount, totalTax, avgOldBalance, avgNewBalance, brackets);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to query report data: " + e.getMessage());
            return null;
        }
    }

    private void displayReport(CommandSender sender, TaxReportData data) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("operation_id", String.valueOf(data.operationId));
        placeholders.put("operation_type", data.isCheckAll ? "CheckAll" : "CheckPlayer");
        placeholders.put("timestamp", this.formatTimestamp(data.timestamp));
        placeholders.put("player_count", String.valueOf(data.playerCount));
        placeholders.put("total_tax", EconomicMetrics.formatLargeNumber(data.totalTax));
        placeholders.put("avg_old_balance", EconomicMetrics.formatLargeNumber(data.avgOldBalance));
        placeholders.put("avg_new_balance", EconomicMetrics.formatLargeNumber(data.avgNewBalance));
        double avgTaxRate = data.avgOldBalance > 0.0 ? data.totalTax / (data.avgOldBalance * (double)data.playerCount) * 100.0 : 0.0;
        placeholders.put("avg_tax_rate", String.format("%.2f%%", avgTaxRate));
        sender.sendMessage(this.plugin.getFormattedMessage("messages.report.header", placeholders));
        sender.sendMessage(this.plugin.getFormattedMessage("messages.report.summary", placeholders));
        if (!data.brackets.isEmpty()) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.report.brackets_header", null));
            for (TaxBracketInfo bracket : data.brackets) {
                HashMap<String, String> bracketPlaceholders = new HashMap<String, String>();
                bracketPlaceholders.put("tax_rate", String.format("%.2f%%", bracket.rate));
                bracketPlaceholders.put("player_count", String.valueOf(bracket.count));
                bracketPlaceholders.put("total_tax", EconomicMetrics.formatLargeNumber(bracket.totalTax));
                bracketPlaceholders.put("percentage", String.format("%.1f%%", bracket.totalTax / data.totalTax * 100.0));
                sender.sendMessage(this.plugin.getFormattedMessage("messages.report.bracket_line", bracketPlaceholders));
            }
        }
    }

    private String formatTimestamp(long timestamp) {
        try {
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            return outputFormat.format(new Date(timestamp));
        }
        catch (Exception e) {
            return Long.toString(timestamp);
        }
    }

    private static class TaxBracketInfo {
        final double rate;
        final int count;
        final double totalTax;

        TaxBracketInfo(double rate, int count, double totalTax) {
            this.rate = rate;
            this.count = count;
            this.totalTax = totalTax;
        }
    }

    private static class TaxReportData {
        final int operationId;
        final long timestamp;
        final boolean isCheckAll;
        final int playerCount;
        final double totalTax;
        final double avgOldBalance;
        final double avgNewBalance;
        final List<TaxBracketInfo> brackets;

        TaxReportData(int operationId, long timestamp, boolean isCheckAll, int playerCount, double totalTax, double avgOldBalance, double avgNewBalance, List<TaxBracketInfo> brackets) {
            this.operationId = operationId;
            this.timestamp = timestamp;
            this.isCheckAll = isCheckAll;
            this.playerCount = playerCount;
            this.totalTax = totalTax;
            this.avgOldBalance = avgOldBalance;
            this.avgNewBalance = avgNewBalance;
            this.brackets = brackets;
        }
    }
}

