/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.utils.DatabaseUtils;
import org.cubexmc.ecobalancer.utils.EconomicMetrics;
import org.cubexmc.ecobalancer.utils.MessageUtils;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class TrendsCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public TrendsCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int days = 30;
        if (args.length > 0) {
            try {
                days = Integer.parseInt(args[0]);
                if (days < 1 || days > 365) {
                    MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.trends.invalid_days", null), this.plugin.getLogger(), false);
                    return true;
                }
            }
            catch (NumberFormatException e) {
                MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.trends.invalid_days", null), this.plugin.getLogger(), false);
                return true;
            }
        }
        int queryDays = days;
        MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.trends.loading", null), this.plugin.getLogger(), false);
        SchedulerUtils.asyncRun((Plugin)this.plugin, () -> {
            try {
                List<DatabaseUtils.EconomicSnapshot> snapshots = DatabaseUtils.getSnapshotHistory((Plugin)this.plugin, queryDays, this.plugin.getLogger());
                if (snapshots.isEmpty()) {
                    SchedulerUtils.runTask((Plugin)this.plugin, () -> MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.trends.no_data", null), this.plugin.getLogger(), false));
                    return;
                }
                SchedulerUtils.runTask((Plugin)this.plugin, () -> this.sendTrendsReport(sender, snapshots, queryDays));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("\u83b7\u53d6\u8d8b\u52bf\u6570\u636e\u5931\u8d25: " + e.getMessage());
                e.printStackTrace();
                SchedulerUtils.runTask((Plugin)this.plugin, () -> MessageUtils.sendMessage(sender, this.plugin.getFormattedMessage("messages.trends.error", null), this.plugin.getLogger(), false));
            }
        }, 0L);
        return true;
    }

    private void msg(CommandSender sender, String message) {
        MessageUtils.sendMessage(sender, message, this.plugin.getLogger(), false);
    }

    private void sendTrendsReport(CommandSender sender, List<DatabaseUtils.EconomicSnapshot> snapshots, int days) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DatabaseUtils.EconomicSnapshot first = snapshots.get(0);
        DatabaseUtils.EconomicSnapshot last = snapshots.get(snapshots.size() - 1);
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.banner", null));
        this.msg(sender, "&e&l         \u7ecf\u6d4e\u8d8b\u52bf\u5206\u6790\u62a5\u544a");
        this.msg(sender, String.format("&7\u65f6\u95f4\u8303\u56f4: %s ~ %s (&f%d &7\u5929)", dateFormat.format(new Date(first.timestamp)), dateFormat.format(new Date(last.timestamp)), days));
        this.msg(sender, String.format("&7\u6570\u636e\u70b9\u6570: &f%d &7\u4e2a\u5feb\u7167", snapshots.size()));
        this.msg(sender, this.plugin.getFormattedMessage("messages.impact.banner", null));
        this.msg(sender, "");
        this.msg(sender, "&e&l\u25b8 \u4e0d\u5e73\u7b49\u7a0b\u5ea6\u8d8b\u52bf (\u57fa\u5c3c\u7cfb\u6570):");
        double giniChange = last.gini - first.gini;
        double giniChangePercent = first.gini > 0.0 ? giniChange / first.gini * 100.0 : 0.0;
        String giniTrend = this.getTrendIndicator(giniChange, true);
        this.msg(sender, String.format("  %.3f \u2192 %.3f (%s%.3f, %s%.1f%%&7)", first.gini, last.gini, giniChange >= 0.0 ? "&c+" : "&a", giniChange, giniChange >= 0.0 ? "&c+" : "&a", giniChangePercent));
        this.msg(sender, "  " + this.generateTrendChart(snapshots, "gini"));
        this.msg(sender, "  " + giniTrend);
        this.msg(sender, "");
        this.msg(sender, "&e&l\u25b8 \u8d22\u5bcc\u96c6\u4e2d\u5ea6\u8d8b\u52bf (Top 1%):");
        double top1Change = (last.top1Pct - first.top1Pct) * 100.0;
        double top1ChangePercent = first.top1Pct > 0.0 ? top1Change / (first.top1Pct * 100.0) * 100.0 : 0.0;
        String top1Trend = this.getTrendIndicator(top1Change, true);
        this.msg(sender, String.format("  %.1f%% \u2192 %.1f%% (%s%.1f%%, %s%.1f%%&7)", first.top1Pct * 100.0, last.top1Pct * 100.0, top1Change >= 0.0 ? "&c+" : "&a", top1Change, top1Change >= 0.0 ? "&c+" : "&a", top1ChangePercent));
        this.msg(sender, "  " + this.generateTrendChart(snapshots, "top1"));
        this.msg(sender, "  " + top1Trend);
        this.msg(sender, "");
        this.msg(sender, "&e&l\u25b8 \u7ecf\u6d4e\u89c4\u6a21\u8d8b\u52bf (\u603b\u8d27\u5e01\u91cf):");
        double moneyChange = last.totalMoney - first.totalMoney;
        double moneyChangePercent = first.totalMoney > 0.0 ? moneyChange / first.totalMoney * 100.0 : 0.0;
        String moneyTrend = this.getTrendIndicator(moneyChange, false);
        this.msg(sender, String.format("  %s \u2192 %s (%s%s, %s%.1f%%&7)", EconomicMetrics.formatLargeNumber(first.totalMoney), EconomicMetrics.formatLargeNumber(last.totalMoney), moneyChange >= 0.0 ? "&a+" : "&c", EconomicMetrics.formatLargeNumber(moneyChange), moneyChange >= 0.0 ? "&a+" : "&c", moneyChangePercent));
        this.msg(sender, "  " + this.generateTrendChart(snapshots, "totalMoney"));
        this.msg(sender, "  " + moneyTrend);
        this.msg(sender, "");
        this.msg(sender, "&e&l\u25b8 \u73a9\u5bb6\u6570\u91cf\u8d8b\u52bf:");
        int playerChange = last.playerCount - first.playerCount;
        double playerChangePercent = first.playerCount > 0 ? (double)playerChange / (double)first.playerCount * 100.0 : 0.0;
        this.msg(sender, String.format("  %d \u2192 %d (%s%d, %s%.1f%%&7)", first.playerCount, last.playerCount, playerChange >= 0 ? "&a+" : "&c", playerChange, playerChange >= 0 ? "&a+" : "&c", playerChangePercent));
        this.msg(sender, "  " + this.generateTrendChart(snapshots, "playerCount"));
        this.msg(sender, "");
        this.msg(sender, "&e&l\u25b8 \u8d8b\u52bf\u7efc\u5408\u8bc4\u4ef7:");
        String assessment = this.getOverallTrendAssessment(giniChange, top1Change, moneyChange);
        this.msg(sender, "  " + assessment);
        this.msg(sender, "");
        this.msg(sender, "&6&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
    }

    private String generateTrendChart(List<DatabaseUtils.EconomicSnapshot> snapshots, String metric) {
        int width = 40;
        int height = 5;
        double[] values = new double[snapshots.size()];
        block12: for (int i = 0; i < snapshots.size(); ++i) {
            DatabaseUtils.EconomicSnapshot snap = snapshots.get(i);
            switch (metric) {
                case "gini": {
                    values[i] = snap.gini;
                    continue block12;
                }
                case "top1": {
                    values[i] = snap.top1Pct;
                    continue block12;
                }
                case "totalMoney": {
                    values[i] = snap.totalMoney;
                    continue block12;
                }
                case "playerCount": {
                    values[i] = snap.playerCount;
                    continue block12;
                }
                default: {
                    values[i] = 0.0;
                }
            }
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (double v : values) {
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        if (max == min) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[" + "\u2501".repeat(40) + "] &e\u2192 \u7a33\u5b9a"));
        }
        int[] heights = new int[40];
        for (int i = 0; i < 40; ++i) {
            int dataIndex = (int)((double)i / 40.0 * (double)values.length);
            double normalized = (values[dataIndex] - min) / (max - min);
            heights[i] = (int)(normalized * 5.0);
        }
        StringBuilder chart = new StringBuilder("&7[");
        for (int i = 0; i < 40; ++i) {
            int h = heights[i];
            if (h == 0) {
                chart.append("&8_");
                continue;
            }
            if (h <= 1) {
                chart.append("&a\u2581");
                continue;
            }
            if (h <= 3) {
                chart.append("&e\u2584");
                continue;
            }
            chart.append("&c\u2587");
        }
        chart.append("&7]");
        String trendArrow = values[values.length - 1] > values[0] * 1.05 ? " &c\u2191" : (values[values.length - 1] < values[0] * 0.95 ? " &a\u2193" : " &e\u2192");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(chart.toString() + trendArrow));
    }

    private String getTrendIndicator(double change, boolean lowerIsBetter) {
        if (Math.abs(change) < 0.001) {
            return "&e\u2192 \u8d8b\u52bf\u5e73\u7a33";
        }
        boolean isImproving = lowerIsBetter ? change < 0.0 : change > 0.0;
        String arrow = change < 0.0 ? "\u2193" : "\u2191";
        String color = isImproving ? "&a" : "&c";
        double absChange = Math.abs(change);
        String magnitude = absChange > 0.1 || absChange > 10.0 ? "\u663e\u8457" : (absChange > 0.05 || absChange > 5.0 ? "\u660e\u663e" : "\u8f7b\u5fae");
        String status = isImproving ? magnitude + "\u6539\u5584" : magnitude + "\u6076\u5316";
        return String.format("%s%s \u8d8b\u52bf%s", color, arrow, status);
    }

    private String getOverallTrendAssessment(double giniChange, double top1Change, double moneyChange) {
        boolean moneyGrow;
        boolean top1Improve;
        boolean giniImprove = giniChange < -0.01;
        int improveCount = (giniImprove ? 1 : 0) + ((top1Improve = top1Change < -0.5) ? 1 : 0) + ((moneyGrow = moneyChange > 0.0) ? 1 : 0);
        if (improveCount >= 2) {
            if (giniImprove && top1Improve && moneyGrow) {
                return "&a&l\u2713 \u7ecf\u6d4e\u72b6\u51b5\u6301\u7eed\u5411\u597d\uff0c\u5e73\u7b49\u6027\u6539\u5584\u4e14\u89c4\u6a21\u589e\u957f";
            }
            return "&a&l\u2713 \u7ecf\u6d4e\u6574\u4f53\u5448\u73b0\u79ef\u6781\u8d8b\u52bf";
        }
        if (improveCount == 1) {
            return "&e&l\u26a0 \u7ecf\u6d4e\u8d8b\u52bf\u559c\u5fe7\u53c2\u534a\uff0c\u9700\u6301\u7eed\u5173\u6ce8";
        }
        if (!giniImprove && !top1Improve) {
            return "&c&l\u2717 \u4e0d\u5e73\u7b49\u7a0b\u5ea6\u52a0\u5267\uff0c\u5efa\u8bae\u8c03\u6574\u7a0e\u6536\u653f\u7b56";
        }
        return "&c&l\u2717 \u7ecf\u6d4e\u72b6\u51b5\u9700\u8981\u6539\u5584\uff0c\u5efa\u8bae\u91c7\u53d6\u63aa\u65bd";
    }
}

