/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.cubexmc.ecobalancer.EcoBalancer;
import org.cubexmc.ecobalancer.commands.CheckAllCommand;
import org.cubexmc.ecobalancer.commands.CheckPlayerCommand;
import org.cubexmc.ecobalancer.commands.CheckRecordCommand;
import org.cubexmc.ecobalancer.commands.CheckRecordsCommand;
import org.cubexmc.ecobalancer.commands.ConcentrationCommand;
import org.cubexmc.ecobalancer.commands.DescripStatsCommand;
import org.cubexmc.ecobalancer.commands.GiniCommand;
import org.cubexmc.ecobalancer.commands.HealthCommand;
import org.cubexmc.ecobalancer.commands.ImpactCommand;
import org.cubexmc.ecobalancer.commands.IntervalCommand;
import org.cubexmc.ecobalancer.commands.PercentileCommand;
import org.cubexmc.ecobalancer.commands.RestoreCommand;
import org.cubexmc.ecobalancer.commands.TaxReportCommand;
import org.cubexmc.ecobalancer.commands.TrendsCommand;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public class UtilCommand
implements CommandExecutor {
    private final EcoBalancer plugin;
    private final CheckAllCommand checkAllCommand;
    private final CheckPlayerCommand checkPlayerCommand;
    private final DescripStatsCommand statsCommand;
    private final PercentileCommand percCommand;
    private final CheckRecordsCommand checkRecordsCommand;
    private final CheckRecordCommand checkRecordCommand;
    private final RestoreCommand restoreCommand;
    private final IntervalCommand intervalCommand;
    private final GiniCommand giniCommand;
    private final ConcentrationCommand concentrationCommand;
    private final TaxReportCommand reportCommand;
    private final HealthCommand healthCommand;
    private final ImpactCommand impactCommand;
    private final TrendsCommand trendsCommand;

    public UtilCommand(EcoBalancer plugin) {
        this.plugin = plugin;
        this.checkAllCommand = new CheckAllCommand(plugin);
        this.checkPlayerCommand = new CheckPlayerCommand(plugin);
        this.statsCommand = new DescripStatsCommand(plugin);
        this.percCommand = new PercentileCommand(plugin);
        this.checkRecordsCommand = new CheckRecordsCommand(plugin);
        this.checkRecordCommand = new CheckRecordCommand(plugin);
        this.restoreCommand = new RestoreCommand(plugin);
        this.intervalCommand = new IntervalCommand(plugin);
        this.giniCommand = new GiniCommand(plugin);
        this.concentrationCommand = new ConcentrationCommand(plugin);
        this.reportCommand = new TaxReportCommand(plugin);
        this.healthCommand = new HealthCommand(plugin);
        this.impactCommand = new ImpactCommand(plugin);
        this.trendsCommand = new TrendsCommand(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        String subCommand = args[0].toLowerCase();
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        switch (subCommand) {
            case "reload": {
                SchedulerUtils.cancelAllTasks((Plugin)this.plugin);
                this.plugin.reloadConfig();
                this.plugin.loadConfiguration();
                sender.sendMessage(this.plugin.getFormattedMessage("messages.reload_success", null));
                return true;
            }
            case "help": {
                this.showHelp(sender);
                return true;
            }
            case "checkall": {
                return this.checkAllCommand.onCommand(sender, command, label, subArgs);
            }
            case "checkplayer": {
                return this.checkPlayerCommand.onCommand(sender, command, label, subArgs);
            }
            case "stats": {
                return this.statsCommand.onCommand(sender, command, label, subArgs);
            }
            case "perc": {
                return this.percCommand.onCommand(sender, command, label, subArgs);
            }
            case "checkrecords": {
                return this.checkRecordsCommand.onCommand(sender, command, label, subArgs);
            }
            case "checkrecord": {
                return this.checkRecordCommand.onCommand(sender, command, label, subArgs);
            }
            case "restore": {
                return this.restoreCommand.onCommand(sender, command, label, subArgs);
            }
            case "interval": {
                return this.intervalCommand.onCommand(sender, command, label, subArgs);
            }
            case "gini": {
                return this.giniCommand.onCommand(sender, command, label, subArgs);
            }
            case "concentration": {
                return this.concentrationCommand.onCommand(sender, command, label, subArgs);
            }
            case "report": {
                return this.reportCommand.onCommand(sender, command, label, subArgs);
            }
            case "health": {
                return this.healthCommand.onCommand(sender, command, label, subArgs);
            }
            case "impact": {
                return this.impactCommand.onCommand(sender, command, label, subArgs);
            }
            case "trends": {
                return this.trendsCommand.onCommand(sender, command, label, subArgs);
            }
        }
        sender.sendMessage(this.plugin.getFormattedMessage("messages.unknown_command", null));
        return false;
    }

    private void showHelp(CommandSender sender) {
        String[] commandMessages;
        sender.sendMessage(this.plugin.getFormattedMessage("messages.help_header", null));
        for (String str : commandMessages = new String[]{this.plugin.getFormattedMessage("messages.commands.help", null), this.plugin.getFormattedMessage("messages.commands.checkall", null), this.plugin.getFormattedMessage("messages.commands.checkplayer", null), this.plugin.getFormattedMessage("messages.commands.gini", null), this.plugin.getFormattedMessage("messages.commands.concentration", null), this.plugin.getFormattedMessage("messages.commands.report", null), this.plugin.getFormattedMessage("messages.commands.checkrecords", null), this.plugin.getFormattedMessage("messages.commands.checkrecord", null), this.plugin.getFormattedMessage("messages.commands.restore", null), this.plugin.getFormattedMessage("messages.commands.stats", null), this.plugin.getFormattedMessage("messages.commands.interval", null), this.plugin.getFormattedMessage("messages.commands.perc", null), this.plugin.getFormattedMessage("messages.commands.health", null), this.plugin.getFormattedMessage("messages.commands.impact", null), this.plugin.getFormattedMessage("messages.commands.trends", null), this.plugin.getFormattedMessage("messages.commands.reload", null), this.plugin.getFormattedMessage("messages.help_footer", null)}) {
            sender.sendMessage(str);
        }
    }

    public IntervalCommand getIntervalCommand() {
        return this.intervalCommand;
    }

    public CheckRecordCommand getCheckRecordCommand() {
        return this.checkRecordCommand;
    }
}

