/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.cubexmc.ecobalancer.utils.PlaytimeUtils;
import org.cubexmc.ecobalancer.utils.VaultUtils;

public final class AnalysisFilters {
    private AnalysisFilters() {
    }

    public static ParseResult parse(String[] args) {
        FilterCriteria c = new FilterCriteria();
        ArrayList<String> rest = new ArrayList<String>();
        if (args != null) {
            block18: for (String arg : args) {
                if (arg == null) continue;
                int idx = arg.indexOf(58);
                if (idx <= 0 || idx == arg.length() - 1) {
                    rest.add(arg);
                    continue;
                }
                String key = arg.substring(0, idx).toLowerCase(Locale.ROOT);
                String val = arg.substring(idx + 1);
                try {
                    switch (key) {
                        case "d": {
                            int n = Integer.parseInt(val);
                            if (n <= 0) continue block18;
                            c.activeWithinDays = n;
                            break;
                        }
                        case "p": {
                            int n = Integer.parseInt(val);
                            if (n < 0) continue block18;
                            c.minPlaytimeHours = n;
                            break;
                        }
                        case "l": {
                            c.minBalance = Double.parseDouble(val);
                            break;
                        }
                        case "u": {
                            c.maxBalance = Double.parseDouble(val);
                            break;
                        }
                        case "lr": {
                            double p = Double.parseDouble(val);
                            if (p < 0.0) {
                                p = 0.0;
                            }
                            if (p > 100.0) {
                                p = 100.0;
                            }
                            c.minPercentile = p;
                            break;
                        }
                        case "ur": {
                            double p = Double.parseDouble(val);
                            if (p < 0.0) {
                                p = 0.0;
                            }
                            if (p > 100.0) {
                                p = 100.0;
                            }
                            c.maxPercentile = p;
                            break;
                        }
                        default: {
                            rest.add(arg);
                            break;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    rest.add(arg);
                }
            }
        }
        return new ParseResult(c, rest);
    }

    public static List<Double> collectFilteredBalances(FilterCriteria criteria, String statsWorldName) {
        double maxBound;
        if (criteria == null) {
            criteria = new FilterCriteria();
        }
        ArrayList<PlayerEntry> candidates = new ArrayList<PlayerEntry>();
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        long now = System.currentTimeMillis();
        long cutoff = criteria.activeWithinDays == null ? Long.MIN_VALUE : now - (long)criteria.activeWithinDays.intValue() * 24L * 60L * 60L * 1000L;
        for (OfflinePlayer p : players) {
            try {
                double bal;
                if (criteria.activeWithinDays != null && p.getLastPlayed() < cutoff || !VaultUtils.hasAccount(p)) continue;
                if (criteria.minPlaytimeHours != null) {
                    PlaytimeUtils.ensureLoadedFor(p.getUniqueId(), statsWorldName);
                    double hours = PlaytimeUtils.getPlaytimeHours(p.getUniqueId());
                    if (hours < (double)criteria.minPlaytimeHours.intValue()) continue;
                }
                if ((bal = VaultUtils.getBalance(p)) < 0.0) continue;
                candidates.add(new PlayerEntry(p, bal));
            }
            catch (Throwable bal) {
                // empty catch block
            }
        }
        double minBound = criteria.minBalance != null ? criteria.minBalance : Double.NEGATIVE_INFINITY;
        double d = maxBound = criteria.maxBalance != null ? criteria.maxBalance : Double.POSITIVE_INFINITY;
        if (criteria.minPercentile != null || criteria.maxPercentile != null) {
            double ub;
            double lb;
            ArrayList<Double> sorted = new ArrayList<Double>();
            for (PlayerEntry e : candidates) {
                sorted.add(e.balance);
            }
            Collections.sort(sorted);
            if (criteria.minPercentile != null && (lb = AnalysisFilters.percentileValue(sorted, criteria.minPercentile)) > minBound) {
                minBound = lb;
            }
            if (criteria.maxPercentile != null && (ub = AnalysisFilters.percentileValue(sorted, criteria.maxPercentile)) < maxBound) {
                maxBound = ub;
            }
        }
        if (minBound > maxBound) {
            return Collections.emptyList();
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (PlayerEntry e : candidates) {
            if (!(e.balance >= minBound) || !(e.balance <= maxBound)) continue;
            result.add(e.balance);
        }
        return result;
    }

    public static List<OfflinePlayer> collectFilteredPlayers(FilterCriteria criteria, String statsWorldName) {
        double maxBound;
        if (criteria == null) {
            criteria = new FilterCriteria();
        }
        ArrayList<OfflinePlayer> candidates = new ArrayList<OfflinePlayer>();
        ArrayList<Double> candidateBalances = new ArrayList<Double>();
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        long now = System.currentTimeMillis();
        long cutoff = criteria.activeWithinDays == null ? Long.MIN_VALUE : now - (long)criteria.activeWithinDays.intValue() * 24L * 60L * 60L * 1000L;
        for (OfflinePlayer p : players) {
            try {
                double bal;
                if (criteria.activeWithinDays != null && p.getLastPlayed() < cutoff || !VaultUtils.hasAccount(p)) continue;
                if (criteria.minPlaytimeHours != null) {
                    PlaytimeUtils.ensureLoadedFor(p.getUniqueId(), statsWorldName);
                    double hours = PlaytimeUtils.getPlaytimeHours(p.getUniqueId());
                    if (hours < (double)criteria.minPlaytimeHours.intValue()) continue;
                }
                if ((bal = VaultUtils.getBalance(p)) < 0.0) continue;
                candidates.add(p);
                candidateBalances.add(bal);
            }
            catch (Throwable bal) {
                // empty catch block
            }
        }
        double minBound = criteria.minBalance != null ? criteria.minBalance : Double.NEGATIVE_INFINITY;
        double d = maxBound = criteria.maxBalance != null ? criteria.maxBalance : Double.POSITIVE_INFINITY;
        if (criteria.minPercentile != null || criteria.maxPercentile != null) {
            double ub;
            double lb;
            ArrayList<Double> sorted = new ArrayList<Double>(candidateBalances);
            Collections.sort(sorted);
            if (criteria.minPercentile != null && (lb = AnalysisFilters.percentileValue(sorted, criteria.minPercentile)) > minBound) {
                minBound = lb;
            }
            if (criteria.maxPercentile != null && (ub = AnalysisFilters.percentileValue(sorted, criteria.maxPercentile)) < maxBound) {
                maxBound = ub;
            }
        }
        if (minBound > maxBound) {
            return Collections.emptyList();
        }
        ArrayList<OfflinePlayer> result = new ArrayList<OfflinePlayer>();
        for (int i = 0; i < candidates.size(); ++i) {
            double bal = (Double)candidateBalances.get(i);
            if (!(bal >= minBound) || !(bal <= maxBound)) continue;
            result.add((OfflinePlayer)candidates.get(i));
        }
        return result;
    }

    private static double percentileValue(List<Double> sorted, double p) {
        if (sorted == null || sorted.isEmpty()) {
            return 0.0;
        }
        if (p <= 0.0) {
            return sorted.get(0);
        }
        if (p >= 100.0) {
            return sorted.get(sorted.size() - 1);
        }
        int n = sorted.size();
        int rank = (int)Math.ceil(p / 100.0 * (double)n);
        rank = Math.max(1, Math.min(rank, n));
        return sorted.get(rank - 1);
    }

    public static final class FilterCriteria {
        public Integer activeWithinDays;
        public Integer minPlaytimeHours;
        public Double minBalance;
        public Double maxBalance;
        public Double minPercentile;
        public Double maxPercentile;
    }

    public static final class ParseResult {
        public final FilterCriteria criteria;
        public final List<String> remainingArgs;

        public ParseResult(FilterCriteria c, List<String> rest) {
            this.criteria = c;
            this.remainingArgs = rest;
        }
    }

    private static final class PlayerEntry {
        final OfflinePlayer player;
        final double balance;

        PlayerEntry(OfflinePlayer p, double b) {
            this.player = p;
            this.balance = b;
        }
    }
}

