/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class DatabaseUtils {
    private static void applyPragmas(Connection connection) {
        try (Statement s = connection.createStatement();){
            s.execute("PRAGMA journal_mode=WAL");
            s.execute("PRAGMA synchronous=NORMAL");
            s.execute("PRAGMA foreign_keys=ON");
            s.execute("PRAGMA temp_store=MEMORY");
            s.execute("PRAGMA cache_size=-8192");
            s.execute("PRAGMA busy_timeout=10000");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static File getDatabaseFile(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        return new File(dataFolder, "records.db");
    }

    public static Connection getConnection(Plugin plugin) throws SQLException {
        File databaseFile = DatabaseUtils.getDatabaseFile(plugin);
        Connection c = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath() + "?busy_timeout=10000");
        DatabaseUtils.applyPragmas(c);
        return c;
    }

    public static void initializeTables(Plugin plugin, Logger logger) {
        try (Connection connection = DatabaseUtils.getConnection(plugin);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS operations (id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, is_restored BOOLEAN NOT NULL DEFAULT 0)");
            statement.execute("CREATE TABLE IF NOT EXISTS records (id INTEGER PRIMARY KEY AUTOINCREMENT, player_name TEXT NOT NULL, player TEXT NOT NULL, old_balance REAL NOT NULL, new_balance REAL NOT NULL, deduction REAL NOT NULL, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, operation_id INTEGER NOT NULL, FOREIGN KEY(operation_id) REFERENCES operations(id) ON DELETE CASCADE)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_records_operation_id ON records(operation_id)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_records_timestamp ON records(timestamp)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_records_player ON records(player)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_operations_timestamp ON operations(timestamp)");
            statement.execute("CREATE TABLE IF NOT EXISTS economic_snapshots (id INTEGER PRIMARY KEY AUTOINCREMENT, snapshot_date TEXT NOT NULL, timestamp INTEGER NOT NULL, total_money REAL NOT NULL, player_count INTEGER NOT NULL, active_players_7d INTEGER, active_players_30d INTEGER, gini_coefficient REAL, median_balance REAL, mean_balance REAL, std_dev REAL, top1_percentage REAL, top5_percentage REAL, top10_percentage REAL)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_snapshots_date ON economic_snapshots(snapshot_date)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_snapshots_timestamp ON economic_snapshots(timestamp)");
            statement.execute("CREATE TABLE IF NOT EXISTS operation_impact (operation_id INTEGER PRIMARY KEY, before_gini REAL, after_gini REAL, before_median REAL, after_median REAL, before_mean REAL, after_mean REAL, before_std_dev REAL, after_std_dev REAL, before_top1_pct REAL, after_top1_pct REAL, before_total_money REAL, after_total_money REAL, total_tax_collected REAL, players_affected INTEGER, timestamp INTEGER NOT NULL)");
        }
        catch (SQLException e) {
            logger.severe("\u521d\u59cb\u5316\u6570\u636e\u5e93\u8868\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void saveRecord(Plugin plugin, OfflinePlayer player, double oldBalance, double newBalance, double deduction, boolean isCheckAll, int operationId, Logger logger) {
        DatabaseUtils.runSqlWithRetry(logger, () -> {
            try (Connection connection = DatabaseUtils.getConnection(plugin);
                 PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO records (player_name, player, old_balance, new_balance, deduction, timestamp, is_checkall, operation_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                preparedStatement.setString(1, player.getName());
                preparedStatement.setString(2, player.getUniqueId().toString());
                preparedStatement.setDouble(3, oldBalance);
                preparedStatement.setDouble(4, newBalance);
                preparedStatement.setDouble(5, deduction);
                preparedStatement.setLong(6, System.currentTimeMillis());
                preparedStatement.setBoolean(7, isCheckAll);
                preparedStatement.setInt(8, operationId);
                preparedStatement.executeUpdate();
            }
        });
    }

    private static void runSqlWithRetry(Logger logger, SqlRunnable op) {
        int attempts = 6;
        long sleepMs = 100L;
        SQLException last = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                op.run();
                return;
            }
            catch (SQLException e) {
                String msg;
                last = e;
                String string = msg = e.getMessage() == null ? "" : e.getMessage().toLowerCase(Locale.ROOT);
                if (!msg.contains("database is locked") && !msg.contains("sqlite_busy")) break;
                try {
                    Thread.sleep(sleepMs);
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                sleepMs = Math.min(1000L, sleepMs * 2L);
                continue;
            }
        }
        if (last != null) {
            logger.severe("\u4fdd\u5b58\u8bb0\u5f55\u5931\u8d25: " + last.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNextOperationId(Plugin plugin, boolean isCheckAll, Logger logger) {
        try (Connection connection = DatabaseUtils.getConnection(plugin);
             PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO operations (timestamp, is_checkall, is_restored) VALUES (?, ?, ?)", 1);){
            preparedStatement.setLong(1, System.currentTimeMillis());
            preparedStatement.setBoolean(2, isCheckAll);
            preparedStatement.setBoolean(3, false);
            preparedStatement.executeUpdate();
            try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                if (!generatedKeys.next()) throw new SQLException("\u521b\u5efa\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230ID");
                int n = generatedKeys.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            logger.severe("\u83b7\u53d6\u4e0b\u4e00\u4e2a\u64cd\u4f5cID\u5931\u8d25: " + e.getMessage());
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double calculateTotalDeduction(Plugin plugin, int operationId, Logger logger) {
        ResultSet resultSet;
        block19: {
            try {
                double d;
                Connection connection;
                block21: {
                    PreparedStatement preparedStatement;
                    block20: {
                        connection = DatabaseUtils.getConnection(plugin);
                        preparedStatement = connection.prepareStatement("SELECT SUM(deduction) AS total_deduction FROM records WHERE operation_id = ?");
                        preparedStatement.setInt(1, operationId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (!resultSet.next()) break block19;
                            d = resultSet.getDouble("total_deduction");
                            if (resultSet == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (resultSet == null) throw throwable;
                            try {
                                resultSet.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement == null) break block21;
                    preparedStatement.close();
                }
                if (connection == null) return d;
                connection.close();
                return d;
            }
            catch (SQLException e) {
                logger.severe("\u8ba1\u7b97\u603b\u6263\u9664\u91d1\u989d\u5931\u8d25: " + e.getMessage());
                return 0.0;
            }
        }
        if (resultSet == null) return 0.0;
        resultSet.close();
        return 0.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAffectedPlayersCount(Plugin plugin, int operationId, Logger logger) {
        try (Connection connection = DatabaseUtils.getConnection(plugin);
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(*) AS cnt FROM records WHERE operation_id = ? AND deduction > 0");){
            preparedStatement.setInt(1, operationId);
            try (ResultSet rs = preparedStatement.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("cnt");
                return n;
            }
        }
        catch (SQLException e) {
            logger.severe("\u7edf\u8ba1\u53d7\u5f71\u54cd\u73a9\u5bb6\u6570\u91cf\u5931\u8d25: " + e.getMessage());
        }
        return 0;
    }

    public static void cleanupRecords(Plugin plugin, int retentionDays, Logger logger) {
        long cutoffTime = System.currentTimeMillis() - (long)retentionDays * 24L * 60L * 60L * 1000L;
        try (Connection connection = DatabaseUtils.getConnection(plugin);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM records WHERE timestamp < ?");){
                preparedStatement.setLong(1, cutoffTime);
                int recordsDeleted = preparedStatement.executeUpdate();
                logger.info("\u5df2\u6e05\u7406 " + recordsDeleted + " \u6761\u8fc7\u671f\u8bb0\u5f55");
            }
            try (Statement statement = connection.createStatement();){
                int operationsDeleted = statement.executeUpdate("DELETE FROM operations WHERE id NOT IN (SELECT DISTINCT operation_id FROM records)");
                logger.info("\u5df2\u6e05\u7406 " + operationsDeleted + " \u6761\u65e0\u5173\u8054\u8bb0\u5f55\u7684\u64cd\u4f5c");
            }
        }
        catch (SQLException e) {
            logger.severe("\u6e05\u7406\u8fc7\u671f\u8bb0\u5f55\u5931\u8d25: " + e.getMessage());
        }
    }

    public static void saveSnapshot(Plugin plugin, EconomicSnapshot snapshotData, Logger logger) {
        String sql = "INSERT INTO economic_snapshots (snapshot_date, timestamp, total_money, player_count, active_players_7d, active_players_30d, gini_coefficient, median_balance, mean_balance, std_dev, top1_percentage, top5_percentage, top10_percentage) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        DatabaseUtils.runSqlWithRetry(logger, () -> {
            try (Connection conn = DatabaseUtils.getConnection(plugin);
                 PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setString(1, snapshotData.date);
                statement.setLong(2, snapshotData.timestamp);
                statement.setDouble(3, snapshotData.totalMoney);
                statement.setInt(4, snapshotData.playerCount);
                statement.setInt(5, snapshotData.activePlayers7d);
                statement.setInt(6, snapshotData.activePlayers30d);
                statement.setDouble(7, snapshotData.gini);
                statement.setDouble(8, snapshotData.median);
                statement.setDouble(9, snapshotData.mean);
                statement.setDouble(10, snapshotData.stdDev);
                statement.setDouble(11, snapshotData.top1Pct);
                statement.setDouble(12, snapshotData.top5Pct);
                statement.setDouble(13, snapshotData.top10Pct);
                statement.executeUpdate();
            }
        });
    }

    public static void saveOperationImpact(Plugin plugin, int operationId, OperationImpact impactData, Logger logger) {
        String sql = "INSERT OR REPLACE INTO operation_impact (operation_id, before_gini, after_gini, before_median, after_median, before_mean, after_mean, before_std_dev, after_std_dev, before_top1_pct, after_top1_pct, before_total_money, after_total_money, total_tax_collected, players_affected, timestamp) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        DatabaseUtils.runSqlWithRetry(logger, () -> {
            try (Connection conn = DatabaseUtils.getConnection(plugin);
                 PreparedStatement statement = conn.prepareStatement(sql);){
                statement.setInt(1, operationId);
                statement.setDouble(2, impactData.beforeGini);
                statement.setDouble(3, impactData.afterGini);
                statement.setDouble(4, impactData.beforeMedian);
                statement.setDouble(5, impactData.afterMedian);
                statement.setDouble(6, impactData.beforeMean);
                statement.setDouble(7, impactData.afterMean);
                statement.setDouble(8, impactData.beforeStdDev);
                statement.setDouble(9, impactData.afterStdDev);
                statement.setDouble(10, impactData.beforeTop1Pct);
                statement.setDouble(11, impactData.afterTop1Pct);
                statement.setDouble(12, impactData.beforeTotalMoney);
                statement.setDouble(13, impactData.afterTotalMoney);
                statement.setDouble(14, impactData.totalTaxCollected);
                statement.setInt(15, impactData.playersAffected);
                statement.setLong(16, impactData.timestamp);
                statement.executeUpdate();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EconomicSnapshot getLatestSnapshot(Plugin plugin, Logger logger) {
        String sql = "SELECT * FROM economic_snapshots ORDER BY timestamp DESC LIMIT 1";
        try (Connection conn = DatabaseUtils.getConnection(plugin);
             PreparedStatement statement = conn.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            if (!rs.next()) return null;
            EconomicSnapshot economicSnapshot = DatabaseUtils.extractSnapshotFromResultSet(rs);
            return economicSnapshot;
        }
        catch (SQLException e) {
            logger.severe("\u83b7\u53d6\u6700\u65b0\u5feb\u7167\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    public static List<EconomicSnapshot> getSnapshotHistory(Plugin plugin, int days, Logger logger) {
        long cutoffTime = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        String sql = "SELECT * FROM economic_snapshots WHERE timestamp >= ? ORDER BY timestamp ASC";
        ArrayList<EconomicSnapshot> snapshots = new ArrayList<EconomicSnapshot>();
        try (Connection conn = DatabaseUtils.getConnection(plugin);
             PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setLong(1, cutoffTime);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    snapshots.add(DatabaseUtils.extractSnapshotFromResultSet(rs));
                }
            }
        }
        catch (SQLException e) {
            logger.severe("\u83b7\u53d6\u5386\u53f2\u5feb\u7167\u5931\u8d25: " + e.getMessage());
        }
        return snapshots;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OperationImpact getOperationImpact(Plugin plugin, int operationId, Logger logger) {
        String sql = "SELECT * FROM operation_impact WHERE operation_id = ?";
        try (Connection conn = DatabaseUtils.getConnection(plugin);
             PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setInt(1, operationId);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return null;
                OperationImpact operationImpact = DatabaseUtils.extractImpactFromResultSet(rs);
                return operationImpact;
            }
        }
        catch (SQLException e) {
            logger.severe("\u83b7\u53d6\u64cd\u4f5c\u5f71\u54cd\u6570\u636e\u5931\u8d25: " + e.getMessage());
        }
        return null;
    }

    public static List<OperationImpact> getRecentImpacts(Plugin plugin, int limit, Logger logger) {
        String sql = "SELECT * FROM operation_impact ORDER BY timestamp DESC LIMIT ?";
        ArrayList<OperationImpact> impacts = new ArrayList<OperationImpact>();
        try (Connection conn = DatabaseUtils.getConnection(plugin);
             PreparedStatement statement = conn.prepareStatement(sql);){
            statement.setInt(1, limit);
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    impacts.add(DatabaseUtils.extractImpactFromResultSet(rs));
                }
            }
        }
        catch (SQLException e) {
            logger.severe("\u83b7\u53d6\u6700\u8fd1\u64cd\u4f5c\u5f71\u54cd\u5931\u8d25: " + e.getMessage());
        }
        return impacts;
    }

    private static EconomicSnapshot extractSnapshotFromResultSet(ResultSet rs) throws SQLException {
        EconomicSnapshot snapshot = new EconomicSnapshot();
        snapshot.id = rs.getInt("id");
        snapshot.date = rs.getString("snapshot_date");
        snapshot.timestamp = rs.getLong("timestamp");
        snapshot.totalMoney = rs.getDouble("total_money");
        snapshot.playerCount = rs.getInt("player_count");
        snapshot.activePlayers7d = rs.getInt("active_players_7d");
        snapshot.activePlayers30d = rs.getInt("active_players_30d");
        snapshot.gini = rs.getDouble("gini_coefficient");
        snapshot.median = rs.getDouble("median_balance");
        snapshot.mean = rs.getDouble("mean_balance");
        snapshot.stdDev = rs.getDouble("std_dev");
        snapshot.top1Pct = rs.getDouble("top1_percentage");
        snapshot.top5Pct = rs.getDouble("top5_percentage");
        snapshot.top10Pct = rs.getDouble("top10_percentage");
        return snapshot;
    }

    private static OperationImpact extractImpactFromResultSet(ResultSet rs) throws SQLException {
        OperationImpact impact = new OperationImpact();
        impact.operationId = rs.getInt("operation_id");
        impact.beforeGini = rs.getDouble("before_gini");
        impact.afterGini = rs.getDouble("after_gini");
        impact.beforeMedian = rs.getDouble("before_median");
        impact.afterMedian = rs.getDouble("after_median");
        impact.beforeMean = rs.getDouble("before_mean");
        impact.afterMean = rs.getDouble("after_mean");
        impact.beforeStdDev = rs.getDouble("before_std_dev");
        impact.afterStdDev = rs.getDouble("after_std_dev");
        impact.beforeTop1Pct = rs.getDouble("before_top1_pct");
        impact.afterTop1Pct = rs.getDouble("after_top1_pct");
        impact.beforeTotalMoney = rs.getDouble("before_total_money");
        impact.afterTotalMoney = rs.getDouble("after_total_money");
        impact.totalTaxCollected = rs.getDouble("total_tax_collected");
        impact.playersAffected = rs.getInt("players_affected");
        impact.timestamp = rs.getLong("timestamp");
        return impact;
    }

    @FunctionalInterface
    private static interface SqlRunnable {
        public void run() throws SQLException;
    }

    public static class EconomicSnapshot {
        public int id;
        public String date;
        public long timestamp;
        public double totalMoney;
        public int playerCount;
        public int activePlayers7d;
        public int activePlayers30d;
        public double gini;
        public double median;
        public double mean;
        public double stdDev;
        public double top1Pct;
        public double top5Pct;
        public double top10Pct;
    }

    public static class OperationImpact {
        public int operationId;
        public double beforeGini;
        public double afterGini;
        public double beforeMedian;
        public double afterMedian;
        public double beforeMean;
        public double afterMean;
        public double beforeStdDev;
        public double afterStdDev;
        public double beforeTop1Pct;
        public double afterTop1Pct;
        public double beforeTotalMoney;
        public double afterTotalMoney;
        public double totalTaxCollected;
        public int playersAffected;
        public long timestamp;
    }
}

