/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.cubexmc.ecobalancer.utils.VaultUtils;

public class EconomicMetrics {
    public static double calculateGini(List<Double> balances) {
        if (balances == null || balances.isEmpty()) {
            return 0.0;
        }
        ArrayList<Double> sorted = new ArrayList<Double>(balances);
        Collections.sort(sorted);
        double sum = 0.0;
        double weightedSum = 0.0;
        int n = sorted.size();
        for (int i = 0; i < n; ++i) {
            double balance = (Double)sorted.get(i);
            sum += balance;
            weightedSum += balance * (double)(i + 1);
        }
        if (sum == 0.0) {
            return 0.0;
        }
        return 2.0 * weightedSum / ((double)n * sum) - ((double)n + 1.0) / (double)n;
    }

    public static double calculateConcentration(List<Double> balances, double topPercentage) {
        if (balances == null || balances.isEmpty() || topPercentage <= 0.0 || topPercentage > 100.0) {
            return 0.0;
        }
        ArrayList<Double> sorted = new ArrayList<Double>(balances);
        Collections.sort(sorted);
        Collections.reverse(sorted);
        int n = sorted.size();
        int topCount = Math.max(1, (int)Math.ceil((double)n * topPercentage / 100.0));
        double topSum = 0.0;
        double totalSum = 0.0;
        for (int i = 0; i < n; ++i) {
            double balance = (Double)sorted.get(i);
            totalSum += balance;
            if (i >= topCount) continue;
            topSum += balance;
        }
        return totalSum == 0.0 ? 0.0 : topSum / totalSum;
    }

    public static List<Double> collectBalances(Integer activeDays) {
        ArrayList<Double> balances = new ArrayList<Double>();
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        long currentTime = System.currentTimeMillis();
        long cutoffTime = activeDays == null ? 0L : currentTime - (long)activeDays.intValue() * 24L * 60L * 60L * 1000L;
        for (OfflinePlayer player : players) {
            try {
                double balance;
                if (activeDays != null && player.getLastPlayed() < cutoffTime || !VaultUtils.hasAccount(player) || !((balance = VaultUtils.getBalance(player)) >= 0.0)) continue;
                balances.add(balance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return balances;
    }

    public static double calculateTotalMoney(List<Double> balances) {
        if (balances == null || balances.isEmpty()) {
            return 0.0;
        }
        return balances.stream().mapToDouble(Double::doubleValue).sum();
    }

    public static String getConcentrationLevel(double concentration) {
        if (concentration >= 0.7) {
            return "\u6781\u5ea6\u96c6\u4e2d";
        }
        if (concentration >= 0.5) {
            return "\u9ad8\u5ea6\u96c6\u4e2d";
        }
        if (concentration >= 0.3) {
            return "\u4e2d\u5ea6\u96c6\u4e2d";
        }
        return "\u5206\u6563";
    }

    public static String getGiniLevel(double gini) {
        if (gini >= 0.6) {
            return "\u6781\u5ea6\u4e0d\u5e73\u7b49";
        }
        if (gini >= 0.5) {
            return "\u9ad8\u5ea6\u4e0d\u5e73\u7b49";
        }
        if (gini >= 0.4) {
            return "\u4e2d\u7b49\u4e0d\u5e73\u7b49";
        }
        if (gini >= 0.3) {
            return "\u76f8\u5bf9\u5e73\u7b49";
        }
        return "\u9ad8\u5ea6\u5e73\u7b49";
    }

    public static String formatLargeNumber(double number) {
        if (number >= 1.0E9) {
            return String.format("%.2fB", number / 1.0E9);
        }
        if (number >= 1000000.0) {
            return String.format("%.2fM", number / 1000000.0);
        }
        if (number >= 1000.0) {
            return String.format("%.2fK", number / 1000.0);
        }
        return String.format("%.2f", number);
    }

    public static List<Double> getSortedBalances(List<Double> balances) {
        if (balances == null || balances.isEmpty()) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> sorted = new ArrayList<Double>(balances);
        Collections.sort(sorted);
        return sorted;
    }

    public static double calculateMedian(List<Double> sortedBalances) {
        if (sortedBalances == null || sortedBalances.isEmpty()) {
            return 0.0;
        }
        int n = sortedBalances.size();
        if (n % 2 == 0) {
            return (sortedBalances.get(n / 2 - 1) + sortedBalances.get(n / 2)) / 2.0;
        }
        return sortedBalances.get(n / 2);
    }

    public static double calculateStdDev(List<Double> balances, double mean) {
        if (balances == null || balances.isEmpty()) {
            return 0.0;
        }
        double sumSquaredDiff = 0.0;
        for (double balance : balances) {
            double diff = balance - mean;
            sumSquaredDiff += diff * diff;
        }
        return Math.sqrt(sumSquaredDiff / (double)balances.size());
    }

    public static double calculateMean(List<Double> balances) {
        if (balances == null || balances.isEmpty()) {
            return 0.0;
        }
        return EconomicMetrics.calculateTotalMoney(balances) / (double)balances.size();
    }
}

