/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import org.bukkit.plugin.java.JavaPlugin;

public class FileUtils {
    public static FileHandler initializeLogger(JavaPlugin plugin, Logger fileLogger) {
        File existingLogFile;
        File lockFile;
        File logDir = new File(plugin.getDataFolder() + File.separator + "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if ((lockFile = new File(plugin.getDataFolder() + File.separator + "logs" + File.separator + "latest.log.lck")).exists()) {
            lockFile.delete();
        }
        if ((existingLogFile = new File(plugin.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            FileUtils.compressLogFile(existingLogFile, plugin.getLogger());
        }
        try {
            FileHandler fileHandler = new FileHandler(plugin.getDataFolder() + File.separator + "logs" + File.separator + "latest.log", true);
            fileHandler.setFormatter(new SimpleFormatter());
            fileLogger.addHandler(fileHandler);
            fileLogger.setUseParentHandlers(false);
            return fileHandler;
        }
        catch (IOException e) {
            plugin.getLogger().severe("\u65e0\u6cd5\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6\u5904\u7406\u5668: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void compressLogFile(File logFile, Logger logger) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        String timestamp = dateFormat.format(new Date(logFile.lastModified()));
        File renamedLogFile = new File(logFile.getParent(), timestamp + ".log");
        if (!logFile.renameTo(renamedLogFile)) {
            logger.severe("\u65e0\u6cd5\u91cd\u547d\u540d\u65e5\u5fd7\u6587\u4ef6");
            return;
        }
        File compressedFile = new File(renamedLogFile.getParent(), renamedLogFile.getName() + ".gz");
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(renamedLogFile.toPath(), gzos);
        }
        catch (IOException e) {
            logger.severe("\u65e0\u6cd5\u538b\u7f29\u65e5\u5fd7\u6587\u4ef6: " + e.getMessage());
        }
        if (!renamedLogFile.delete()) {
            logger.severe("\u538b\u7f29\u540e\u65e0\u6cd5\u5220\u9664\u539f\u59cb\u65e5\u5fd7\u6587\u4ef6");
        }
    }

    public static void cleanupLogger(FileHandler fileHandler, Logger fileLogger, JavaPlugin plugin) {
        File logFile;
        if (fileHandler != null) {
            fileHandler.flush();
            fileLogger.removeHandler(fileHandler);
            fileHandler.close();
        }
        if ((logFile = new File(plugin.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            FileUtils.compressLogFile(logFile, plugin.getLogger());
        }
    }

    public static boolean ensureDirectoryExists(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return true;
    }
}

