/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class MessageUtils {
    public static String formatMessage(FileConfiguration config, String path, Map<String, String> placeholders, String prefix) {
        if (placeholders == null) {
            placeholders = new HashMap<String, String>();
        }
        placeholders.put("prefix", prefix);
        String message = config.getString(path, "Message not found!");
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static TextComponent formatComponent(FileConfiguration config, String path, Map<String, String> placeholders, String[] clickablePlaceholders, TextComponent[] clickableComponents, String prefix) {
        if (placeholders == null) {
            placeholders = new HashMap<String, String>();
        }
        placeholders.put("prefix", prefix);
        String message = config.getString(path, "Message not found!");
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            if (clickablePlaceholders != null) {
                boolean isClickable = false;
                for (String clickable : clickablePlaceholders) {
                    if (!entry.getKey().equals(clickable)) continue;
                    isClickable = true;
                    break;
                }
                if (isClickable) continue;
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
                continue;
            }
            message = message.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        TextComponent finalMessage = new TextComponent();
        if (clickablePlaceholders != null && clickableComponents != null) {
            String[] parts = message.split("%");
            for (int i = 0; i < parts.length; ++i) {
                if (i % 2 == 1 && i < parts.length - 1) {
                    boolean found = false;
                    for (int j = 0; j < clickablePlaceholders.length; ++j) {
                        if (!parts[i].equals(clickablePlaceholders[j])) continue;
                        finalMessage.addExtra((BaseComponent)clickableComponents[j]);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    finalMessage.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)("%" + parts[i] + "%"))));
                    continue;
                }
                finalMessage.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)parts[i])));
            }
        } else {
            finalMessage = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        return finalMessage;
    }

    public static void sendMessage(CommandSender sender, String message, Logger logger, boolean isLog) {
        if (sender != null) {
            for (String str : message.split("\n")) {
                sender.sendMessage(str);
            }
        }
        if (isLog && logger != null) {
            for (String str : message.split("\n")) {
                logger.info(str);
            }
        }
    }

    public static TextComponent createClickableComponent(String text, ClickEvent.Action clickAction, String clickValue, String hoverText) {
        TextComponent component = new TextComponent(text);
        component.setClickEvent(new ClickEvent(clickAction, clickValue));
        if (hoverText != null && !hoverText.isEmpty()) {
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create()));
        }
        return component;
    }
}

