/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.cubexmc.ecobalancer.utils.MessageUtils;

public class PageUtils {
    public static int calculateTotalPages(int totalItems, int pageSize) {
        return (totalItems + pageSize - 1) / pageSize;
    }

    public static boolean isValidPage(int page, int totalPages) {
        return page >= 1 && page <= totalPages;
    }

    public static int getStartIndex(int page, int pageSize) {
        return (page - 1) * pageSize;
    }

    public static int getEndIndex(int page, int pageSize, int totalItems) {
        return Math.min(PageUtils.getStartIndex(page, pageSize) + pageSize, totalItems);
    }

    public static TextComponent createPageNavigation(FileConfiguration langConfig, int currentPage, int totalPages, String commandFormat, String prefix) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("page", String.valueOf(currentPage));
        placeholders.put("total", String.valueOf(totalPages));
        TextComponent prevPage = new TextComponent();
        TextComponent nextPage = new TextComponent();
        if (currentPage > 1) {
            prevPage.setText(MessageUtils.formatMessage(langConfig, "messages.prev_page", null, prefix));
            prevPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(commandFormat, currentPage - 1)));
        } else {
            prevPage.setText(MessageUtils.formatMessage(langConfig, "messages.no_prev_page", null, prefix));
        }
        if (currentPage < totalPages) {
            nextPage.setText(MessageUtils.formatMessage(langConfig, "messages.next_page", null, prefix));
            nextPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(commandFormat, currentPage + 1)));
        } else {
            nextPage.setText(MessageUtils.formatMessage(langConfig, "messages.no_next_page", null, prefix));
        }
        placeholders.put("prev", prevPage.toPlainText());
        placeholders.put("next", nextPage.toPlainText());
        return MessageUtils.formatComponent(langConfig, "messages.page_navigation", placeholders, new String[]{"prev", "next"}, new TextComponent[]{prevPage, nextPage}, prefix);
    }

    public static <T> void renderPagination(CommandSender sender, List<T> items, int pageSize, int currentPage, ItemRenderer<T> renderer, String headerMessagePath, String footerMessagePath, String navigationMessagePath, String commandFormat, FileConfiguration langConfig, String invalidPageMessagePath, String prefix, Map<String, String> extraPlaceholders) {
        int totalPages = PageUtils.calculateTotalPages(items.size(), pageSize);
        if (!PageUtils.isValidPage(currentPage, totalPages)) {
            sender.sendMessage(MessageUtils.formatMessage(langConfig, invalidPageMessagePath, null, prefix));
            return;
        }
        int start = PageUtils.getStartIndex(currentPage, pageSize);
        int end = PageUtils.getEndIndex(currentPage, pageSize, items.size());
        if (headerMessagePath != null) {
            HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
            if (extraPlaceholders != null) {
                headerPlaceholders.putAll(extraPlaceholders);
            }
            sender.sendMessage(MessageUtils.formatMessage(langConfig, headerMessagePath, headerPlaceholders, prefix));
        }
        for (int i = start; i < end; ++i) {
            T item = items.get(i);
            renderer.render(sender, item, i);
        }
        if (navigationMessagePath != null) {
            TextComponent navigationComponent = PageUtils.createPageNavigation(langConfig, currentPage, totalPages, commandFormat, prefix);
            sender.spigot().sendMessage((BaseComponent)navigationComponent);
        }
        if (footerMessagePath != null) {
            sender.sendMessage(MessageUtils.formatMessage(langConfig, footerMessagePath, null, prefix));
        }
    }

    public static interface ItemRenderer<T> {
        public void render(CommandSender var1, T var2, int var3);
    }
}

