/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.ecobalancer.utils.SchedulerUtils;

public final class PlaytimeUtils {
    private static final Map<UUID, Long> playtimeTicks = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> fileMtime = new ConcurrentHashMap<UUID, Long>();
    private static final Gson GSON = new Gson();

    private PlaytimeUtils() {
    }

    public static void loadAllAsync(JavaPlugin plugin, String statsWorldName) {
        SchedulerUtils.runTaskAsync((Plugin)plugin, () -> PlaytimeUtils.loadAll(statsWorldName));
    }

    public static void loadAll(String statsWorldName) {
        File statsDir = PlaytimeUtils.resolveStatsDir(statsWorldName);
        if (statsDir == null || !statsDir.isDirectory()) {
            return;
        }
        File[] files = statsDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File f : files) {
            try {
                String base = f.getName().substring(0, f.getName().length() - 5);
                UUID uuid = UUID.fromString(base);
                long lm = f.lastModified();
                Long cachedMtime = fileMtime.get(uuid);
                if (cachedMtime != null && cachedMtime == lm) continue;
                long ticks = PlaytimeUtils.extractTicks(f);
                playtimeTicks.put(uuid, ticks);
                fileMtime.put(uuid, lm);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void ensureLoadedFor(UUID uuid, String statsWorldName) {
        if (playtimeTicks.containsKey(uuid)) {
            return;
        }
        File statsDir = PlaytimeUtils.resolveStatsDir(statsWorldName);
        if (statsDir == null) {
            playtimeTicks.put(uuid, 0L);
            return;
        }
        File f = new File(statsDir, uuid.toString() + ".json");
        if (!f.exists()) {
            playtimeTicks.put(uuid, 0L);
            return;
        }
        long ticks = PlaytimeUtils.extractTicks(f);
        playtimeTicks.put(uuid, ticks);
        fileMtime.put(uuid, f.lastModified());
    }

    public static long getPlaytimeTicks(UUID uuid) {
        return playtimeTicks.getOrDefault(uuid, 0L);
    }

    public static double getPlaytimeHours(UUID uuid) {
        return (double)PlaytimeUtils.getPlaytimeTicks(uuid) / 20.0 / 3600.0;
    }

    private static File resolveStatsDir(String statsWorldName) {
        World w;
        World world = statsWorldName == null || statsWorldName.isEmpty() ? (Bukkit.getWorlds().isEmpty() ? null : (World)Bukkit.getWorlds().get(0)) : (w = Bukkit.getWorld((String)statsWorldName));
        if (w == null) {
            return null;
        }
        return new File(w.getWorldFolder(), "stats");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long extractTicks(File jsonFile) {
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            JsonObject custom;
            JsonObject stats;
            JsonObject root = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
            if (root == null) {
                long l = 0L;
                return l;
            }
            JsonObject jsonObject = stats = root.has("stats") && root.get("stats").isJsonObject() ? root.getAsJsonObject("stats") : null;
            if (stats == null) {
                long l = 0L;
                return l;
            }
            JsonObject jsonObject2 = custom = stats.has("minecraft:custom") && stats.get("minecraft:custom").isJsonObject() ? stats.getAsJsonObject("minecraft:custom") : null;
            if (custom == null) {
                long l = 0L;
                return l;
            }
            if (custom.has("minecraft:play_time")) {
                long l = PlaytimeUtils.safeLong(custom.get("minecraft:play_time"));
                return l;
            }
            if (custom.has("minecraft:play_one_minute")) {
                long l = PlaytimeUtils.safeLong(custom.get("minecraft:play_one_minute"));
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private static long safeLong(JsonElement el) {
        try {
            return el.getAsLong();
        }
        catch (Throwable ignored) {
            return 0L;
        }
    }
}

