/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class SchedulerUtils {
    private static final Map<Plugin, Set<Object>> TRACKED_TASKS = new ConcurrentHashMap<Plugin, Set<Object>>();
    private static final Map<Object, Plugin> TASK_OWNERS = new ConcurrentHashMap<Object, Plugin>();

    private SchedulerUtils() {
        throw new AssertionError((Object)"This utility class cannot be instantiated.");
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void trackTask(Plugin plugin, Object handle) {
        if (plugin == null || handle == null) {
            return;
        }
        TRACKED_TASKS.computeIfAbsent(plugin, key -> ConcurrentHashMap.newKeySet()).add(handle);
        TASK_OWNERS.put(handle, plugin);
    }

    private static void untrackTask(Object handle) {
        if (handle == null) {
            return;
        }
        Plugin owner = TASK_OWNERS.remove(handle);
        if (owner == null) {
            return;
        }
        Set<Object> handles = TRACKED_TASKS.get(owner);
        if (handles == null) {
            return;
        }
        handles.remove(handle);
        if (handles.isEmpty()) {
            TRACKED_TASKS.remove(owner, handles);
        }
    }

    private static Runnable wrapOneShotRunnable(Runnable task, Object[] handleHolder) {
        return () -> {
            try {
                task.run();
            }
            finally {
                SchedulerUtils.untrackTask(handleHolder[0]);
            }
        };
    }

    private static Consumer<Object> wrapFoliaTask(Runnable task, boolean repeating) {
        return scheduledTask -> {
            try {
                task.run();
            }
            finally {
                if (!repeating) {
                    SchedulerUtils.untrackTask(scheduledTask);
                }
            }
        };
    }

    public static Object globalRun(Plugin plugin, Runnable task, long delay, long period) {
        boolean repeating;
        delay = Math.max(0L, delay);
        boolean bl = repeating = period > 0L;
        if (SchedulerUtils.isFolia()) {
            try {
                Object handle;
                Server server = Bukkit.getServer();
                Object globalScheduler = server.getClass().getMethod("getGlobalRegionScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                Consumer<Object> foliaTask = SchedulerUtils.wrapFoliaTask(task, repeating);
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = globalScheduler.getClass().getMethod("run", pluginClass, consumerClass);
                        handle = run.invoke(globalScheduler, plugin, foliaTask);
                    } else {
                        Method runDelayed = globalScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, Long.TYPE);
                        handle = runDelayed.invoke(globalScheduler, plugin, foliaTask, delay);
                    }
                } else {
                    Method runAtFixedRate = globalScheduler.getClass().getMethod("runAtFixedRate", pluginClass, consumerClass, Long.TYPE, Long.TYPE);
                    handle = runAtFixedRate.invoke(globalScheduler, plugin, foliaTask, Math.max(1L, delay), period);
                }
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            catch (Throwable server) {
                // empty catch block
            }
        }
        if (period < 0L) {
            if (delay == 0L) {
                if (Bukkit.isPrimaryThread()) {
                    task.run();
                    return null;
                }
                Object[] handleHolder = new Object[1];
                Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
                BukkitTask handle = Bukkit.getScheduler().runTask(plugin, wrapped);
                handleHolder[0] = handle;
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            Object[] handleHolder = new Object[1];
            Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
            BukkitTask handle = Bukkit.getScheduler().runTaskLater(plugin, wrapped, delay);
            handleHolder[0] = handle;
            SchedulerUtils.trackTask(plugin, handle);
            return handle;
        }
        BukkitTask handle = Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        SchedulerUtils.trackTask(plugin, handle);
        return handle;
    }

    public static void cancelTask(Object task) {
        if (task == null) {
            return;
        }
        try {
            Method cancel = task.getClass().getMethod("cancel", new Class[0]);
            cancel.invoke(task, new Object[0]);
        }
        catch (Throwable ignored) {
            try {
                if (task instanceof BukkitTask) {
                    ((BukkitTask)task).cancel();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            SchedulerUtils.untrackTask(task);
        }
    }

    public static Object entityRun(Plugin plugin, Entity entity, Runnable task, long delay, long period) {
        boolean repeating;
        delay = Math.max(0L, delay);
        boolean bl = repeating = period > 0L;
        if (SchedulerUtils.isFolia()) {
            try {
                Object handle;
                Object entityScheduler = entity.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
                Consumer<Object> foliaTask = SchedulerUtils.wrapFoliaTask(task, repeating);
                Runnable retiredCallback = () -> {
                    try {
                        plugin.getLogger().fine("Entity scheduler task cancelled: entity no longer exists");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                Class<Runnable> runnableClass = Runnable.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = entityScheduler.getClass().getMethod("run", pluginClass, consumerClass, runnableClass);
                        handle = run.invoke(entityScheduler, plugin, foliaTask, retiredCallback);
                    } else {
                        Method runDelayed = entityScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, runnableClass, Long.TYPE);
                        handle = runDelayed.invoke(entityScheduler, plugin, foliaTask, retiredCallback, delay);
                    }
                } else {
                    Method runAtFixedRate = entityScheduler.getClass().getMethod("runAtFixedRate", pluginClass, consumerClass, runnableClass, Long.TYPE, Long.TYPE);
                    handle = runAtFixedRate.invoke(entityScheduler, plugin, foliaTask, retiredCallback, Math.max(1L, delay), period);
                }
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            catch (Throwable entityScheduler) {
                // empty catch block
            }
        }
        if (period <= 0L) {
            if (delay == 0L) {
                if (Bukkit.isPrimaryThread()) {
                    task.run();
                    return null;
                }
                Object[] handleHolder = new Object[1];
                Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
                BukkitTask handle = Bukkit.getScheduler().runTask(plugin, wrapped);
                handleHolder[0] = handle;
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            Object[] handleHolder = new Object[1];
            Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
            BukkitTask handle = Bukkit.getScheduler().runTaskLater(plugin, wrapped, delay);
            handleHolder[0] = handle;
            SchedulerUtils.trackTask(plugin, handle);
            return handle;
        }
        BukkitTask handle = Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        SchedulerUtils.trackTask(plugin, handle);
        return handle;
    }

    public static Object regionRun(Plugin plugin, Location location, Runnable task, long delay, long period) {
        boolean repeating;
        delay = Math.max(0L, delay);
        boolean bl = repeating = period > 0L;
        if (SchedulerUtils.isFolia()) {
            try {
                Object handle;
                Server server = Bukkit.getServer();
                Object regionScheduler = server.getClass().getMethod("getRegionScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                Consumer<Object> foliaTask = SchedulerUtils.wrapFoliaTask(task, repeating);
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                Class<Location> locationClass = Location.class;
                if (period <= 0L) {
                    if (delay == 0L) {
                        Method run = regionScheduler.getClass().getMethod("run", pluginClass, locationClass, consumerClass);
                        handle = run.invoke(regionScheduler, plugin, location, foliaTask);
                    } else {
                        Method runDelayed = regionScheduler.getClass().getMethod("runDelayed", pluginClass, locationClass, consumerClass, Long.TYPE);
                        handle = runDelayed.invoke(regionScheduler, plugin, location, foliaTask, delay);
                    }
                } else {
                    Method runAtFixedRate = regionScheduler.getClass().getMethod("runAtFixedRate", pluginClass, locationClass, consumerClass, Long.TYPE, Long.TYPE);
                    handle = runAtFixedRate.invoke(regionScheduler, plugin, location, foliaTask, Math.max(1L, delay), period);
                }
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            catch (Throwable server) {
                // empty catch block
            }
        }
        if (period <= 0L) {
            if (delay == 0L) {
                if (Bukkit.isPrimaryThread()) {
                    task.run();
                    return null;
                }
                Object[] handleHolder = new Object[1];
                Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
                BukkitTask handle = Bukkit.getScheduler().runTask(plugin, wrapped);
                handleHolder[0] = handle;
                SchedulerUtils.trackTask(plugin, handle);
                return handle;
            }
            Object[] handleHolder = new Object[1];
            Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
            BukkitTask handle = Bukkit.getScheduler().runTaskLater(plugin, wrapped, delay);
            handleHolder[0] = handle;
            SchedulerUtils.trackTask(plugin, handle);
            return handle;
        }
        BukkitTask handle = Bukkit.getScheduler().runTaskTimer(plugin, task, delay, period);
        SchedulerUtils.trackTask(plugin, handle);
        return handle;
    }

    public static void asyncRun(Plugin plugin, Runnable task, long delay) {
        delay = Math.max(0L, delay);
        if (SchedulerUtils.isFolia()) {
            try {
                Object handle;
                Server server = Bukkit.getServer();
                Object asyncScheduler = server.getClass().getMethod("getAsyncScheduler", new Class[0]).invoke((Object)server, new Object[0]);
                Consumer<Object> foliaTask = SchedulerUtils.wrapFoliaTask(task, false);
                Class<Plugin> pluginClass = Plugin.class;
                Class<Consumer> consumerClass = Consumer.class;
                if (delay <= 0L) {
                    Method runNow = asyncScheduler.getClass().getMethod("runNow", pluginClass, consumerClass);
                    handle = runNow.invoke(asyncScheduler, plugin, foliaTask);
                } else {
                    Method runDelayed = asyncScheduler.getClass().getMethod("runDelayed", pluginClass, consumerClass, Long.TYPE, TimeUnit.class);
                    handle = runDelayed.invoke(asyncScheduler, new Object[]{plugin, foliaTask, delay * 50L, TimeUnit.MILLISECONDS});
                }
                SchedulerUtils.trackTask(plugin, handle);
                return;
            }
            catch (Throwable server) {
                // empty catch block
            }
        }
        Object[] handleHolder = new Object[1];
        Runnable wrapped = SchedulerUtils.wrapOneShotRunnable(task, handleHolder);
        long ticks = delay <= 0L ? 0L : Math.max(1L, delay);
        BukkitTask handle = Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, wrapped, ticks);
        handleHolder[0] = handle;
        SchedulerUtils.trackTask(plugin, handle);
    }

    public static void safeTeleport(Plugin plugin, Player player, Location dest) {
        if (player == null || dest == null) {
            return;
        }
        try {
            Method teleportAsync = player.getClass().getMethod("teleportAsync", Location.class);
            teleportAsync.invoke((Object)player, dest);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (SchedulerUtils.isFolia()) {
            SchedulerUtils.entityRun(plugin, (Entity)player, () -> {
                try {
                    player.teleport(dest);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 0L, -1L);
        } else if (Bukkit.isPrimaryThread()) {
            player.teleport(dest);
        } else {
            Bukkit.getScheduler().runTask(plugin, () -> player.teleport(dest));
        }
    }

    public static Object runTask(Plugin plugin, Runnable task) {
        return SchedulerUtils.globalRun(plugin, task, 0L, -1L);
    }

    public static Object runTaskLater(Plugin plugin, Runnable task, long delay) {
        return SchedulerUtils.globalRun(plugin, task, delay, -1L);
    }

    public static Object runTaskTimer(Plugin plugin, Runnable task, long delay, long period) {
        return SchedulerUtils.globalRun(plugin, task, delay, period);
    }

    public static void runTaskAsync(Plugin plugin, Runnable task) {
        SchedulerUtils.asyncRun(plugin, task, 0L);
    }

    public static void runTaskLaterAsync(Plugin plugin, Runnable task, long delay) {
        SchedulerUtils.asyncRun(plugin, task, delay);
    }

    public static void cancelAllTasks(Plugin plugin) {
        Set<Object> handles;
        if (plugin == null) {
            return;
        }
        if (!SchedulerUtils.isFolia()) {
            try {
                Bukkit.getScheduler().cancelTasks(plugin);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if ((handles = TRACKED_TASKS.remove(plugin)) == null) {
            return;
        }
        for (Object handle : handles) {
            SchedulerUtils.cancelTask(handle);
        }
    }
}

