/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.cubexmc.ecobalancer.utils.VaultUtils;

public class StatisticsUtils {
    public static double calculateMedian(List<Double> values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        ArrayList<Double> sortedValues = new ArrayList<Double>(values);
        Collections.sort(sortedValues);
        int size = sortedValues.size();
        if (size % 2 == 0) {
            return ((Double)sortedValues.get(size / 2 - 1) + (Double)sortedValues.get(size / 2)) / 2.0;
        }
        return (Double)sortedValues.get(size / 2);
    }

    public static double calculateStandardDeviation(List<Double> values, double mean) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (double value : values) {
            sum += Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(sum / (double)values.size());
    }

    public static double calculatePercentile(double balance, List<Double> values) {
        if (values == null || values.isEmpty()) {
            return 0.0;
        }
        int totalPlayers = values.size();
        int playersBelow = (int)values.stream().filter(b -> b < balance).count();
        return (double)playersBelow / (double)totalPlayers * 100.0;
    }

    public static String formatNumber(double number) {
        if (number >= 1.0E9) {
            return String.format("%.1fb", number / 1.0E9);
        }
        if (number >= 1000000.0) {
            return String.format("%.1fm", number / 1000000.0);
        }
        if (number >= 1000.0) {
            return String.format("%.1fk", number / 1000.0);
        }
        return String.format("%.1f", number);
    }

    public static List<Double> collectBalancesInRange(double low, double high) {
        OfflinePlayer[] players;
        ArrayList<Double> balances = new ArrayList<Double>();
        for (OfflinePlayer player : players = Bukkit.getOfflinePlayers()) {
            try {
                double balance;
                if (!VaultUtils.hasAccount(player) || !((balance = VaultUtils.getBalance(player)) >= low) || !(balance <= high)) continue;
                balances.add(balance);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return balances;
    }

    public static int[] createHistogram(List<Double> values, int numBars) {
        if (values == null || values.isEmpty() || numBars <= 0) {
            return new int[0];
        }
        double min = values.stream().min(Double::compareTo).orElse(0.0);
        double max = values.stream().max(Double::compareTo).orElse(0.0);
        double range = max - min;
        double barWidth = range / (double)numBars;
        int[] histogram = new int[numBars];
        for (double value : values) {
            int barIndex = (int)((value - min) / barWidth);
            if (barIndex == numBars) {
                // empty if block
            }
            int n = --barIndex;
            histogram[n] = histogram[n] + 1;
        }
        return histogram;
    }
}

