/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.utils;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultUtils {
    private static Economy economy = null;

    public static boolean setupEconomy(JavaPlugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            plugin.getLogger().severe("\u672a\u627e\u5230Vault\u63d2\u4ef6\uff0c\u7ecf\u6d4e\u7cfb\u7edf\u65e0\u6cd5\u521d\u59cb\u5316");
            return false;
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            plugin.getLogger().severe("\u672a\u627e\u5230Vault\u7ecf\u6d4e\u670d\u52a1\u63d0\u4f9b\u8005");
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    public static Economy getEconomy() {
        return economy;
    }

    public static boolean hasAccount(OfflinePlayer player) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        return economy.hasAccount(player);
    }

    public static double getBalance(OfflinePlayer player) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        return economy.getBalance(player);
    }

    public static boolean depositPlayer(OfflinePlayer player, double amount) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        return economy.depositPlayer(player, amount).transactionSuccess();
    }

    public static boolean withdrawPlayer(OfflinePlayer player, double amount) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        return economy.withdrawPlayer(player, amount).transactionSuccess();
    }

    public static boolean setupTaxAccount(String taxAccountName) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        if (economy.hasAccount(taxAccountName)) {
            return true;
        }
        boolean created = economy.createPlayerAccount(taxAccountName);
        return created;
    }

    public static double getTaxAccountBalance(String taxAccountName) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        if (!economy.hasAccount(taxAccountName)) {
            return 0.0;
        }
        return economy.getBalance(taxAccountName);
    }

    public static boolean depositToTaxAccount(String taxAccountName, double amount) {
        if (economy == null) {
            throw new IllegalStateException("Vault\u7ecf\u6d4e\u7cfb\u7edf\u672a\u521d\u59cb\u5316");
        }
        if (!economy.hasAccount(taxAccountName) && !VaultUtils.setupTaxAccount(taxAccountName)) {
            return false;
        }
        return economy.depositPlayer(taxAccountName, amount).transactionSuccess();
    }
}

