/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.ecobalancer.commands.CheckAllCommand;
import org.cubexmc.ecobalancer.commands.CheckPlayerCommand;
import org.cubexmc.ecobalancer.commands.UtilCommand;
import org.cubexmc.ecobalancer.listeners.AdminLoginListener;
import org.cubexmc.ecobalancer.metrics.Metrics;

public final class EcoBalancer
extends JavaPlugin {
    private static Economy econ = null;
    private static Permission perms = null;
    private static Chat chat = null;
    private boolean deductBasedOnTime;
    private int inactiveDaysToDeduct;
    private TreeMap<Integer, Double> taxBrackets = new TreeMap();
    private int inactiveDaysToClear;
    private FileHandler fileHandler;
    private Logger fileLogger = Logger.getLogger("EcoBalancerFileLogger");
    private String scheduleType;
    private List<Integer> scheduleDaysOfWeek;
    private List<Integer> scheduleDatesOfMonth;
    private String checkTime;
    private FileConfiguration langConfig;
    private boolean taxAccount;
    private String taxAccountName;
    private String messagePrefix;

    public void onEnable() {
        File existingLogFile;
        File lockFile;
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.loadConfiguration();
        File logDir = new File(this.getDataFolder() + File.separator + "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if ((lockFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log.lck")).exists()) {
            lockFile.delete();
        }
        if ((existingLogFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(existingLogFile);
        }
        try {
            this.fileHandler = new FileHandler(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log", true);
            this.fileHandler.setFormatter(new SimpleFormatter());
            this.fileLogger.addHandler(this.fileHandler);
            this.fileLogger.setUseParentHandlers(false);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not create the log file handler for EcoBalancer.");
            e.printStackTrace();
        }
        int pluginId = 20269;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
        if (this.taxAccount && !econ.hasAccount(this.taxAccountName)) {
            econ.createPlayerAccount(this.taxAccountName);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new AdminLoginListener(this), (Plugin)this);
        this.getCommand("ecobal").setExecutor((CommandExecutor)new UtilCommand(this));
        this.getCommand("checkall").setExecutor((CommandExecutor)new CheckAllCommand(this));
        this.getCommand("checkplayer").setExecutor((CommandExecutor)new CheckPlayerCommand(this));
        this.getLogger().info("EcoBalancer enabled!");
    }

    public boolean useTaxAccount() {
        return this.taxAccount;
    }

    public String getTaxAccountName() {
        return this.taxAccountName;
    }

    public String getTaxAccountBalance() {
        return String.format("%.2f", econ.getBalance(this.taxAccountName));
    }

    public void loadConfiguration() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.loadLangFile();
        this.messagePrefix = this.langConfig.getString("prefix", "&7[&6EcoBalancer&7]&r");
        this.scheduleType = this.getConfig().getString("check-schedule.type", "daily");
        this.scheduleDaysOfWeek = this.getConfig().getIntegerList("check-schedule.days-of-week");
        this.scheduleDatesOfMonth = this.getConfig().getIntegerList("check-schedule.dates-of-month");
        this.checkTime = this.getConfig().getString("check-time", "01:00");
        this.scheduleCheck(this.calculateNextDelay());
        this.deductBasedOnTime = this.getConfig().getBoolean("deduct-based-on-time", false);
        this.inactiveDaysToDeduct = this.getConfig().getInt("inactive-days-to-deduct", 50);
        this.inactiveDaysToClear = this.getConfig().getInt("inactive-days-to-clear", 500);
        List rawTaxBrackets = this.getConfig().getMapList("tax-brackets");
        this.taxAccount = this.getConfig().getBoolean("tax-account", false);
        this.taxAccountName = this.taxAccount ? this.getConfig().getString("tax-account-name", "tax") : null;
        for (Map bracket : rawTaxBrackets) {
            Integer threshold = bracket.get("threshold") == null ? Integer.MAX_VALUE : (Integer)bracket.get("threshold");
            Double rate = (Double)bracket.get("rate");
            this.taxBrackets.put(threshold, rate);
        }
    }

    private void loadLangFile() {
        File langFile = new File(this.getDataFolder(), "lang.yml");
        if (!langFile.exists()) {
            this.saveResource("lang.yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders) {
        if (placeholders == null) {
            placeholders = new HashMap<String, String>();
        }
        placeholders.put("prefix", this.messagePrefix);
        String message = this.langConfig.getString(path, "Message not found!");
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void onDisable() {
        File logFile;
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileLogger.removeHandler(this.fileHandler);
            this.fileHandler.close();
        }
        if ((logFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(logFile);
        }
        this.getLogger().info("EcoBalancer disabled.");
    }

    private void compressExistingLogFile(File logFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        String timestamp = dateFormat.format(new Date(logFile.lastModified()));
        File renamedLogFile = new File(logFile.getParent(), timestamp + ".log");
        if (!logFile.renameTo(renamedLogFile)) {
            this.getLogger().severe("Could not rename the log file.");
            return;
        }
        File compressedFile = new File(renamedLogFile.getParent(), renamedLogFile.getName() + ".gz");
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(renamedLogFile.toPath(), gzos);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not compress the log file: " + e.getMessage());
        }
        if (!renamedLogFile.delete()) {
            this.getLogger().severe("Could not delete the original log file after compression.");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("EcoBalancer disabled [plugin=null]");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("EcoBalancer disabled [rsp=null]");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        this.getLogger().info("" + (econ != null));
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void checkBalance(CommandSender sender, long currentTime, OfflinePlayer player, boolean log) {
        long lastPlayed = player.getLastPlayed();
        long daysOffline = (currentTime - lastPlayed) / 86400000L;
        double balance = econ.hasAccount(player) ? econ.getBalance(player) : 0.0;
        Double deductionRate = 0.0;
        if (this.taxAccount && player.getName().equals(this.taxAccountName)) {
            return;
        }
        Map.Entry<Integer, Double> entry = this.taxBrackets.higherEntry((int)balance);
        if (entry != null) {
            deductionRate = entry.getValue();
        }
        if (deductionRate == null) {
            deductionRate = 0.0;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("days_offline", String.valueOf(daysOffline));
        if (balance < 0.0) {
            econ.depositPlayer(player, -1.0 * balance);
            placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
        } else if (balance > 0.0) {
            if (this.deductBasedOnTime) {
                if (daysOffline > (long)this.inactiveDaysToClear) {
                    econ.withdrawPlayer(player, balance);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, balance);
                    }
                    placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
                    this.sendMessage(sender, "messages.offline_extreme", placeholders, log);
                } else if (daysOffline > (long)this.inactiveDaysToDeduct) {
                    double deduction = Math.min(balance, balance * deductionRate);
                    placeholders.put("deduction", String.format("%.2f", deduction));
                    econ.withdrawPlayer(player, deduction);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, deduction);
                    }
                    this.sendMessage(sender, "messages.offline_moderate", placeholders, log);
                } else {
                    this.sendMessage(sender, "messages.offline_active", placeholders, false);
                }
            } else {
                double deduction = Math.min(balance, balance * deductionRate);
                placeholders.put("deduction", String.format("%.2f", deduction));
                econ.withdrawPlayer(player, deduction);
                if (this.taxAccount) {
                    econ.depositPlayer(this.taxAccountName, deduction);
                }
                this.sendMessage(sender, "messages.deduction_made", placeholders, log);
            }
        } else {
            this.sendMessage(sender, "messages.zero_balance", placeholders, log);
        }
    }

    private void sendMessage(CommandSender sender, String path, Map<String, String> placeholders, boolean isLog) {
        String message = this.getFormattedMessage(path, placeholders);
        if (sender != null) {
            for (String str : message.split("\n")) {
                sender.sendMessage(str);
            }
        }
        if (isLog) {
            for (String str : message.split("\n")) {
                this.fileLogger.info(str);
            }
        }
    }

    private long calculateNextDelay() {
        Calendar now = Calendar.getInstance();
        switch (this.scheduleType) {
            case "daily": {
                return this.calculateDelayForDaily(now);
            }
            case "weekly": {
                return this.calculateDelayForWeekly(now);
            }
            case "monthly": {
                return this.calculateDelayForMonthly(now);
            }
        }
        return this.calculateDelayForDaily(now);
    }

    private long calculateDelayForDaily(Calendar now) {
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        if (nextCheck.before(now)) {
            nextCheck.add(5, 1);
        }
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForWeekly(Calendar now) {
        long delayForToday;
        int today = now.get(7);
        if (this.scheduleDaysOfWeek.contains(today) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDaysOfWeek.stream().sorted().filter(dayOfWeek -> dayOfWeek > today).map(dayOfWeek -> dayOfWeek - today).findFirst().orElse(7 + this.scheduleDaysOfWeek.get(0) - today);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(7, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForMonthly(Calendar now) {
        long delayForToday;
        int dayOfMonth = now.get(5);
        if (this.scheduleDatesOfMonth.contains(dayOfMonth) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDatesOfMonth.stream().filter(date -> date > dayOfMonth).map(date -> date - dayOfMonth).findFirst().orElse(this.scheduleDatesOfMonth.get(0) + now.getActualMaximum(5) - dayOfMonth);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(5, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private void scheduleCheck(long delay) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            this.checkAll(null);
            this.scheduleCheck(this.calculateNextDelay());
        }, delay);
    }

    public void checkAll(final CommandSender sender) {
        final long currentTime = System.currentTimeMillis();
        final OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        int batchSize = 100;
        int delay = 10;
        class BatchRunnable
        implements Runnable {
            private int index = 0;

            BatchRunnable() {
            }

            @Override
            public void run() {
                int start = this.index;
                int end = Math.min(this.index + 100, players.length);
                for (int i = this.index; i < end; ++i) {
                    OfflinePlayer player = players[i];
                    EcoBalancer.this.checkBalance(null, currentTime, player, false);
                }
                this.index += 100;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("start", Integer.toString(start));
                placeholders.put("end", Integer.toString(end));
                placeholders.put("batch", Integer.toString(end - start));
                placeholders.put("total_players", Integer.toString(players.length));
                EcoBalancer.this.sendMessage(sender, "messages.players_processing", placeholders, true);
                if (this.index < players.length) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)EcoBalancer.this, (Runnable)this, 10L);
                } else {
                    Bukkit.getScheduler().runTask((Plugin)EcoBalancer.this, () -> EcoBalancer.this.sendMessage(sender, "messages.all_players_processed", null, true));
                }
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new BatchRunnable());
    }
}

