/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.ecobalancer.commands.CheckAllCommand;
import org.cubexmc.ecobalancer.commands.CheckPlayerCommand;
import org.cubexmc.ecobalancer.commands.CheckRecordCommand;
import org.cubexmc.ecobalancer.commands.CheckRecordsCommand;
import org.cubexmc.ecobalancer.commands.DescripStatsCommand;
import org.cubexmc.ecobalancer.commands.IntervalCommand;
import org.cubexmc.ecobalancer.commands.PercentileCommand;
import org.cubexmc.ecobalancer.commands.RestoreCommand;
import org.cubexmc.ecobalancer.commands.UtilCommand;
import org.cubexmc.ecobalancer.listeners.AdminLoginListener;
import org.cubexmc.ecobalancer.metrics.Metrics;

public final class EcoBalancer
extends JavaPlugin {
    private static Economy econ = null;
    private static Chat chat = null;
    private boolean deductBasedOnTime;
    private int inactiveDaysToDeduct;
    private TreeMap<Integer, Double> taxBrackets = new TreeMap();
    private int inactiveDaysToClear;
    private FileHandler fileHandler;
    private Logger fileLogger = Logger.getLogger("EcoBalancerFileLogger");
    private int recordRetentionDays;
    private String scheduleType;
    private List<Integer> scheduleDaysOfWeek;
    private List<Integer> scheduleDatesOfMonth;
    private String checkTime;
    private FileConfiguration langConfig;
    private boolean taxAccount;
    private String taxAccountName;
    private String messagePrefix;

    public void onEnable() {
        File existingLogFile;
        File lockFile;
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.loadConfiguration();
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        if (!databaseFile.exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("\u65e0\u6cd5\u521b\u5efa\u6570\u636e\u5e93\u6587\u4ef6: " + e.getMessage());
            }
        }
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS operations (id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, is_restored BOOLEAN NOT NULL)");
            }
            statement = connection.createStatement();
            try {
                statement.execute("CREATE TABLE IF NOT EXISTS records (id INTEGER PRIMARY KEY AUTOINCREMENT, player_name TEXT NOT NULL, player TEXT NOT NULL, old_balance REAL NOT NULL, new_balance REAL NOT NULL, deduction REAL NOT NULL, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, operation_id INTEGER NOT NULL)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("\u68c0\u67e5\u6216\u521b\u5efa\u6570\u636e\u5e93\u8868\u65f6\u51fa\u9519: " + e.getMessage());
        }
        long initialDelay = this.calculateDelayForDaily(Calendar.getInstance(), 0, 0);
        long cleanupPeriod = 1728000L;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::cleanupRecords, initialDelay, cleanupPeriod);
        File logDir = new File(this.getDataFolder() + File.separator + "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if ((lockFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log.lck")).exists()) {
            lockFile.delete();
        }
        if ((existingLogFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(existingLogFile);
        }
        try {
            this.fileHandler = new FileHandler(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log", true);
            this.fileHandler.setFormatter(new SimpleFormatter());
            this.fileLogger.addHandler(this.fileHandler);
            this.fileLogger.setUseParentHandlers(false);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not create the log file handler for EcoBalancer.");
            e.printStackTrace();
        }
        int pluginId = 20269;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
        if (this.taxAccount && !econ.hasAccount(this.taxAccountName)) {
            econ.createPlayerAccount(this.taxAccountName);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new AdminLoginListener(this), (Plugin)this);
        this.getCommand("ecobal").setExecutor((CommandExecutor)new UtilCommand(this));
        this.getCommand("checkall").setExecutor((CommandExecutor)new CheckAllCommand(this));
        this.getCommand("checkplayer").setExecutor((CommandExecutor)new CheckPlayerCommand(this));
        this.getCommand("stats").setExecutor((CommandExecutor)new DescripStatsCommand(this));
        this.getCommand("perc").setExecutor((CommandExecutor)new PercentileCommand(this));
        this.getCommand("checkrecords").setExecutor((CommandExecutor)new CheckRecordsCommand(this));
        this.getCommand("checkrecord").setExecutor((CommandExecutor)new CheckRecordCommand(this));
        this.getCommand("restore").setExecutor((CommandExecutor)new RestoreCommand(this));
        this.getCommand("interval").setExecutor((CommandExecutor)new IntervalCommand(this));
        this.displayAsciiArt();
        this.getLogger().info("EcoBalancer enabled!");
    }

    private void displayAsciiArt() {
        String[] asciiArt = new String[]{"\u2593\u2588\u2588\u2588\u2588\u2588  \u2584\u2588\u2588\u2588\u2588\u2584   \u2592\u2588\u2588\u2588\u2588\u2588   \u2584\u2584\u2584\u2584    \u2584\u2584\u2584       \u2588\u2588\u2593    ", "\u2593\u2588   \u2580 \u2592\u2588\u2588\u2580 \u2580\u2588  \u2592\u2588\u2588\u2592  \u2588\u2588\u2592\u2593\u2588\u2588\u2588\u2588\u2588\u2584 \u2592\u2588\u2588\u2588\u2588\u2584    \u2593\u2588\u2588\u2592    ", "\u2592\u2588\u2588\u2588   \u2592\u2593\u2588    \u2584 \u2592\u2588\u2588\u2591  \u2588\u2588\u2592\u2592\u2588\u2588\u2592 \u2584\u2588\u2588\u2592\u2588\u2588  \u2580\u2588\u2584  \u2592\u2588\u2588\u2591    ", "\u2592\u2593\u2588  \u2584 \u2592\u2593\u2593\u2584 \u2584\u2588\u2588\u2592\u2592\u2588\u2588   \u2588\u2588\u2591\u2592\u2588\u2588\u2591\u2588\u2580  \u2591\u2588\u2588\u2584\u2584\u2584\u2584\u2588\u2588 \u2592\u2588\u2588\u2591    ", "\u2591\u2592\u2588\u2588\u2588\u2588\u2592\u2592 \u2593\u2588\u2588\u2588\u2580 \u2591\u2591 \u2588\u2588\u2588\u2588\u2593\u2592\u2591\u2591\u2593\u2588  \u2580\u2588\u2593 \u2593\u2588   \u2593\u2588\u2588\u2592\u2591\u2588\u2588\u2588\u2588\u2588\u2588\u2592", "\u2591\u2591 \u2592\u2591 \u2591\u2591 \u2591\u2592 \u2592  \u2591\u2591 \u2592\u2591\u2592\u2591\u2592\u2591 \u2591\u2592\u2593\u2588\u2588\u2588\u2580\u2592 \u2592\u2592   \u2593\u2592\u2588\u2591\u2591 \u2592\u2591\u2593  \u2591", " \u2591 \u2591  \u2591  \u2591  \u2592     \u2591 \u2592 Version: " + this.getDescription().getVersion(), "   \u2591   \u2591        \u2591 \u2591 \u2591 Author: " + (String)this.getDescription().getAuthors().get(0), "   \u2591  \u2591\u2591 \u2591          \u2591 Website: " + this.getDescription().getWebsite(), "                      Powered by CubeX"};
        String ANSI_RESET = "\u001b[0m";
        String ANSI_YELLOW = "\u001b[33m";
        String ANSI_GREEN = "\u001b[32m";
        String ANSI_CYAN = "\u001b[36m";
        String ANSI_RED = "\u001b[31m";
        String ANSI_WHITE = "\u001b[37m";
        this.getLogger().info("");
        for (int i = 0; i < asciiArt.length; ++i) {
            String line = asciiArt[i];
            if (i < 6) {
                line = "\u001b[33m" + line + "\u001b[0m";
            } else if (i < 9) {
                line = "\u001b[33m" + line.substring(0, 21) + "\u001b[0m" + line.substring(21) + "\u001b[0m";
            } else if (i == 9) {
                line = line.replace("Cube", "\u001b[31mCube\u001b[37m").replace("X", "\u001b[37mX\u001b[0m");
            }
            this.getLogger().info(line);
        }
        this.getLogger().info("");
    }

    public boolean useTaxAccount() {
        return this.taxAccount;
    }

    public String getTaxAccountName() {
        return this.taxAccountName;
    }

    public String getTaxAccountBalance() {
        return String.format("%.2f", econ.getBalance(this.taxAccountName));
    }

    public void loadConfiguration() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.loadLangFile();
        this.messagePrefix = this.langConfig.getString("prefix", "&7[&6EcoBalancer&7]&r");
        this.recordRetentionDays = this.getConfig().getInt("record-retention-days", 30);
        this.scheduleType = this.getConfig().getString("check-schedule.type", "daily");
        this.scheduleDaysOfWeek = this.getConfig().getIntegerList("check-schedule.days-of-week");
        this.scheduleDatesOfMonth = this.getConfig().getIntegerList("check-schedule.dates-of-month");
        this.checkTime = this.getConfig().getString("check-time", "01:00");
        this.scheduleCheck(this.calculateNextDelay());
        this.deductBasedOnTime = this.getConfig().getBoolean("deduct-based-on-time", false);
        this.inactiveDaysToDeduct = this.getConfig().getInt("inactive-days-to-deduct", 50);
        this.inactiveDaysToClear = this.getConfig().getInt("inactive-days-to-clear", 500);
        List rawTaxBrackets = this.getConfig().getMapList("tax-brackets");
        this.taxAccount = this.getConfig().getBoolean("tax-account", false);
        this.taxAccountName = this.taxAccount ? this.getConfig().getString("tax-account-name", "tax") : null;
        for (Map bracket : rawTaxBrackets) {
            Integer threshold = bracket.get("threshold") == null ? Integer.MAX_VALUE : (Integer)bracket.get("threshold");
            Double rate = ((Number)bracket.get("rate")).doubleValue();
            this.taxBrackets.put(threshold, rate);
        }
    }

    private void loadLangFile() {
        String lang = this.getConfig().getString("language", "en_US");
        System.out.println("Loading language file: " + lang);
        File langFile = new File(this.getDataFolder(), "lang" + File.separator + lang + ".yml");
        if (!langFile.exists()) {
            this.saveResource("lang" + File.separator + lang + ".yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders) {
        if (placeholders == null) {
            placeholders = new HashMap<String, String>();
        }
        placeholders.put("prefix", this.messagePrefix);
        String message = this.langConfig.getString(path, "Message not found!");
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public TextComponent getFormattedMessage(String path, Map<String, String> placeholders, String[] clickablePlaceholders, TextComponent[] clickableComponents) {
        if (placeholders == null) {
            placeholders = new HashMap<String, String>();
        }
        placeholders.put("prefix", this.messagePrefix);
        String messageTemplate = this.langConfig.getString(path, "Message not found!");
        TextComponent finalMessage = new TextComponent("");
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            if (Arrays.asList(clickablePlaceholders).contains(entry.getKey())) continue;
            messageTemplate = messageTemplate.replace("%" + entry.getKey() + "%", entry.getValue());
        }
        String[] messageParts = messageTemplate.split("%", -1);
        for (int i = 0; i < messageParts.length; ++i) {
            String part = messageParts[i];
            int placeholderIndex = -1;
            for (int j = 0; j < clickablePlaceholders.length; ++j) {
                if (!part.startsWith(clickablePlaceholders[j])) continue;
                placeholderIndex = j;
                break;
            }
            if (placeholderIndex != -1) {
                finalMessage.addExtra((BaseComponent)clickableComponents[placeholderIndex]);
                String remainingText = part.substring(clickablePlaceholders[placeholderIndex].length());
                if (remainingText.isEmpty()) continue;
                finalMessage.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)remainingText)));
                continue;
            }
            if (part.isEmpty()) continue;
            finalMessage.addExtra((BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)part)));
        }
        return finalMessage;
    }

    public void onDisable() {
        File logFile;
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileLogger.removeHandler(this.fileHandler);
            this.fileHandler.close();
        }
        if ((logFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(logFile);
        }
        this.getLogger().info("EcoBalancer disabled.");
    }

    private void compressExistingLogFile(File logFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        String timestamp = dateFormat.format(new Date(logFile.lastModified()));
        File renamedLogFile = new File(logFile.getParent(), timestamp + ".log");
        if (!logFile.renameTo(renamedLogFile)) {
            this.getLogger().severe("Could not rename the log file.");
            return;
        }
        File compressedFile = new File(renamedLogFile.getParent(), renamedLogFile.getName() + ".gz");
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(renamedLogFile.toPath(), gzos);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not compress the log file: " + e.getMessage());
        }
        if (!renamedLogFile.delete()) {
            this.getLogger().severe("Could not delete the original log file after compression.");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("EcoBalancer disabled [plugin=null]");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("EcoBalancer disabled [rsp=null]");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        this.getLogger().info("" + (econ != null));
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void checkBalance(CommandSender sender, long currentTime, OfflinePlayer player, boolean log, boolean isCheckAll, int operationId) {
        long lastPlayed = player.getLastPlayed();
        long daysOffline = (currentTime - lastPlayed) / 86400000L;
        double balance = econ.hasAccount(player) ? econ.getBalance(player) : 0.0;
        Double deductionRate = 0.0;
        double oldBalance = balance;
        if (this.taxAccount && player.getName().equals(this.taxAccountName)) {
            return;
        }
        Map.Entry<Integer, Double> entry = this.taxBrackets.higherEntry((int)balance);
        if (entry != null) {
            deductionRate = entry.getValue();
        }
        if (deductionRate == null) {
            deductionRate = 0.0;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("days_offline", String.valueOf(daysOffline));
        if (balance < 0.0) {
            econ.depositPlayer(player, -1.0 * balance);
            placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
            this.sendMessage(sender, "messages.negative_balance", placeholders, log);
        } else if (balance > 0.0) {
            double deduction;
            if (this.deductBasedOnTime) {
                if (daysOffline > (long)this.inactiveDaysToClear) {
                    econ.withdrawPlayer(player, balance);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, balance);
                    }
                    placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
                    this.sendMessage(sender, "messages.offline_extreme", placeholders, log);
                } else if (daysOffline > (long)this.inactiveDaysToDeduct) {
                    deduction = Math.min(balance, balance * deductionRate);
                    placeholders.put("deduction", String.format("%.2f", deduction));
                    econ.withdrawPlayer(player, deduction);
                    if (this.taxAccount) {
                        econ.depositPlayer(this.taxAccountName, deduction);
                    }
                    this.sendMessage(sender, "messages.offline_moderate", placeholders, log);
                } else {
                    this.sendMessage(sender, "messages.offline_active", placeholders, false);
                }
            } else {
                deduction = Math.min(balance, balance * deductionRate);
                placeholders.put("deduction", String.format("%.2f", deduction));
                econ.withdrawPlayer(player, deduction);
                if (this.taxAccount) {
                    econ.depositPlayer(this.taxAccountName, deduction);
                }
                this.sendMessage(sender, "messages.deduction_made", placeholders, log);
            }
        } else {
            this.sendMessage(sender, "messages.zero_balance", placeholders, log);
        }
        double newBalance = econ.getBalance(player);
        double deduction = oldBalance - newBalance;
        this.saveRecord(player, oldBalance, newBalance, deduction, isCheckAll, operationId);
    }

    private void sendMessage(CommandSender sender, String path, Map<String, String> placeholders, boolean isLog) {
        String message = this.getFormattedMessage(path, placeholders);
        if (sender != null) {
            for (String str : message.split("\n")) {
                sender.sendMessage(str);
            }
        }
        if (isLog) {
            for (String str : message.split("\n")) {
                this.fileLogger.info(str);
            }
        }
    }

    private long calculateNextDelay() {
        Calendar now = Calendar.getInstance();
        switch (this.scheduleType) {
            case "daily": {
                return this.calculateDelayForDaily(now);
            }
            case "weekly": {
                return this.calculateDelayForWeekly(now);
            }
            case "monthly": {
                return this.calculateDelayForMonthly(now);
            }
        }
        return this.calculateDelayForDaily(now);
    }

    private long calculateDelayForDaily(Calendar now) {
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        return this.calculateDelayForDaily(now, hourOfDay, minute);
    }

    private long calculateDelayForDaily(Calendar now, int hours, int minutes) {
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.set(11, hours);
        nextCheck.set(12, minutes);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        if (nextCheck.before(now)) {
            nextCheck.add(5, 1);
        }
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForWeekly(Calendar now) {
        long delayForToday;
        int today = now.get(7);
        if (this.scheduleDaysOfWeek.contains(today) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDaysOfWeek.stream().sorted().filter(dayOfWeek -> dayOfWeek > today).map(dayOfWeek -> dayOfWeek - today).findFirst().orElse(7 + this.scheduleDaysOfWeek.get(0) - today);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(7, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateDelayForMonthly(Calendar now) {
        long delayForToday;
        int dayOfMonth = now.get(5);
        if (this.scheduleDatesOfMonth.contains(dayOfMonth) && (delayForToday = this.calculateDelayForDaily(now)) > 0L) {
            return delayForToday;
        }
        int daysUntilNextCheck = this.scheduleDatesOfMonth.stream().filter(date -> date > dayOfMonth).map(date -> date - dayOfMonth).findFirst().orElse(this.scheduleDatesOfMonth.get(0) + now.getActualMaximum(5) - dayOfMonth);
        int hourOfDay = Integer.parseInt(this.checkTime.split(":")[0]);
        int minute = Integer.parseInt(this.checkTime.split(":")[1]);
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(5, daysUntilNextCheck);
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private void scheduleCheck(long delay) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> {
            this.checkAll(null);
            this.scheduleCheck(this.calculateNextDelay());
        }, delay);
    }

    public void checkPlayer(CommandSender sender, String playerName) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target.hasPlayedBefore()) {
            long currentTime = System.currentTimeMillis();
            int operationId = this.getNextOperationId(false);
            this.checkBalance(sender, currentTime, target, true, false, operationId);
        } else {
            sender.sendMessage(this.getFormattedMessage("messages.player_not_found", null));
        }
    }

    public void checkAll(final CommandSender sender) {
        final long currentTime = System.currentTimeMillis();
        final OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        int batchSize = 100;
        int delay = 10;
        final int operationId = this.getNextOperationId(true);
        class BatchRunnable
        implements Runnable {
            private int index = 0;

            BatchRunnable() {
            }

            @Override
            public void run() {
                int start = this.index;
                int end = Math.min(this.index + 100, players.length);
                for (int i = this.index; i < end; ++i) {
                    OfflinePlayer player = players[i];
                    EcoBalancer.this.checkBalance(null, currentTime, player, false, true, operationId);
                }
                this.index += 100;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("start", Integer.toString(start));
                placeholders.put("end", Integer.toString(end));
                placeholders.put("batch", Integer.toString(end - start));
                placeholders.put("total_players", Integer.toString(players.length));
                EcoBalancer.this.sendMessage(sender, "messages.players_processing", placeholders, true);
                if (this.index < players.length) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)EcoBalancer.this, (Runnable)this, 10L);
                } else {
                    EcoBalancer.this.calculateTotalDeduction(operationId);
                    Bukkit.getScheduler().runTask((Plugin)EcoBalancer.this, () -> EcoBalancer.this.sendMessage(sender, "messages.all_players_processed", null, true));
                }
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new BatchRunnable());
    }

    private void calculateTotalDeduction(int operationId) {
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT SUM(deduction) AS total_deduction FROM records WHERE operation_id = ?");){
            preparedStatement.setInt(1, operationId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    double totalDeduction = resultSet.getDouble("total_deduction");
                    this.getLogger().info("Operation " + operationId + " total deduction: " + totalDeduction);
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("\u65e0\u6cd5\u8ba1\u7b97\u603b\u6263\u9664\u91d1\u989d: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNextOperationId(boolean isCheckAll) {
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS operations (id INTEGER PRIMARY KEY AUTOINCREMENT, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, is_restored BOOLEAN NOT NULL DEFAULT 0)");
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO operations (timestamp, is_checkall, is_restored) VALUES (?, ?, ?)", 1);){
                preparedStatement.setLong(1, System.currentTimeMillis());
                preparedStatement.setBoolean(2, isCheckAll);
                preparedStatement.setBoolean(3, false);
                preparedStatement.executeUpdate();
                try (ResultSet generatedKeys = preparedStatement.getGeneratedKeys();){
                    if (!generatedKeys.next()) throw new SQLException("Creating operation failed, no ID obtained.");
                    int n = generatedKeys.getInt(1);
                    return n;
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("\u65e0\u6cd5\u83b7\u53d6\u4e0b\u4e00\u4e2a\u64cd\u4f5cID: " + e.getMessage());
            return -1;
        }
    }

    public void generateHistogram(CommandSender sender, int numBars, double low, double up) {
        sender.sendMessage(this.getFormattedMessage("messages.stats_hist_drawing", null));
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        ArrayList<Double> balances = new ArrayList<Double>();
        for (OfflinePlayer player : players) {
            double balance;
            if (!econ.hasAccount(player) || !((balance = econ.getBalance(player)) >= low) || !(balance <= up)) continue;
            balances.add(balance);
        }
        double min = balances.stream().min(Double::compareTo).orElse(0.0);
        double max = balances.stream().max(Double::compareTo).orElse(0.0);
        double range = max - min;
        double barWidth = range / (double)numBars;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("min", String.format("%.2f", min));
        placeholders.put("max", String.format("%.2f", max));
        sender.sendMessage(this.getFormattedMessage("messages.stats_min_max", placeholders));
        int[] histogram = new int[numBars];
        Iterator iterator = balances.iterator();
        while (iterator.hasNext()) {
            double balance = (Double)iterator.next();
            int barIndex = (int)((balance - min) / barWidth);
            if (barIndex == numBars) {
                // empty if block
            }
            int n = --barIndex;
            histogram[n] = histogram[n] + 1;
        }
        int maxBarLength = 100;
        int maxFrequency = Arrays.stream(histogram).max().orElse(0);
        sender.sendMessage(this.getFormattedMessage("messages.stats_hist_header", null));
        for (int i = 0; i < numBars; ++i) {
            double lowerBound = min + (double)i * barWidth;
            double upperBound = lowerBound + barWidth;
            int barLength = (int)((double)histogram[i] / (double)maxFrequency * (double)maxBarLength);
            String bar = "\u00a7a" + StringUtils.repeat((String)"\u258f", (int)barLength) + "\u00a7r";
            HashMap<String, String> intervalPlaceholders = new HashMap<String, String>();
            intervalPlaceholders.put("bar", bar);
            intervalPlaceholders.put("frequency", Integer.toString(histogram[i]));
            intervalPlaceholders.put("low", this.formatNumber(lowerBound));
            intervalPlaceholders.put("up", this.formatNumber(upperBound));
            TextComponent clickableBar = new TextComponent(bar);
            clickableBar.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/interval balance " + lowerBound + " " + upperBound));
            clickableBar.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.getFormattedMessage("messages.stats_check_interval", intervalPlaceholders)).create()));
            TextComponent message = this.getFormattedMessage("messages.stats_bar", intervalPlaceholders, new String[]{"bar"}, new TextComponent[]{clickableBar});
            sender.spigot().sendMessage((BaseComponent)message);
        }
        double mean = balances.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        double median = this.calculateMedian(balances);
        double standardDeviation = this.calculateStandardDeviation(balances, mean);
        HashMap<String, String> statsPlaceholders = new HashMap<String, String>();
        statsPlaceholders.put("mean", String.format("%.2f", mean));
        statsPlaceholders.put("median", String.format("%.2f", median));
        statsPlaceholders.put("sd", String.format("%.2f", standardDeviation));
        sender.sendMessage(this.getFormattedMessage("messages.stats_mean_median", statsPlaceholders));
        sender.sendMessage(this.getFormattedMessage("messages.stats_sd", statsPlaceholders));
    }

    private double calculateMedian(List<Double> values) {
        System.out.println("before sort");
        Collections.sort(values);
        System.out.println("after sort");
        int size = values.size();
        if (size == 0) {
            return 0.0;
        }
        if (size % 2 == 0) {
            return (values.get(size / 2 - 1) + values.get(size / 2)) / 2.0;
        }
        return values.get(size / 2);
    }

    private double calculateStandardDeviation(List<Double> values, double mean) {
        if (values.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (double value : values) {
            sum += Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(sum / (double)values.size());
    }

    private String formatNumber(double number) {
        if (number >= 1.0E9) {
            return String.format("%.1fb", number / 1.0E9);
        }
        if (number >= 1000000.0) {
            return String.format("%.1fm", number / 1000000.0);
        }
        if (number >= 1000.0) {
            return String.format("%.1fk", number / 1000.0);
        }
        return String.format("%.1f", number);
    }

    public double calculatePercentile(double balance, double low, double high) {
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        ArrayList<Double> balances = new ArrayList<Double>();
        for (OfflinePlayer player : players) {
            double playerBalance;
            if (!econ.hasAccount(player) || !((playerBalance = econ.getBalance(player)) >= low) || !(playerBalance <= high)) continue;
            balances.add(playerBalance);
        }
        int totalPlayers = balances.size();
        int playersBelow = (int)balances.stream().filter(b -> b < balance).count();
        return (double)playersBelow / (double)totalPlayers * 100.0;
    }

    private void saveRecord(OfflinePlayer player, double oldBalance, double newBalance, double deduction, boolean isCheckAll, int operationId) {
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());){
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS records (id INTEGER PRIMARY KEY AUTOINCREMENT, player_name TEXT NOT NULL, player TEXT NOT NULL, old_balance REAL NOT NULL, new_balance REAL NOT NULL, deduction REAL NOT NULL, timestamp INTEGER NOT NULL, is_checkall BOOLEAN NOT NULL, operation_id INTEGER NOT NULL)");
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO records (operation_id, player_name, player, old_balance, new_balance, deduction, timestamp, is_checkall) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                preparedStatement.setInt(1, operationId);
                preparedStatement.setString(2, player.getName());
                preparedStatement.setString(3, player.getUniqueId().toString());
                preparedStatement.setDouble(4, oldBalance);
                preparedStatement.setDouble(5, newBalance);
                preparedStatement.setDouble(6, deduction);
                preparedStatement.setLong(7, System.currentTimeMillis());
                preparedStatement.setBoolean(8, isCheckAll);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.getLogger().severe(this.getFormattedMessage("messages.sql_save_error", null) + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanupRecords() {
        long expirationTime = System.currentTimeMillis() - (long)(this.recordRetentionDays * 24 * 60 * 60 * 1000);
        File dataFolder = this.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
             PreparedStatement selectExpiredOperations = connection.prepareStatement("SELECT id FROM operations WHERE timestamp < ?");){
            selectExpiredOperations.setLong(1, expirationTime);
            try (ResultSet expiredOperations = selectExpiredOperations.executeQuery();){
                while (expiredOperations.next()) {
                    int operationId = expiredOperations.getInt("id");
                    try (PreparedStatement deleteRecords = connection.prepareStatement("DELETE FROM records WHERE operation_id = ?");){
                        deleteRecords.setInt(1, operationId);
                        deleteRecords.executeUpdate();
                    }
                    PreparedStatement deleteOperation = connection.prepareStatement("DELETE FROM operations WHERE id = ?");
                    try {
                        deleteOperation.setInt(1, operationId);
                        deleteOperation.executeUpdate();
                    }
                    finally {
                        if (deleteOperation == null) continue;
                        deleteOperation.close();
                    }
                }
                return;
            }
        }
        catch (SQLException e) {
            this.getLogger().severe(this.getFormattedMessage("messages.sql_clean_error", null) + e.getMessage());
        }
    }
}

