/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;

public class CheckRecordsCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public CheckRecordsCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int pageNumber = 1;
        int pageSize = 10;
        if (args.length > 0) {
            try {
                pageNumber = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
                return true;
            }
        }
        File dataFolder = this.plugin.getDataFolder();
        File databaseFile = new File(dataFolder, "records.db");
        try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());){
            ResultSet resultSet;
            int offset = (pageNumber - 1) * pageSize;
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT o.id, o.timestamp, o.is_restored, r.is_checkall, SUM(r.deduction) AS total_deduction FROM operations o JOIN records r ON o.id = r.operation_id GROUP BY o.id ORDER BY o.timestamp DESC LIMIT ? OFFSET ?");){
                preparedStatement.setInt(1, pageSize);
                preparedStatement.setInt(2, offset);
                resultSet = preparedStatement.executeQuery();
                try {
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.records_header", null));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    while (resultSet.next()) {
                        int id = resultSet.getInt("id");
                        long timestamp = resultSet.getLong("timestamp");
                        boolean isCheckAll = resultSet.getBoolean("is_checkall");
                        double totalDeduction = resultSet.getDouble("total_deduction");
                        boolean isRestored = resultSet.getBoolean("is_restored");
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("time", dateFormat.format(new Date(timestamp)));
                        placeholders.put("type", isCheckAll ? "A" : "P");
                        placeholders.put("deduction_amount", String.format("%.2f", totalDeduction));
                        placeholders.put("operation_id", String.valueOf(id));
                        placeholders.put("restored", isRestored ? "x" : " ");
                        TextComponent operationIdComponent = new TextComponent(String.valueOf(id));
                        operationIdComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/checkrecord " + id));
                        operationIdComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.plugin.getFormattedMessage("messages.records_click", null)).create()));
                        TextComponent messageFormat = this.plugin.getFormattedMessage("messages.records_operation", placeholders, new String[]{"operation_id"}, new TextComponent[]{operationIdComponent});
                        sender.spigot().sendMessage((BaseComponent)messageFormat);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            try (Statement statement = connection.createStatement();){
                resultSet = statement.executeQuery("SELECT COUNT(*) AS total FROM (SELECT o.id FROM operations o JOIN records r ON o.id = r.operation_id GROUP BY o.id)");
                try {
                    if (resultSet.next()) {
                        int total = resultSet.getInt("total");
                        int totalPages = (int)Math.ceil((double)total / (double)pageSize);
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        placeholders.put("page", String.valueOf(pageNumber));
                        placeholders.put("total", String.valueOf(totalPages));
                        TextComponent previouwPage = new TextComponent();
                        TextComponent nextPage = new TextComponent();
                        if (pageNumber > 1) {
                            previouwPage.setText(this.plugin.getFormattedMessage("messages.prev_page", null));
                            previouwPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/checkrecords " + (pageNumber - 1)));
                        } else {
                            previouwPage.setText(this.plugin.getFormattedMessage("messages.no_prev_page", null));
                        }
                        if (pageNumber < totalPages) {
                            nextPage.setText(this.plugin.getFormattedMessage("messages.next_page", null));
                            nextPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/checkrecords " + (pageNumber + 1)));
                        } else {
                            nextPage.setText(this.plugin.getFormattedMessage("messages.no_next_page", null));
                        }
                        placeholders.put("prev", previouwPage.toPlainText());
                        placeholders.put("next", nextPage.toPlainText());
                        TextComponent message = this.plugin.getFormattedMessage("messages.records_page", placeholders, new String[]{"prev", "next"}, new TextComponent[]{previouwPage, nextPage});
                        sender.spigot().sendMessage((BaseComponent)message);
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.records_footer", null));
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("error", e.getMessage());
            sender.sendMessage(this.plugin.getFormattedMessage("messages.records_error", placeholders));
        }
        return true;
    }
}

