/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;

public class DescripStatsCommand
implements CommandExecutor {
    EcoBalancer plugin;

    public DescripStatsCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        int numBars;
        if (args.length < 1 || args.length > 3) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.stats_usage", null));
            sender.sendMessage(this.plugin.getFormattedMessage("messages.stats_limits", null));
            return false;
        }
        double low = Double.NEGATIVE_INFINITY;
        double up = Double.POSITIVE_INFINITY;
        try {
            numBars = Integer.parseInt(args[0]);
            if (numBars < 1) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.stats_invalid_number_of_bars", null));
                return false;
            }
            if (args.length >= 2) {
                double d = low = args[1].equals("_") ? Double.NEGATIVE_INFINITY : Double.parseDouble(args[1]);
            }
            if (args.length == 3) {
                up = args[2].equals("_") ? Double.POSITIVE_INFINITY : Double.parseDouble(args[2]);
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.stats_invalid_args", null));
            return false;
        }
        this.plugin.generateHistogram(sender, numBars, low, up);
        return true;
    }
}

