/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;

public class IntervalCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public IntervalCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int page;
        double up;
        double low;
        String sortBy;
        block25: {
            sortBy = "alphabet";
            low = Double.NEGATIVE_INFINITY;
            up = Double.POSITIVE_INFINITY;
            page = 1;
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("alphabet") || args[0].equalsIgnoreCase("balance")) {
                    sortBy = args[0].toLowerCase();
                    if (args.length > 1) {
                        try {
                            double d = low = args[1].equals("_") ? Double.NEGATIVE_INFINITY : Double.parseDouble(args[1]);
                            if (args.length <= 2) break block25;
                            try {
                                double d2 = up = args[2].equals("_") ? Double.POSITIVE_INFINITY : Double.parseDouble(args[2]);
                                if (args.length <= 3) break block25;
                                try {
                                    page = Integer.parseInt(args[3]);
                                }
                                catch (NumberFormatException e) {
                                    sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
                                    return true;
                                }
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_invalid_up", null));
                                return true;
                            }
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_invalid_low", null));
                            return true;
                        }
                    }
                } else {
                    try {
                        double d = low = args[0].equals("_") ? Double.NEGATIVE_INFINITY : Double.parseDouble(args[0]);
                        if (args.length <= 1) break block25;
                        try {
                            double d3 = up = args[1].equals("_") ? Double.POSITIVE_INFINITY : Double.parseDouble(args[1]);
                            if (args.length <= 2) break block25;
                            try {
                                page = Integer.parseInt(args[2]);
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
                                return true;
                            }
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_invalid_up", null));
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_invalid_low", null));
                        return true;
                    }
                }
            }
        }
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        ArrayList<OfflinePlayer> matchedPlayers = new ArrayList<OfflinePlayer>();
        sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_collecting", null));
        for (OfflinePlayer player : players) {
            IntervalCommand intervalCommand = this;
            if (!intervalCommand.plugin.getEconomy().hasAccount(player)) continue;
            IntervalCommand intervalCommand2 = this;
            double balance = intervalCommand2.plugin.getEconomy().getBalance(player);
            if (!(balance >= low) || !(balance <= up)) continue;
            matchedPlayers.add(player);
        }
        sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_sorting", null));
        if (sortBy.equals("balance")) {
            matchedPlayers.sort((p1, p2) -> {
                IntervalCommand intervalCommand = this;
                IntervalCommand intervalCommand2 = this;
                return Double.compare(intervalCommand.plugin.getEconomy().getBalance(p2), intervalCommand2.plugin.getEconomy().getBalance(p1));
            });
        } else {
            matchedPlayers.sort(Comparator.comparing(OfflinePlayer::getName));
        }
        int pageSize = 10;
        int totalPages = (matchedPlayers.size() + pageSize - 1) / pageSize;
        if (page < 1 || page > totalPages) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
            return true;
        }
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, matchedPlayers.size());
        HashMap<String, String> headerPlaceholders = new HashMap<String, String>();
        headerPlaceholders.put("low", String.format("%.2f", low));
        headerPlaceholders.put("up", String.format("%.2f", up));
        sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_header", headerPlaceholders));
        for (int i = start; i < end; ++i) {
            OfflinePlayer player = (OfflinePlayer)matchedPlayers.get(i);
            IntervalCommand intervalCommand = this;
            double balance = intervalCommand.plugin.getEconomy().getBalance(player);
            long lastPlayed = player.getLastPlayed();
            long currentTime = System.currentTimeMillis();
            long daysOffline = (currentTime - lastPlayed) / 86400000L;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", player.getName());
            placeholders.put("balance", String.format("%.2f", balance));
            placeholders.put("days_offline", String.valueOf(daysOffline));
            sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_player", placeholders));
        }
        HashMap<String, String> footerPlaceholders = new HashMap<String, String>();
        footerPlaceholders.put("page", String.valueOf(page));
        footerPlaceholders.put("total", String.valueOf(totalPages));
        TextComponent previouwPage = new TextComponent();
        TextComponent nextPage = new TextComponent();
        if (page > 1) {
            previouwPage.setText(this.plugin.getFormattedMessage("messages.prev_page", null));
            previouwPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/interval " + sortBy + " " + low + " " + up + " " + (page - 1)));
        } else {
            previouwPage.setText(this.plugin.getFormattedMessage("messages.no_prev_page", null));
        }
        if (page < totalPages) {
            nextPage.setText(this.plugin.getFormattedMessage("messages.next_page", null));
            nextPage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/interval " + sortBy + " " + low + " " + up + " " + (page + 1)));
        } else {
            nextPage.setText(this.plugin.getFormattedMessage("messages.no_next_page", null));
        }
        footerPlaceholders.put("prev", previouwPage.toPlainText());
        footerPlaceholders.put("next", nextPage.toPlainText());
        TextComponent message = this.plugin.getFormattedMessage("messages.interval_page", footerPlaceholders, new String[]{"prev", "next"}, new TextComponent[]{previouwPage, nextPage});
        sender.spigot().sendMessage((BaseComponent)message);
        sender.sendMessage(this.plugin.getFormattedMessage("messages.interval_footer", null));
        return true;
    }

    private boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int parseIntOrDefault(String value, int defaultValue, CommandSender sender) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.invalid_page", null));
            return defaultValue;
        }
    }
}

