/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;

public class PercentileCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public PercentileCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double balance;
        if (args.length < 1 || args.length > 3) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.perc_usage", null));
            sender.sendMessage(this.plugin.getFormattedMessage("messages.perc_limits", null));
            return false;
        }
        double low = Double.NEGATIVE_INFINITY;
        double up = Double.POSITIVE_INFINITY;
        try {
            balance = Double.parseDouble(args[0]);
            if (args.length >= 2) {
                double d = low = args[1].equals("_") ? Double.NEGATIVE_INFINITY : Double.parseDouble(args[1]);
            }
            if (args.length == 3) {
                up = args[2].equals("_") ? Double.POSITIVE_INFINITY : Double.parseDouble(args[2]);
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getFormattedMessage("messages.perc_invalid_args", null));
            return false;
        }
        double percentile = this.plugin.calculatePercentile(balance, low, up);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("percentile", String.format("%.2f", percentile));
        placeholders.put("low", String.format("%.2f", low));
        placeholders.put("up", String.format("%.2f", up));
        sender.sendMessage(this.plugin.getFormattedMessage("messages.perc_success", placeholders));
        return true;
    }
}

