/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer.commands;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.cubexmc.ecobalancer.EcoBalancer;

public class RestoreCommand
implements CommandExecutor {
    private final EcoBalancer plugin;

    public RestoreCommand(EcoBalancer plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block61: {
            int operationId;
            if (args.length != 1) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_usage", null));
                return true;
            }
            try {
                operationId = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_invalid_id", null));
                return true;
            }
            File dataFolder = this.plugin.getDataFolder();
            File databaseFile = new File(dataFolder, "records.db");
            try (Connection connection = DriverManager.getConnection("jdbc:sqlite:" + databaseFile.getAbsolutePath());
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM operations WHERE id = ?");){
                preparedStatement.setInt(1, operationId);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        boolean isCheckAll = resultSet.getBoolean("is_checkall");
                        if (isCheckAll) {
                            HashMap<String, String> placeholders = new HashMap<String, String>();
                            placeholders.put("operation_id", String.valueOf(operationId));
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.restoring_all", placeholders));
                            try (PreparedStatement selectStatement = connection.prepareStatement("SELECT * FROM records WHERE operation_id = ? AND deduction != 0.0");){
                                selectStatement.setInt(1, operationId);
                                try (ResultSet allRecords = selectStatement.executeQuery();){
                                    while (allRecords.next()) {
                                        String playerUUID = allRecords.getString("player");
                                        double deduction = allRecords.getDouble("deduction");
                                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
                                        RestoreCommand restoreCommand = this;
                                        restoreCommand.plugin.getEconomy().depositPlayer(offlinePlayer, deduction);
                                    }
                                }
                            }
                            sender.sendMessage(this.plugin.getFormattedMessage("messages.restored_all", placeholders));
                        } else {
                            try (PreparedStatement selectStatement = connection.prepareStatement("SELECT * FROM records WHERE operation_id = ?");){
                                selectStatement.setInt(1, operationId);
                                try (ResultSet record = selectStatement.executeQuery();){
                                    if (record.next()) {
                                        String playerUUID = record.getString("player");
                                        double deduction = record.getDouble("deduction");
                                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
                                        RestoreCommand restoreCommand = this;
                                        restoreCommand.plugin.getEconomy().depositPlayer(offlinePlayer, deduction);
                                        HashMap<String, String> placeholders = new HashMap<String, String>();
                                        placeholders.put("operation_id", String.valueOf(operationId));
                                        placeholders.put("player", offlinePlayer.getName());
                                        sender.sendMessage(this.plugin.getFormattedMessage("messages.restored_player", placeholders));
                                    } else {
                                        sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_not_found", null));
                                    }
                                }
                            }
                        }
                        try (PreparedStatement updateStatement = connection.prepareStatement("UPDATE operations SET is_restored = 1 WHERE id = ?");){
                            updateStatement.setInt(1, operationId);
                            updateStatement.executeUpdate();
                            break block61;
                        }
                    }
                    sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_operation_not_found", null));
                }
            }
            catch (SQLException e) {
                HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                sender.sendMessage(this.plugin.getFormattedMessage("messages.restore_error", errorPlaceholders));
            }
        }
        return true;
    }
}

