/*
 * Decompiled with CFR 0.152.
 */
package org.cubexmc.ecobalancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.cubexmc.ecobalancer.commands.CheckAllCommand;
import org.cubexmc.ecobalancer.commands.CheckPlayerCommand;
import org.cubexmc.ecobalancer.commands.UtilCommand;
import org.cubexmc.ecobalancer.metrics.Metrics;

public final class EcoBalancer
extends JavaPlugin {
    private static Economy econ = null;
    private static Permission perms = null;
    private static Chat chat = null;
    private boolean deductBasedOnTime;
    private int inactiveDaysToDeduct;
    private TreeMap<Integer, Double> taxBrackets = new TreeMap();
    private int inactiveDaysToClear;
    private Logger fileLogger = Logger.getLogger("EcoBalancerFileLogger");
    private FileHandler fileHandler;
    private String scheduleType;
    private List<Integer> scheduleDaysOfWeek;
    private List<Integer> scheduleDatesOfMonth;
    private FileConfiguration langConfig;

    public void onEnable() {
        File existingLogFile;
        File lockFile;
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.loadConfiguration();
        File logDir = new File(this.getDataFolder() + File.separator + "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        if ((lockFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log.lck")).exists()) {
            lockFile.delete();
        }
        if ((existingLogFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(existingLogFile);
        }
        try {
            this.fileHandler = new FileHandler(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log", true);
            this.fileHandler.setFormatter(new SimpleFormatter());
            this.fileLogger.addHandler(this.fileHandler);
            this.fileLogger.setUseParentHandlers(false);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not setup file logger for EcoBalancer");
            e.printStackTrace();
        }
        int pluginId = 20269;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
        this.getCommand("ecobal").setExecutor((CommandExecutor)new UtilCommand(this));
        this.getCommand("checkall").setExecutor((CommandExecutor)new CheckAllCommand(this));
        this.getCommand("checkplayer").setExecutor((CommandExecutor)new CheckPlayerCommand(this));
        this.getLogger().info("EcoBalancer enabled!");
    }

    public void loadConfiguration() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.loadLangFile();
        this.scheduleType = this.getConfig().getString("schedule.type", "daily");
        this.scheduleDaysOfWeek = this.getConfig().getIntegerList("schedule.days-of-week");
        this.scheduleDatesOfMonth = this.getConfig().getIntegerList("schedule.dates-of-month");
        String checkTime = this.getConfig().getString("check-time", "01:00");
        int hourOfDay = Integer.parseInt(checkTime.split(":")[0]);
        int minute = Integer.parseInt(checkTime.split(":")[1]);
        switch (this.scheduleType.toLowerCase()) {
            case "weekly": {
                this.scheduleWeeklyChecks();
                break;
            }
            case "monthly": {
                this.scheduleMonthlyChecks();
                break;
            }
            default: {
                this.scheduleDailyChecks(hourOfDay, minute);
            }
        }
        this.deductBasedOnTime = this.getConfig().getBoolean("deduct-based-on-time", false);
        this.inactiveDaysToDeduct = this.getConfig().getInt("inactive-days-to-deduct", 50);
        this.inactiveDaysToClear = this.getConfig().getInt("inactive-days-to-clear", 500);
        List rawTaxBrackets = this.getConfig().getMapList("tax-brackets");
        for (Map bracket : rawTaxBrackets) {
            Integer threshold = bracket.get("threshold") == null ? Integer.MAX_VALUE : (Integer)bracket.get("threshold");
            Double rate = (Double)bracket.get("rate");
            this.taxBrackets.put(threshold, rate);
        }
    }

    private void loadLangFile() {
        File langFile = new File(this.getDataFolder(), "lang.yml");
        if (!langFile.exists()) {
            this.saveResource("lang.yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getFormattedMessage(String path, Map<String, String> placeholders) {
        String message = this.langConfig.getString(path, "Message not found!");
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void onDisable() {
        File logFile;
        if (this.fileHandler != null) {
            this.fileHandler.flush();
            this.fileLogger.removeHandler(this.fileHandler);
            this.fileHandler.close();
        }
        if ((logFile = new File(this.getDataFolder() + File.separator + "logs" + File.separator + "latest.log")).exists()) {
            this.compressExistingLogFile(logFile);
        }
        this.getLogger().info("EcoBalancer disabled.");
    }

    private void compressExistingLogFile(File logFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmm");
        String timestamp = dateFormat.format(new Date(logFile.lastModified()));
        File renamedLogFile = new File(logFile.getParent(), timestamp + ".log");
        if (!logFile.renameTo(renamedLogFile)) {
            this.getLogger().severe("Could not rename the log file.");
            return;
        }
        File compressedFile = new File(renamedLogFile.getParent(), renamedLogFile.getName() + ".gz");
        try (GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(compressedFile));){
            Files.copy(renamedLogFile.toPath(), gzos);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not compress the log file: " + e.getMessage());
        }
        if (!renamedLogFile.delete()) {
            this.getLogger().severe("Could not delete the original log file after compression.");
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().info("EcoBalancer disabled [plugin=null]");
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().info("EcoBalancer disabled [rsp=null]");
            return false;
        }
        econ = (Economy)rsp.getProvider();
        this.getLogger().info("" + (econ != null));
        return econ != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public void checkBalance(CommandSender sender, long currentTime, OfflinePlayer player, boolean log) {
        long lastPlayed = player.getLastPlayed();
        long daysOffline = (currentTime - lastPlayed) / 86400000L;
        double balance = econ.hasAccount(player) ? econ.getBalance(player) : 0.0;
        Double deductionRate = 0.0;
        Map.Entry<Integer, Double> entry = this.taxBrackets.higherEntry((int)balance);
        if (entry != null) {
            deductionRate = entry.getValue();
        }
        if (deductionRate == null) {
            deductionRate = 0.0;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("player", player.getName());
        placeholders.put("balance", String.format("%.2f", balance));
        placeholders.put("days_offline", String.valueOf(daysOffline));
        if (balance < 0.0) {
            econ.depositPlayer(player, -1.0 * balance);
            placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
            if (sender != null) {
                sender.sendMessage(this.getFormattedMessage("messages.set_balance.reason", placeholders));
                sender.sendMessage(this.getFormattedMessage("messages.set_balance.balance_set", placeholders));
            }
            if (log) {
                this.fileLogger.info(this.getFormattedMessage("logs.negative_balance", placeholders));
            }
        } else if (deductionRate > 0.0) {
            if (this.deductBasedOnTime) {
                if (daysOffline > (long)this.inactiveDaysToClear) {
                    econ.withdrawPlayer(player, balance);
                    placeholders.put("new_balance", String.format("%.2f", econ.getBalance(player)));
                    if (sender != null) {
                        sender.sendMessage(this.getFormattedMessage("messages.offline_extreme.reason", placeholders));
                        sender.sendMessage(this.getFormattedMessage("messages.offline_extreme.balance_set", placeholders));
                    }
                    if (log) {
                        this.fileLogger.info(this.getFormattedMessage("logs.offline_extreme", placeholders));
                    }
                } else if (daysOffline > (long)this.inactiveDaysToDeduct) {
                    double deduction = Math.min(balance, balance * deductionRate);
                    placeholders.put("deduction", String.format("%.2f", deduction));
                    econ.withdrawPlayer(player, deduction);
                    if (sender != null) {
                        sender.sendMessage(this.getFormattedMessage("messages.offline_moderate.reason", placeholders));
                        sender.sendMessage(this.getFormattedMessage("messages.offline_moderate.deduction_made", placeholders));
                    }
                    if (log) {
                        this.fileLogger.info(this.getFormattedMessage("logs.offline_moderate", placeholders));
                    }
                } else if (sender != null) {
                    sender.sendMessage(this.getFormattedMessage("messages.offline_active", placeholders));
                }
            } else {
                double deduction = Math.min(balance, balance * deductionRate);
                placeholders.put("deduction", String.format("%.2f", deduction));
                econ.withdrawPlayer(player, deduction);
                if (sender != null) {
                    sender.sendMessage(this.getFormattedMessage("messages.deduction_made", placeholders));
                }
                if (log) {
                    this.fileLogger.info(this.getFormattedMessage("logs.deduction_made", placeholders));
                }
            }
        } else {
            if (sender != null) {
                sender.sendMessage(this.getFormattedMessage("messages.zero_balance", placeholders));
            }
            if (log) {
                this.fileLogger.info(this.getFormattedMessage("logs.zero_balance", placeholders));
            }
        }
    }

    private long calculateInitialDailyDelay(int hourOfDay, int minute) {
        Calendar now = Calendar.getInstance();
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.set(11, hourOfDay);
        nextCheck.set(12, minute);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        if (nextCheck.before(now)) {
            nextCheck.add(5, 1);
        }
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateInitialWeeklyDelay() {
        Calendar now = Calendar.getInstance();
        int today = now.get(7);
        int daysUntilNextCheck = this.scheduleDaysOfWeek.stream().sorted().filter(dayOfWeek -> dayOfWeek >= today).findFirst().orElse(this.scheduleDaysOfWeek.get(0)) - today;
        if (daysUntilNextCheck < 0) {
            daysUntilNextCheck += 7;
        }
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(7, daysUntilNextCheck);
        nextCheck.set(11, 0);
        nextCheck.set(12, 0);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private long calculateInitialMonthlyDelay() {
        Calendar now = Calendar.getInstance();
        int dayOfMonth = now.get(5);
        int daysUntilNextCheck = this.scheduleDatesOfMonth.stream().filter(date -> date >= dayOfMonth).findFirst().orElse(this.scheduleDatesOfMonth.get(0)) - dayOfMonth;
        if (daysUntilNextCheck < 0) {
            daysUntilNextCheck += now.getActualMaximum(5);
        }
        Calendar nextCheck = (Calendar)now.clone();
        nextCheck.add(5, daysUntilNextCheck);
        nextCheck.set(11, 0);
        nextCheck.set(12, 0);
        nextCheck.set(13, 0);
        nextCheck.set(14, 0);
        return (nextCheck.getTimeInMillis() - now.getTimeInMillis()) / 50L;
    }

    private void scheduleDailyChecks(int hourOfDay, int minute) {
        long initialDelay = this.calculateInitialDailyDelay(hourOfDay, minute);
        long ticksPerDay = 1728000L;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> this.checkAll(null), initialDelay, ticksPerDay);
    }

    private void scheduleWeeklyChecks() {
        long ticksPerWeek = 12096000L;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            Calendar now = Calendar.getInstance();
            int today = now.get(7);
            if (this.scheduleDaysOfWeek.contains(today)) {
                this.checkAll(null);
            }
        }, this.calculateInitialWeeklyDelay(), ticksPerWeek);
    }

    private void scheduleMonthlyChecks() {
        long ticksPerMonth = 51840000L;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            Calendar now = Calendar.getInstance();
            int today = now.get(5);
            if (this.scheduleDatesOfMonth.contains(today)) {
                this.checkAll(null);
            }
        }, this.calculateInitialMonthlyDelay(), ticksPerMonth);
    }

    public void checkAll(final CommandSender sender) {
        final long currentTime = System.currentTimeMillis();
        final OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        int batchSize = 100;
        int delay = 10;
        class BatchRunnable
        implements Runnable {
            private int index = 0;

            BatchRunnable() {
            }

            @Override
            public void run() {
                int start = this.index;
                int end = Math.min(this.index + 100, players.length);
                for (int i = this.index; i < end; ++i) {
                    OfflinePlayer player = players[i];
                    EcoBalancer.this.checkBalance(null, currentTime, player, false);
                }
                this.index += 100;
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("start", Integer.toString(start));
                placeholders.put("end", Integer.toString(end));
                placeholders.put("batch", Integer.toString(end - start));
                placeholders.put("total_players", Integer.toString(players.length));
                if (sender != null) {
                    Bukkit.getScheduler().runTask((Plugin)EcoBalancer.this, () -> sender.sendMessage(EcoBalancer.this.getFormattedMessage("messages.players_processing", placeholders)));
                } else {
                    EcoBalancer.this.getLogger().info(EcoBalancer.this.getFormattedMessage("logs.players_processed", placeholders));
                }
                if (this.index < players.length) {
                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)EcoBalancer.this, (Runnable)this, 10L);
                } else {
                    Bukkit.getScheduler().runTask((Plugin)EcoBalancer.this, () -> {
                        if (sender != null) {
                            sender.sendMessage(EcoBalancer.this.getFormattedMessage("messages.all_players_processed", null));
                        } else {
                            EcoBalancer.this.getLogger().info(EcoBalancer.this.getFormattedMessage("logs.all_players_processed", null));
                            EcoBalancer.this.fileLogger.info(EcoBalancer.this.getFormattedMessage("logs.all_players_processed", null));
                        }
                    });
                }
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new BatchRunnable());
    }
}

