/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.data;

import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ithundxr.createnumismatics.base.data.neoforge.NumismaticsTagGenImpl;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class NumismaticsTagGen {
    private static final Map<TagKey<Block>, List<ResourceLocation>> OPTIONAL_TAGS = new HashMap<TagKey<Block>, List<ResourceLocation>>();

    @SafeVarargs
    public static void addOptionalTag(ResourceLocation id, TagKey<Block> ... tags) {
        for (TagKey<Block> tag : tags) {
            OPTIONAL_TAGS.computeIfAbsent(tag, e -> new ArrayList()).add(id);
        }
    }

    public static void generateBlockTags(RegistrateTagsProvider<Block> tags) {
        for (TagKey<Block> tag : OPTIONAL_TAGS.keySet()) {
            TagsProvider.TagAppender<Block> appender = NumismaticsTagGen.tagAppender(tags, tag);
            for (ResourceLocation loc : OPTIONAL_TAGS.get(tag)) {
                appender.addOptional(loc);
            }
        }
    }

    public static void generateItemTags(RegistrateItemTagsProvider tags) {
        for (NumismaticsTags.AllItemTags tag : NumismaticsTags.AllItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            NumismaticsTagGen.tagAppender(tags, tag);
        }
    }

    public static TagsProvider.TagAppender<Item> tagAppender(RegistrateItemTagsProvider prov, NumismaticsTags.AllItemTags tag) {
        return NumismaticsTagGen.tagAppender(prov, tag.tag);
    }

    public static TagsProvider.TagAppender<Block> tagAppender(RegistrateTagsProvider<Block> prov, NumismaticsTags.AllBlockTags tag) {
        return NumismaticsTagGen.tagAppender(prov, tag.tag);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> TagsProvider.TagAppender<T> tagAppender(RegistrateTagsProvider<T> prov, TagKey<T> tag) {
        void var1_1;
        return NumismaticsTagGenImpl.tagAppender(prov, var1_1);
    }
}

