/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.trust_list;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.IDCardItem;
import dev.ithundxr.createnumismatics.content.bank.IDCardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TrustListMenu
extends MenuBase<TrustListHolder> {
    public static final int CARD_SLOTS = 27;
    public static final int PLAYER_INV_START_INDEX = 27;
    public static final int PLAYER_HOTBAR_END_INDEX = 36;
    public static final int PLAYER_INV_END_INDEX = 63;
    ItemStack renderedItem;

    public TrustListMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    protected TrustListMenu(MenuType<?> type, int id, Inventory inv, TrustListHolder contentHolder, ItemStack renderedItem) {
        super(type, id, inv, (Object)contentHolder);
        this.renderedItem = renderedItem;
    }

    public static MenuProvider provider(final TrustListHolder contentHolder, final ItemStack renderedItem) {
        return new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"gui.numismatics.trust_list");
            }

            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return new TrustListMenu((MenuType)NumismaticsMenuTypes.TRUST_LIST.get(), i, inventory, contentHolder, renderedItem);
            }
        };
    }

    protected TrustListHolder createOnClient(RegistryFriendlyByteBuf extraData) {
        SyncedBlockEntity syncedBE;
        this.renderedItem = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)extraData);
        ClientLevel world = Minecraft.getInstance().level;
        BlockEntity blockEntity = world.getBlockEntity(extraData.readBlockPos());
        if (blockEntity instanceof SyncedBlockEntity && (syncedBE = (SyncedBlockEntity)blockEntity) instanceof TrustListHolder) {
            TrustListHolder trustListHolder = (TrustListHolder)syncedBE;
            syncedBE.readClient(extraData.readNbt(), (HolderLookup.Provider)extraData.registryAccess());
            return trustListHolder;
        }
        return null;
    }

    protected void initAndReadInventory(TrustListHolder contentHolder) {
    }

    protected void addSlots() {
        int x = 16;
        int y = 21;
        for (int i = 0; i < 27; ++i) {
            if (i % 9 == 0 && i > 0) {
                x = 16;
                y += 18;
            }
            this.addSlot(new IDCardSlot.BoundIDCardSlot(((TrustListHolder)this.contentHolder).getTrustListBackingContainer(), i, x, y));
            x += 18;
        }
        this.addPlayerSlots(40, 130);
    }

    protected void saveData(TrustListHolder contentHolder) {
    }

    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot clickedSlot = (Slot)this.slots.get(index);
        if (!clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = CoinItem.clearDisplayedCount(clickedSlot.getItem());
        ItemStack returnStack = slotStack.copy();
        if (index < 27) {
            int count = slotStack.getCount();
            if (!this.moveItemStackTo(slotStack, 27, 63, false)) {
                return ItemStack.EMPTY;
            }
            returnStack = ItemStack.EMPTY;
            clickedSlot.remove(count);
        } else {
            if (slotStack.getItem() instanceof IDCardItem && IDCardItem.isBound(slotStack) && !this.moveItemStackTo(slotStack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= 27 && index < 36 && !this.moveItemStackTo(slotStack, 36, 63, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= 36 && index < 63 && !this.moveItemStackTo(slotStack, 27, 36, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (slotStack.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        return returnStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable() && startIndex >= 27) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (!itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.getCount() + stack.getCount();
                    if (j <= stack.getMaxStackSize()) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        bl = true;
                    } else if (itemStack.getCount() < stack.getMaxStackSize()) {
                        stack.shrink(stack.getMaxStackSize() - itemStack.getCount());
                        itemStack.setCount(stack.getMaxStackSize());
                        slot.setChanged();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.slots.get(i);
                itemStack = slot.getItem();
                if (itemStack.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.setByPlayer(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.setByPlayer(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public static <BE extends SmartBlockEntity & Trusted> void openMenu(BE be, ServerPlayer player, ItemStack displayStack) {
        if (((Trusted)be).isTrusted((Player)player)) {
            Utils.openScreen(player, TrustListMenu.provider((TrustListHolder)be, displayStack), buf -> {
                ItemStack.STREAM_CODEC.encode(buf, (Object)displayStack);
                be.sendToMenu(buf);
            });
        }
    }

    public static enum TrustListSham implements INamedIconOptions
    {
        NONE;


        public AllIcons getIcon() {
            return AllIcons.I_VIEW_SCHEDULE;
        }

        public String getTranslationKey() {
            return "numismatics.trust_list.configure";
        }
    }
}

