/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import dev.ithundxr.createnumismatics.registry.NumismaticsDataComponents;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardItem
extends Item {
    public final DyeColor color;

    public CardItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static ItemStack clear(ItemStack itemStack) {
        itemStack.remove(NumismaticsDataComponents.CARD_ACCOUNT_ID);
        return itemStack;
    }

    public static ItemStack set(ItemStack itemStack, UUID id) {
        itemStack.set(NumismaticsDataComponents.CARD_ACCOUNT_ID, (Object)id);
        return itemStack;
    }

    @Nullable
    public static UUID get(ItemStack itemStack) {
        return (UUID)itemStack.get(NumismaticsDataComponents.CARD_ACCOUNT_ID);
    }

    public static boolean isBound(ItemStack itemStack) {
        return itemStack.has(NumismaticsDataComponents.CARD_ACCOUNT_ID);
    }

    @Nullable
    public static String getPlayerName(ItemStack itemStack) {
        if (!CardItem.isBound(itemStack)) {
            return null;
        }
        return UsernameUtils.INSTANCE.getName(CardItem.get(itemStack), null);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (CardItem.isBound(stack)) {
            String name = CardItem.getPlayerName(stack);
            if (name == null) {
                tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.card.tooltip.bound").withStyle(ChatFormatting.GREEN));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.card.tooltip.bound.to", (Object[])new Object[]{name}).withStyle(ChatFormatting.GREEN));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.card.tooltip.blank"));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack handStack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)handStack);
        }
        if (CardItem.isBound(handStack)) {
            if (player.isShiftKeyDown()) {
                CardItem.clear(handStack);
                player.displayClientMessage((Component)Component.translatable((String)"item.numismatics.id_card.tooltip.cleared"), true);
                return InteractionResultHolder.success((Object)handStack);
            }
        } else {
            CardItem.set(handStack, player.getUUID());
            level.playSound(null, new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ()), SoundEvents.ARROW_HIT_PLAYER, SoundSource.BLOCKS, 0.5f, 1.0f);
            player.displayClientMessage((Component)Component.translatable((String)"item.numismatics.id_card.tooltip.bound"), true);
            return InteractionResultHolder.success((Object)handStack);
        }
        return InteractionResultHolder.pass((Object)handStack);
    }
}

