/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.google.common.collect.ImmutableMap;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsDataComponents;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class CoinItem
extends Item {
    public final Coin coin;

    protected CoinItem(Item.Properties properties, Coin coin) {
        super(properties);
        this.coin = coin;
    }

    public static NonNullFunction<Item.Properties, CoinItem> create(Coin coin) {
        return properties -> new CoinItem((Item.Properties)properties, coin);
    }

    public static boolean extract(Player player, InteractionHand hand, Coin coin, boolean onlyHand) {
        return CoinItem.extract(player, hand, coin, false, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Map<Coin, Integer> coins, boolean onlyHand) {
        return CoinItem.extract(player, hand, coins, false, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Coin coin, boolean simulate, boolean onlyHand) {
        return CoinItem.extract(player, hand, (Map<Coin, Integer>)ImmutableMap.of((Object)((Object)coin), (Object)1), simulate, onlyHand);
    }

    public static boolean extract(Player player, InteractionHand hand, Map<Coin, Integer> coins, boolean simulate, boolean onlyHand) {
        if (!simulate && !CoinItem.extract(player, hand, coins, true, onlyHand)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<ItemStack> inventoryList = new ArrayList<ItemStack>();
        if (onlyHand) {
            inventoryList.add(player.getItemInHand(hand));
        } else {
            inventoryList.addAll((Collection<ItemStack>)player.getInventory().items);
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(Container container, Map<Coin, Integer> coins, boolean simulate) {
        if (!simulate && !CoinItem.extract(container, coins, true)) {
            return false;
        }
        DiscreteCoinBag coinBag = DiscreteCoinBag.of(coins);
        ArrayList<ItemStack> inventoryList = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            inventoryList.add(container.getItem(i));
        }
        return CoinItem.extract(inventoryList, coinBag, simulate);
    }

    public static boolean extract(List<ItemStack> inventoryList, Map<Coin, Integer> coins, boolean simulate) {
        return CoinItem.extract(inventoryList, DiscreteCoinBag.of(coins), simulate);
    }

    private static boolean extract(List<ItemStack> inventoryList, DiscreteCoinBag coinBag, boolean simulate) {
        for (ItemStack stack : inventoryList) {
            if (coinBag.isEmpty()) {
                return true;
            }
            Item item = stack.getItem();
            if (!(item instanceof CoinItem)) continue;
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int needed = coinBag.getDiscrete(coin);
            if (needed == 0) continue;
            int available = stack.getCount();
            int extracted = Math.min(needed, available);
            coinBag.subtract(coin, extracted);
            if (simulate) continue;
            stack.setCount(stack.getCount() - extracted);
        }
        return coinBag.isEmpty();
    }

    public static ItemStack setDisplayedCount(ItemStack stack, int amt) {
        stack.set(NumismaticsDataComponents.COIN_DISPLAYED_COUNT, (Object)amt);
        return stack;
    }

    public static ItemStack clearDisplayedCount(ItemStack stack) {
        stack.remove(NumismaticsDataComponents.COIN_DISPLAYED_COUNT);
        return stack;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
        Coin descriptor = this.coin.getDescription();
        if (descriptor == Coin.SPUR) {
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.coin.tooltip.value.basic", (Object[])new Object[]{this.coin.value}));
        } else {
            int relativeValue = this.coin.value / descriptor.value;
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.coin.tooltip.value", (Object[])new Object[]{relativeValue, descriptor.getName(relativeValue), this.coin.value}));
        }
        int displayedCount = (Integer)stack.getOrDefault(NumismaticsDataComponents.COIN_DISPLAYED_COUNT, (Object)0);
        if (displayedCount > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.numismatics.coin.tooltip.count", (Object[])new Object[]{TextUtils.formatInt(displayedCount), this.coin.getName(displayedCount)}).withStyle(ChatFormatting.GOLD));
        }
    }
}

