/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorBlockEntity;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlockEntities;
import dev.ithundxr.createnumismatics.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BrassDepositorBlock
extends AbstractDepositorBlock<BrassDepositorBlockEntity> {
    public BrassDepositorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<BrassDepositorBlockEntity> getBlockEntityClass() {
        return BrassDepositorBlockEntity.class;
    }

    public BlockEntityType<BrassDepositorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NumismaticsBlockEntities.BRASS_DEPOSITOR.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hitResult.getDirection().getAxis().isVertical()) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.isTrusted(player, (BlockGetter)level, pos)) {
                this.withBlockEntityDo((BlockGetter)level, pos, be -> Utils.openScreen((ServerPlayer)player, be, arg_0 -> ((BrassDepositorBlockEntity)be).sendToMenu(arg_0)));
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue((Property)HORIZONTAL_FACING) != hitResult.getDirection()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() || ((Boolean)state.getValue((Property)LOCKED)).booleanValue()) {
            return ItemInteractionResult.FAIL;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        SliderStylePriceBehaviour priceBehaviour = (SliderStylePriceBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, SliderStylePriceBehaviour.TYPE);
        if (priceBehaviour != null && priceBehaviour.deduct(player, hand, true)) {
            this.activate(state, level, pos);
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"gui.numismatics.vendor.insufficient_funds").withStyle(ChatFormatting.DARK_RED), true);
            level.playSound(null, pos, AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return ItemInteractionResult.CONSUME;
    }
}

