/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import dev.ithundxr.createnumismatics.base.client.rendering.GuiBlockEntityRenderBuilder;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceConfigurationPacket;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity;
import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsGuiTextures;
import dev.ithundxr.createnumismatics.registry.packets.VendorConfigurationPacket;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VendorScreen
extends AbstractSimiContainerScreen<VendorMenu> {
    private IconButton trustListButton;
    private IconButton confirmButton;
    private NumismaticsGuiTextures background;
    private final ItemStack renderedItem;
    private final int COIN_COUNT = Coin.values().length;
    private final Label[] coinLabels = new Label[this.COIN_COUNT];
    private final ScrollInput[] coinScrollInputs = new ScrollInput[this.COIN_COUNT];
    private Label modeLabel;
    private SelectionScrollInput modeScrollInput;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public VendorScreen(VendorMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.renderedItem = ((VendorBlockEntity)container.contentHolder).isCreativeVendor() ? NumismaticsBlocks.CREATIVE_VENDOR.asStack() : NumismaticsBlocks.VENDOR.asStack();
        this.background = ((VendorBlockEntity)container.contentHolder).isCreativeVendor() ? NumismaticsGuiTextures.CREATIVE_VENDOR : NumismaticsGuiTextures.VENDOR;
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-20, 0);
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        this.trustListButton = new IconButton(x + 7, y + 121, (ScreenElement)AllIcons.I_VIEW_SCHEDULE);
        this.trustListButton.withCallback(() -> ((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).openTrustList());
        this.addRenderableWidget((GuiEventListener)this.trustListButton);
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.onClose());
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        for (Coin coin : Coin.values()) {
            int i = coin.ordinal();
            int baseX = x + 36 + (i < 3 ? 0 : 140);
            int yIncrement = 22;
            int baseY = y + 45 + yIncrement * (i % 3);
            this.coinLabels[i] = new Label(baseX + 18, baseY + 5, CommonComponents.EMPTY).withShadow();
            this.addRenderableWidget((GuiEventListener)this.coinLabels[i]);
            this.coinScrollInputs[i] = new ScrollInput(baseX, baseY, 36, 18).withRange(0, 129).writingTo(this.coinLabels[i]).titled(Component.literal((String)TextUtils.titleCaseConversion(coin.getName(0)))).calling(value -> {
                ((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).setPrice(coin, (int)value);
                this.coinLabels[i].setX(baseX + 18 - this.font.width((FormattedText)this.coinLabels[i].text) / 2);
            });
            this.addRenderableWidget((GuiEventListener)this.coinScrollInputs[i]);
            this.coinScrollInputs[i].setState(((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).getPrice(coin));
            this.coinScrollInputs[i].onChanged();
        }
        this.modeLabel = new Label(x + 90 + 3, y + 40 + 5, CommonComponents.EMPTY).withShadow();
        this.addRenderableWidget((GuiEventListener)this.modeLabel);
        this.modeScrollInput = new SelectionScrollInput(x + 90, y + 40, 46, 18);
        this.modeScrollInput.forOptions(VendorBlockEntity.Mode.getComponents());
        this.modeScrollInput.writingTo(this.modeLabel);
        this.modeScrollInput.titled(Component.translatable((String)"block.numismatics.vendor.tooltip.mode"));
        this.modeScrollInput.calling(idx -> ((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).setMode(VendorBlockEntity.Mode.values()[idx]));
        this.addRenderableWidget((GuiEventListener)this.modeScrollInput);
        this.modeScrollInput.setState(((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).getMode().ordinal());
        this.modeScrollInput.onChanged();
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 68, 84, 84));
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.height + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.leftPos;
        int y = this.topPos;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + this.background.width + 6), (float)(y + this.background.height - 70), -200.0f)).scale(5.0).render(graphics);
        ((GuiGameElement.GuiRenderBuilder)GuiBlockEntityRenderBuilder.of((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).at(x + this.background.width + 6, y + this.background.height - 90, -230.0f)).scale(5.0).render(graphics);
        graphics.drawCenteredString(this.font, this.title, x + (this.background.width - 8) / 2, y + 3, 0xFFFFFF);
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        MutableComponent balanceLabel = Component.translatable((String)"block.numismatics.brass_depositor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        graphics.drawCenteredString(this.font, (Component)balanceLabel, x + (this.background.width - 8) / 2, y + 21, 0xFFFFFF);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (((VendorMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && !this.hoveredSlot.hasItem()) {
            MutableComponent component = null;
            if (this.hoveredSlot.index == VendorMenu.SELLING_SLOT_INDEX) {
                component = Component.translatable((String)"block.numismatics.vendor.tooltip.trade_item");
            } else if (VendorMenu.INV_START_INDEX <= this.hoveredSlot.index && this.hoveredSlot.index < VendorMenu.INV_END_INDEX) {
                component = Component.translatable((String)"block.numismatics.vendor.tooltip.stock");
            }
            if (component != null) {
                guiGraphics.renderTooltip(this.font, (Component)component, x, y);
            }
        }
    }

    public void removed() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SliderStylePriceConfigurationPacket((SyncedBlockEntity)((VendorMenu)this.menu).contentHolder));
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new VendorConfigurationPacket(((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).getBlockPos(), ((VendorBlockEntity)((VendorMenu)this.menu).contentHolder).getMode()));
        super.removed();
    }
}

