/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;

public class DeductCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder forceLiteral = Commands.literal((String)"force");
        ArgumentBuilder baseLiteral = ((LiteralArgumentBuilder)Commands.literal((String)"deduct").requires(cs -> cs.hasPermission(2))).then(DeductCommand.register(forceLiteral, true));
        return DeductCommand.register(baseLiteral, false);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(ArgumentBuilder<CommandSourceStack, ?> parent, boolean force) {
        return parent.then(Commands.literal((String)"banker").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("There is no Blaze Banker at " + pos.toShortString())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return DeductCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.toShortString() + ")", amount, force);
        })).then(Commands.argument((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            BlockPos pos = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("There is no Blaze Banker at " + pos.toShortString())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return DeductCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.toShortString() + ")", amount, force, coin);
        }))))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection accounts = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += DeductCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), amount, force);
            }
            return sum;
        })).then(Commands.argument((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            Collection accounts = GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += DeductCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), amount, force, coin);
            }
            return sum;
        }))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name, int amount, boolean force) {
        return DeductCommand.execute(ctx, account, type, create, name, amount, force, Coin.SPUR);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name, int amount, boolean force, Coin coin) {
        int spurValue = coin.toSpurs(amount);
        int result = DeductCommand.deduct(account, spurValue, force, create, type);
        if (result == 1) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Deducted " + amount + " " + coin.getName(amount) + " to " + name + ".")), true);
            return spurValue;
        }
        if (result == -1) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Could not find account for " + name + ".")));
        } else if (force) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Force-deducted " + amount + " " + coin.getName(amount) + " from " + name + ".")), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("Could not deduct " + amount + " " + coin.getName(amount) + " from " + name + ".")));
        }
        return result;
    }

    private static int deduct(UUID id, int amount, boolean force, boolean create, BankAccount.Type type) {
        BankAccount account;
        BankAccount bankAccount = account = create ? Numismatics.BANK.getOrCreateAccount(id, type) : Numismatics.BANK.getAccount(id);
        if (account == null) {
            return -1;
        }
        return account.deduct(amount, force) ? 1 : 0;
    }
}

