/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.util;

import com.google.gson.JsonParser;
import dev.ithundxr.createnumismatics.NumismaticsClient;
import dev.ithundxr.createnumismatics.multiloader.Env;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.mutable.MutableObject;

public enum UsernameUtils {
    INSTANCE;

    private final HashMap<UUID, String> uuidNameMap = new HashMap();
    private final Set<UUID> tried = new HashSet<UUID>();
    private static final String url = "https://sessionserver.mojang.com/session/minecraft/profile/";

    public String getName(UUID uuid) {
        return this.getName(uuid, (String)(uuid == null ? "Unknown" : "[id=" + String.valueOf(uuid) + "]"));
    }

    public String getName(UUID uuid, String defaultName) {
        if (uuid == null) {
            return defaultName;
        }
        if (!this.uuidNameMap.containsKey(uuid)) {
            MutableObject result = new MutableObject(null);
            Env.CLIENT.runIfCurrent(() -> () -> {
                if (Minecraft.getInstance().getUser().getProfileId().equals(uuid)) {
                    this.uuidNameMap.put(uuid, Minecraft.getInstance().getUser().getName());
                    result.setValue((Object)this.uuidNameMap.get(uuid));
                }
                if (NumismaticsClient.bankAccountLabels.containsKey(uuid)) {
                    result.setValue((Object)NumismaticsClient.bankAccountLabels.get(uuid));
                }
            });
            if (result.getValue() != null) {
                return (String)result.getValue();
            }
            if (!this.tried.contains(uuid)) {
                CompletableFuture.runAsync(() -> {
                    try (HttpClient client = HttpClient.newHttpClient();){
                        HttpRequest request = HttpRequest.newBuilder(URI.create(url + uuid.toString().replace("-", ""))).GET().build();
                        try {
                            String body = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).join().body();
                            this.uuidNameMap.put(uuid, JsonParser.parseString((String)body).getAsJsonObject().get("name").getAsString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.tried.add(uuid);
            }
            return defaultName;
        }
        return this.uuidNameMap.get(uuid);
    }
}

