/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui;

import de.fabiexe.paperui.Button;
import de.fabiexe.paperui.property.BooleanProperty;
import de.fabiexe.paperui.property.ComponentProperty;
import de.fabiexe.paperui.property.DialogProperty;
import de.fabiexe.paperui.property.DoubleProperty;
import de.fabiexe.paperui.property.EnumProperty;
import de.fabiexe.paperui.property.FloatProperty;
import de.fabiexe.paperui.property.IntegerProperty;
import de.fabiexe.paperui.property.Property;
import de.fabiexe.paperui.property.StringProperty;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.data.dialog.type.NoticeType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogUI<T extends Audience> {
    protected final T audience;
    private boolean opened = false;
    private Component title = Component.empty();
    private final List<DialogBody> body = new CopyOnWriteArrayList<DialogBody>();
    private final List<DialogProperty<?>> properties = new CopyOnWriteArrayList();
    private final List<Button> buttons = new CopyOnWriteArrayList<Button>();
    private final List<Button> actionButtons = new CopyOnWriteArrayList<Button>();

    public DialogUI(@NotNull T audience) {
        this.audience = audience;
    }

    public void open() {
        NoticeType type;
        ArrayList<DialogInput> inputs = new ArrayList<DialogInput>();
        for (DialogProperty<?> property : this.properties) {
            property.populate(inputs);
        }
        if (this.buttons.isEmpty()) {
            type = switch (this.actionButtons.size()) {
                case 0 -> DialogType.notice();
                case 1 -> DialogType.notice((ActionButton)this.createButton(this.actionButtons.getFirst()));
                default -> DialogType.confirmation((ActionButton)this.createButton(this.actionButtons.getFirst()), (ActionButton)this.createButton(this.actionButtons.get(1)));
            };
        } else {
            type = DialogType.multiAction(this.buttons.stream().map(this::createButton).toList()).build();
        }
        this.opened = true;
        this.audience.showDialog((DialogLike)Dialog.create(arg_0 -> this.lambda$open$0(inputs, (DialogType)type, arg_0)));
    }

    private ActionButton createButton(Button button) {
        ActionButton.Builder builder = ActionButton.builder((Component)button.label());
        if (button.tooltip() != null) {
            builder.tooltip(button.tooltip());
        }
        if (button.action() != null) {
            builder.action((DialogAction)DialogAction.customClick((response, ignored) -> {
                if (!this.opened) {
                    return;
                }
                this.opened = false;
                for (DialogProperty<?> property : this.properties) {
                    property.read(response);
                }
                button.action().run();
            }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).build())));
        }
        return builder.build();
    }

    private Component miniMessage(String text) {
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    public void title(@NotNull Component title) {
        this.title = title;
    }

    public void title(@NotNull String title) {
        this.title = this.miniMessage(title);
    }

    public void text(@NotNull Component text) {
        this.body.add((DialogBody)DialogBody.plainMessage((Component)text));
    }

    public void text(@NotNull String text) {
        this.text(this.miniMessage(text));
    }

    public void text(@NotNull Component text, int maxWidth) {
        this.body.add((DialogBody)DialogBody.plainMessage((Component)text, (int)maxWidth));
    }

    public void text(@NotNull String text, int maxWidth) {
        this.text(this.miniMessage(text), maxWidth);
    }

    public void item(@NotNull ItemStack itemStack, boolean decorations, boolean tooltip) {
        this.body.add((DialogBody)DialogBody.item((ItemStack)itemStack).showDecorations(decorations).showTooltip(tooltip).build());
    }

    public void item(@NotNull ItemStack itemStack) {
        this.item(itemStack, true, false);
    }

    public void item(@NotNull ItemStack itemStack, boolean decorations, boolean tooltip, @NotNull Component description) {
        this.body.add((DialogBody)DialogBody.item((ItemStack)itemStack).showDecorations(decorations).showTooltip(tooltip).description(DialogBody.plainMessage((Component)description)).build());
    }

    public void item(@NotNull ItemStack itemStack, boolean decorations, boolean tooltip, @NotNull String description) {
        this.item(itemStack, decorations, tooltip, this.miniMessage(description));
    }

    public void item(@NotNull ItemStack itemStack, @NotNull Component description) {
        this.item(itemStack, true, false, description);
    }

    public void item(@NotNull ItemStack itemStack, @NotNull String description) {
        this.item(itemStack, this.miniMessage(description));
    }

    public void item(@NotNull ItemStack itemStack, boolean decorations, boolean tooltip, @NotNull Component description, int maxDescriptionWidth) {
        this.body.add((DialogBody)DialogBody.item((ItemStack)itemStack).showDecorations(decorations).showTooltip(tooltip).description(DialogBody.plainMessage((Component)description, (int)maxDescriptionWidth)).build());
    }

    public void item(@NotNull ItemStack itemStack, boolean decorations, boolean tooltip, @NotNull String description, int maxDescriptionWidth) {
        this.item(itemStack, decorations, tooltip, this.miniMessage(description), maxDescriptionWidth);
    }

    public void item(@NotNull ItemStack itemStack, @NotNull Component description, int maxDescriptionWidth) {
        this.item(itemStack, true, false, description, maxDescriptionWidth);
    }

    public void item(@NotNull ItemStack itemStack, @NotNull String description, int maxDescriptionWidth) {
        this.item(itemStack, this.miniMessage(description), maxDescriptionWidth);
    }

    public <P> DialogProperty<P> property(@NotNull DialogProperty<P> property) {
        this.properties.add(property);
        return property;
    }

    private String propertyKey() {
        return "property_" + this.properties.size();
    }

    public Property<Boolean> booleanProperty(@NotNull Component label) {
        return this.property(new BooleanProperty(this.propertyKey(), label, null));
    }

    public Property<Boolean> booleanProperty(@NotNull String label) {
        return this.booleanProperty(this.miniMessage(label));
    }

    public Property<Boolean> booleanProperty(@NotNull Component label, boolean value) {
        return this.property(new BooleanProperty(this.propertyKey(), label, value));
    }

    public Property<Boolean> booleanProperty(@NotNull String label, boolean value) {
        return this.booleanProperty(this.miniMessage(label), value);
    }

    public Property<Component> componentProperty(@NotNull Component label, int maxLines) {
        return this.property(new ComponentProperty(this.propertyKey(), label, 1, null));
    }

    public Property<Component> componentProperty(@NotNull String label, int maxLines) {
        return this.componentProperty(this.miniMessage(label), maxLines);
    }

    public Property<Component> componentProperty(@NotNull Component label) {
        return this.componentProperty(label, 1);
    }

    public Property<Component> componentProperty(@NotNull String label) {
        return this.componentProperty(this.miniMessage(label));
    }

    public Property<Component> componentProperty(@NotNull Component label, int maxLines, @Nullable Component value) {
        return this.property(new ComponentProperty(this.propertyKey(), label, maxLines, value));
    }

    public Property<Component> componentProperty(@NotNull String label, int maxLines, @Nullable Component value) {
        return this.componentProperty(this.miniMessage(label), maxLines, value);
    }

    public Property<Component> componentProperty(@NotNull Component label, @Nullable Component value) {
        return this.property(new ComponentProperty(this.propertyKey(), label, 1, value));
    }

    public Property<Component> componentProperty(@NotNull String label, @Nullable Component value) {
        return this.componentProperty(this.miniMessage(label), value);
    }

    public Property<Double> doubleProperty(@NotNull Component label, double min, double max) {
        return this.property(new DoubleProperty(this.propertyKey(), label, min, max, null));
    }

    public Property<Double> doubleProperty(@NotNull String label, double min, double max) {
        return this.doubleProperty(this.miniMessage(label), min, max);
    }

    public Property<Double> doubleProperty(@NotNull Component label, double min, double max, double value) {
        return this.property(new DoubleProperty(this.propertyKey(), label, min, max, value));
    }

    public Property<Double> doubleProperty(@NotNull String label, double min, double max, double value) {
        return this.doubleProperty(this.miniMessage(label), min, max, value);
    }

    public <E> Property<E> enumProperty(@NotNull Component label, @NotNull Function<E, Component> nameFunction, @NotNull E[] values2) {
        return this.property(new EnumProperty<Object>(this.propertyKey(), label, values2, nameFunction, null));
    }

    public <E> Property<E> enumProperty(@NotNull String label, @NotNull Function<E, Component> nameFunction, @NotNull E[] values2) {
        return this.enumProperty(this.miniMessage(label), nameFunction, values2);
    }

    public <E> Property<E> enumProperty(@NotNull Component label, @NotNull Function<E, Component> nameFunction, @NotNull E[] values2, @NotNull E value) {
        return this.property(new EnumProperty<E>(this.propertyKey(), label, values2, nameFunction, value));
    }

    public <E> Property<E> enumProperty(@NotNull String label, @NotNull Function<E, Component> nameFunction, @NotNull E[] values2, @NotNull E value) {
        return this.enumProperty(this.miniMessage(label), nameFunction, values2, value);
    }

    private <E> E[] values(Class<E> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            valuesMethod.setAccessible(true);
            return (Object[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <E extends Enum<E>> Component name(E value) {
        return Component.text((String)String.join((CharSequence)" ", List.of(value.name().split("_")).stream().filter(Predicate.not(String::isEmpty)).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).toList()));
    }

    public <E extends Enum<E>> Property<E> enumProperty(@NotNull Component label, @NotNull Class<E> enumClass) {
        return this.property(new EnumProperty<Object>(this.propertyKey(), label, (Enum[])this.values(enumClass), this::name, null));
    }

    public <E extends Enum<E>> Property<E> enumProperty(@NotNull String label, @NotNull Class<E> enumClass) {
        return this.enumProperty(this.miniMessage(label), enumClass);
    }

    public <E extends Enum<E>> Property<E> enumProperty(@NotNull Component label, @NotNull Class<E> enumClass, @NotNull E value) {
        return this.property(new EnumProperty<Enum>(this.propertyKey(), label, (Enum[])this.values(enumClass), this::name, value));
    }

    public <E extends Enum<E>> Property<E> enumProperty(@NotNull String label, @NotNull Class<E> enumClass, @NotNull E value) {
        return this.enumProperty(this.miniMessage(label), enumClass, value);
    }

    public Property<Float> floatProperty(@NotNull Component label, float min, float max) {
        return this.property(new FloatProperty(this.propertyKey(), label, min, max, null));
    }

    public Property<Float> floatProperty(@NotNull String label, float min, float max) {
        return this.floatProperty(this.miniMessage(label), min, max);
    }

    public Property<Float> floatProperty(@NotNull Component label, float min, float max, float value) {
        return this.property(new FloatProperty(this.propertyKey(), label, min, max, Float.valueOf(value)));
    }

    public Property<Float> floatProperty(@NotNull String label, float min, float max, float value) {
        return this.floatProperty(this.miniMessage(label), min, max, value);
    }

    public Property<Integer> integerProperty(@NotNull Component label, int min, int max) {
        return this.property(new IntegerProperty(this.propertyKey(), label, min, max, null));
    }

    public Property<Integer> integerProperty(@NotNull String label, int min, int max) {
        return this.integerProperty(this.miniMessage(label), min, max);
    }

    public Property<Integer> integerProperty(@NotNull Component label, int min, int max, int value) {
        return this.property(new IntegerProperty(this.propertyKey(), label, min, max, value));
    }

    public Property<Integer> integerProperty(@NotNull String label, int min, int max, int value) {
        return this.integerProperty(this.miniMessage(label), min, max, value);
    }

    public Property<String> stringProperty(@NotNull Component label, int maxLines) {
        return this.property(new StringProperty(this.propertyKey(), label, 1, null));
    }

    public Property<String> stringProperty(@NotNull String label, int maxLines) {
        return this.stringProperty(this.miniMessage(label), maxLines);
    }

    public Property<String> stringProperty(@NotNull Component label) {
        return this.stringProperty(label, 1);
    }

    public Property<String> stringProperty(@NotNull String label) {
        return this.stringProperty(this.miniMessage(label));
    }

    public Property<String> stringProperty(@NotNull Component label, int maxLines, @Nullable String value) {
        return this.property(new StringProperty(this.propertyKey(), label, maxLines, value));
    }

    public Property<String> stringProperty(@NotNull String label, int maxLines, @Nullable String value) {
        return this.stringProperty(this.miniMessage(label), maxLines, value);
    }

    public Property<String> stringProperty(@NotNull Component label, @Nullable String value) {
        return this.property(new StringProperty(this.propertyKey(), label, 1, value));
    }

    public Property<String> stringProperty(@NotNull String label, @Nullable String value) {
        return this.stringProperty(this.miniMessage(label), value);
    }

    private String buttonKey() {
        if (this.actionButtons.size() > 1) {
            throw new IllegalStateException("You cannot have normal buttons and more than one action button");
        }
        return "button_" + this.buttons.size();
    }

    public void button(@NotNull Component label) {
        this.buttons.add(new Button(this.buttonKey(), label, null, null));
    }

    public void button(@NotNull String label) {
        this.button(this.miniMessage(label));
    }

    public void button(@NotNull Component label, @NotNull Component tooltip) {
        this.buttons.add(new Button(this.buttonKey(), label, tooltip, null));
    }

    public void button(@NotNull String label, @NotNull String tooltip) {
        this.button(this.miniMessage(label), this.miniMessage(tooltip));
    }

    public void button(@NotNull Component label, @NotNull Runnable action) {
        this.buttons.add(new Button(this.buttonKey(), label, null, action));
    }

    public void button(@NotNull String label, @NotNull Runnable action) {
        this.button(this.miniMessage(label), action);
    }

    public void button(@NotNull Component label, @NotNull Component tooltip, @NotNull Runnable action) {
        this.buttons.add(new Button(this.buttonKey(), label, tooltip, action));
    }

    public void button(@NotNull String label, @NotNull String tooltip, @NotNull Runnable action) {
        this.button(this.miniMessage(label), this.miniMessage(tooltip), action);
    }

    private String actionButtonKey() {
        if (this.actionButtons.size() == 1 && !this.buttons.isEmpty()) {
            throw new IllegalStateException("You cannot have normal buttons and more than one action button");
        }
        return "actionbutton_" + this.buttons.size();
    }

    public void actionButton(@NotNull Component label) {
        this.actionButtons.add(new Button(this.actionButtonKey(), label, null, null));
    }

    public void actionButton(@NotNull String label) {
        this.actionButton(this.miniMessage(label));
    }

    public void actionButton(@NotNull Component label, @NotNull Component tooltip) {
        this.actionButtons.add(new Button(this.actionButtonKey(), label, tooltip, null));
    }

    public void actionButton(@NotNull String label, @NotNull String tooltip) {
        this.actionButton(this.miniMessage(label), this.miniMessage(tooltip));
    }

    public void actionButton(@NotNull Component label, @NotNull Runnable action) {
        this.actionButtons.add(new Button(this.actionButtonKey(), label, null, action));
    }

    public void actionButton(@NotNull String label, @NotNull Runnable action) {
        this.actionButton(this.miniMessage(label), action);
    }

    public void actionButton(@NotNull Component label, @NotNull Component tooltip, @NotNull Runnable action) {
        this.actionButtons.add(new Button(this.actionButtonKey(), label, tooltip, action));
    }

    public void actionButton(@NotNull String label, @NotNull String tooltip, @NotNull Runnable action) {
        this.actionButton(this.miniMessage(label), this.miniMessage(tooltip), action);
    }

    private /* synthetic */ void lambda$open$0(List inputs, DialogType type, RegistryBuilderFactory builder) {
        ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)this.title).inputs(inputs).body(this.body).build()).type(type);
    }
}

