/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import de.fabiexe.paperui.command.OrderCoffeCommand;
import de.fabiexe.paperui.command.OrderDrugsCommand;
import de.fabiexe.paperui.command.OrderPhoneCommand;
import de.fabiexe.paperui.command.OrderPizzaCommand;
import io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PaperUIPlugin
extends JavaPlugin {
    private static PaperUIPlugin instance;
    private PacketEventsAPI<?> packetEventsAPI = null;

    public void onLoad() {
        instance = this;
        if (PacketEvents.getAPI() == null) {
            this.packetEventsAPI = SpigotPacketEventsBuilder.build((Plugin)this);
            PacketEvents.setAPI(this.packetEventsAPI);
            this.packetEventsAPI.load();
        }
    }

    public void onEnable() {
        if (this.packetEventsAPI != null) {
            this.packetEventsAPI.init();
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, this::registerCommands);
    }

    public void onDisable() {
        if (this.packetEventsAPI != null) {
            this.packetEventsAPI.terminate();
        }
    }

    private void registerCommands(@NotNull @NotNull ReloadableRegistrarEvent<@NotNull Commands> event) {
        String enableDevCommands = System.getProperty("PAPERUI_ENABLE_DEV_COMMANDS");
        if (enableDevCommands != null && enableDevCommands.equals("true")) {
            ((Commands)event.registrar()).register(OrderCoffeCommand.create());
            ((Commands)event.registrar()).register(OrderDrugsCommand.create());
            ((Commands)event.registrar()).register(OrderPhoneCommand.create());
            ((Commands)event.registrar()).register(OrderPizzaCommand.create());
        }
    }

    @NotNull
    public PacketEventsAPI<?> getPacketEventsAPI() {
        return this.packetEventsAPI;
    }

    @NotNull
    public static PaperUIPlugin getInstance() {
        return instance;
    }
}

