/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui;

import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import de.fabiexe.paperui.SpatialButton;
import de.fabiexe.paperui.SpatialText;
import de.fabiexe.paperui.property.MutableProperty;
import de.fabiexe.paperui.property.SpatialUIProperty;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.level.World;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpatialUI {
    protected final Player audience;
    private final PacketEventsAPI<?> packetEventsAPI;
    private final Location location;
    private final BlockFace direction;
    private Runnable content = () -> {};
    private boolean shown = false;
    private final List<SpatialText> texts = new CopyOnWriteArrayList<SpatialText>();
    private final List<SpatialButton> buttons = new CopyOnWriteArrayList<SpatialButton>();
    private final List<Display.TextDisplay> textDisplays = new CopyOnWriteArrayList<Display.TextDisplay>();
    private final List<Interaction> interactions = new CopyOnWriteArrayList<Interaction>();

    public SpatialUI(@NotNull Player audience, @NotNull PacketEventsAPI<?> packetEventsAPI, @NotNull Location location, @NotNull BlockFace direction) {
        this.audience = audience;
        this.packetEventsAPI = packetEventsAPI;
        packetEventsAPI.getEventManager().registerListener((PacketListener)new InteractionListener(), PacketListenerPriority.NORMAL);
        this.location = location;
        this.direction = direction;
    }

    public void show() {
        if (this.shown) {
            return;
        }
        this.render();
        this.shown = true;
    }

    public void hide() {
        if (!this.shown) {
            return;
        }
        for (Display.TextDisplay textDisplay : this.textDisplays) {
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerDestroyEntities(textDisplay.ar()));
        }
        this.textDisplays.clear();
        for (Interaction interaction : this.interactions) {
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerDestroyEntities(interaction.ar()));
        }
        this.interactions.clear();
        this.shown = false;
    }

    public void render() {
        this.texts.clear();
        this.buttons.clear();
        this.content.run();
        int textDisplayIndex = 0;
        for (SpatialText spatialText : this.texts) {
            Integer backgroundColor;
            Vector offset = spatialText.position.clone().add(new Vector(0.0, 0.0, 0.001));
            offset = new Vector(offset.getX() * (double)this.direction.getModZ() + offset.getZ() * (double)this.direction.getModX(), offset.getY(), -offset.getX() * (double)this.direction.getModX() + offset.getZ() * (double)this.direction.getModZ());
            offset.add(new Vector(0.0, switch (spatialText.verticalAlignment.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> -0.25;
                case 1 -> -0.125;
                case 2 -> 0.0;
            }, 0.0));
            Location textLocation = this.location.clone().setDirection(this.direction.getDirection()).add(offset);
            TextDisplay textDisplay = (TextDisplay)this.prepareTextDisplay(textDisplayIndex, textLocation).getBukkitEntity();
            boolean changed = false;
            if (!textDisplay.text().equals((Object)spatialText.text)) {
                textDisplay.text(spatialText.text);
                changed = true;
            }
            if (textDisplay.getAlignment() != spatialText.textAlignment) {
                textDisplay.setAlignment(spatialText.textAlignment);
                changed = true;
            }
            Integer n = backgroundColor = textDisplay.getBackgroundColor() != null ? Integer.valueOf(textDisplay.getBackgroundColor().asARGB()) : null;
            if (!Objects.equals(backgroundColor, spatialText.backgroundColor)) {
                if (spatialText.backgroundColor == null) {
                    textDisplay.setBackgroundColor(null);
                } else {
                    textDisplay.setBackgroundColor(Color.fromRGB((int)spatialText.backgroundColor));
                }
                changed = true;
            }
            if (changed) {
                this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerEntityMetadata(textDisplay.getEntityId(), SpigotReflectionUtil.getEntityMetadata((Entity)textDisplay)));
            }
            ++textDisplayIndex;
        }
        int interactionIndex = 0;
        for (SpatialButton button : this.buttons) {
            Vector offset = button.position.clone().add(new Vector(0.0, 0.0, button.width / -2.0 + 0.001));
            offset = new Vector(offset.getX() * (double)this.direction.getModZ() + offset.getZ() * (double)this.direction.getModX(), offset.getY(), -offset.getX() * (double)this.direction.getModX() + offset.getZ() * (double)this.direction.getModZ());
            Location location = this.location.clone().setDirection(this.direction.getDirection()).add(offset);
            Interaction interaction = this.prepareInteraction(interactionIndex, location);
            boolean changed = false;
            if ((double)interaction.f() != button.width) {
                interaction.a((float)button.width);
                changed = true;
            }
            if ((double)interaction.i() != button.height) {
                interaction.b((float)button.height);
                changed = true;
            }
            if (changed) {
                this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerEntityMetadata(interaction.ar(), SpigotReflectionUtil.getEntityMetadata((Entity)interaction.getBukkitEntity())));
            }
            ++interactionIndex;
        }
        while (textDisplayIndex < this.textDisplays.size()) {
            Display.TextDisplay textDisplay = this.textDisplays.remove(textDisplayIndex);
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerDestroyEntities(textDisplay.ar()));
        }
        while (interactionIndex < this.interactions.size()) {
            Interaction interaction = this.interactions.remove(interactionIndex);
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerDestroyEntities(interaction.ar()));
        }
    }

    private Display.TextDisplay prepareTextDisplay(int i, Location location) {
        if (i < this.textDisplays.size()) {
            Display.TextDisplay textDisplay = this.textDisplays.get(i);
            textDisplay.a_(location.getX(), location.getY(), location.getZ());
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerEntityTeleport(textDisplay.ar(), SpigotConversionUtil.fromBukkitLocation((Location)location), false));
            return this.textDisplays.get(i);
        }
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        Display.TextDisplay textDisplay = new Display.TextDisplay(EntityTypes.bx, (World)level);
        this.textDisplays.add(textDisplay);
        this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerSpawnEntity(textDisplay.ar(), textDisplay.cK(), com.github.retrooper.packetevents.protocol.entity.type.EntityTypes.TEXT_DISPLAY, SpigotConversionUtil.fromBukkitLocation((Location)location), 0.0f, 0, new Vector3d()));
        return textDisplay;
    }

    private Interaction prepareInteraction(int i, Location location) {
        if (i < this.interactions.size()) {
            Interaction interaction = this.interactions.get(i);
            interaction.a_(location.getX(), location.getY(), location.getZ());
            interaction.b(location.getYaw(), location.getPitch());
            this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerEntityTeleport(interaction.ar(), SpigotConversionUtil.fromBukkitLocation((Location)location), false));
            return this.interactions.get(i);
        }
        WorldServer level = ((CraftWorld)location.getWorld()).getHandle();
        Interaction interaction = new Interaction(EntityTypes.aq, (World)level);
        this.interactions.add(interaction);
        this.packetEventsAPI.getPlayerManager().sendPacket((Object)this.audience, (PacketWrapper)new WrapperPlayServerSpawnEntity(interaction.ar(), interaction.cK(), com.github.retrooper.packetevents.protocol.entity.type.EntityTypes.INTERACTION, SpigotConversionUtil.fromBukkitLocation((Location)location), 0.0f, 0, new Vector3d()));
        return interaction;
    }

    @NotNull
    public Runnable content() {
        return this.content;
    }

    public void content(@NotNull Runnable content) {
        this.content = content;
    }

    public <T> MutableProperty<T> property(T value) {
        return new SpatialUIProperty<T>(this, value);
    }

    public <T> MutableProperty<T> property() {
        return this.property(null);
    }

    private Component miniMessage(String text) {
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    @NotNull
    public SpatialText text(double x, double y, @NotNull Component text, @Nullable Integer backgroundColor) {
        SpatialText spatialText = new SpatialText(new Vector(x, y, 0.0), VerticalAlignment.BOTTOM, text, TextDisplay.TextAlignment.CENTER, backgroundColor);
        this.texts.add(spatialText);
        return spatialText;
    }

    @NotNull
    public SpatialText text(double x, double y, @NotNull String text, @Nullable Integer backgroundColor) {
        return this.text(x, y, this.miniMessage(text), backgroundColor);
    }

    @NotNull
    public SpatialText text(double x, double y, @NotNull Component text) {
        return this.text(x, y, text, null);
    }

    @NotNull
    public SpatialText text(double x, double y, @NotNull String text) {
        return this.text(x, y, this.miniMessage(text), null);
    }

    @NotNull
    public SpatialButton button(double x, double y, double width, double height, @NotNull Runnable onClick) {
        return this.button(x, y, width, height, onClick);
    }

    private class InteractionListener
    implements PacketListener {
        private InteractionListener() {
        }

        public void onPacketReceive(@NotNull PacketReceiveEvent event) {
            if (!SpatialUI.this.shown) {
                return;
            }
            if (event.getPlayer() != SpatialUI.this.audience) {
                return;
            }
            if (event.getPacketType() != PacketType.Play.Client.INTERACT_ENTITY) {
                return;
            }
            WrapperPlayClientInteractEntity packet = new WrapperPlayClientInteractEntity(event);
            if (packet.getAction() != WrapperPlayClientInteractEntity.InteractAction.INTERACT) {
                return;
            }
            int entityId = packet.getEntityId();
            for (int i = 0; i < SpatialUI.this.interactions.size(); ++i) {
                if (SpatialUI.this.interactions.get(i).ar() != entityId) continue;
                SpatialUI.this.buttons.get((int)i).onClick.run();
                SpatialUI.this.audience.swingMainHand();
                event.setCancelled(true);
                return;
            }
        }
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

