/*
 * Decompiled with CFR 0.152.
 */
package de.fabiexe.paperui.property;

import de.fabiexe.paperui.property.DialogProperty;
import io.papermc.paper.dialog.DialogResponseView;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentProperty
implements DialogProperty<Component> {
    private final String key;
    private final Component label;
    private final int maxLines;
    private Component value;

    public ComponentProperty(@NotNull String key, @NotNull Component label, int maxLines, @Nullable Component value) {
        this.key = key;
        this.label = label;
        this.maxLines = maxLines;
        this.value = value;
    }

    @Override
    @NotNull
    public Component get() {
        if (this.value == null) {
            throw new IllegalStateException("There is no value present");
        }
        return this.value;
    }

    @Override
    public void read(@NotNull DialogResponseView response) {
        this.value = MiniMessage.miniMessage().deserialize((Object)response.getText(this.key));
    }

    @Override
    public void populate(@NotNull List<DialogInput> inputs) {
        TextDialogInput.Builder builder = DialogInput.text((String)this.key, (Component)this.label);
        if (this.maxLines != 1) {
            builder.multiline(TextDialogInput.MultilineOptions.create((Integer)this.maxLines, null));
        }
        if (this.value != null) {
            builder.initial((String)MiniMessage.miniMessage().serialize(this.value));
        }
        inputs.add((DialogInput)builder.build());
    }
}

